/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.export;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.fi.gl.report.export.processor.AbstractBatchTransformer;

public class AccBalRowTransformer
extends AbstractBatchTransformer<Row, Row> {
    Object[] totalRowValues = null;

    public AccBalRowTransformer(int batchSize) {
        super(batchSize);
    }

    protected List<Row> process(List<Row> batchEntries) {
        for (Row row : batchEntries) {
            int i;
            if (!Objects.equals(row.getString("rowtype"), "9")) continue;
            RowMeta rowMeta = (RowMeta)this.getOwnedChain().getContextProp("rowMeta");
            if (Objects.isNull(this.totalRowValues)) {
                this.totalRowValues = new Object[rowMeta.getFieldCount()];
                for (i = 0; i < rowMeta.getFieldCount(); ++i) {
                    this.totalRowValues[i] = row.get(i);
                }
                continue;
            }
            for (i = 0; i < rowMeta.getFieldCount(); ++i) {
                if (!(row.get(i) instanceof BigDecimal)) continue;
                BigDecimal totalValue = (BigDecimal)this.totalRowValues[i];
                this.totalRowValues[i] = totalValue.add(row.getBigDecimal(i));
            }
        }
        batchEntries.removeIf(x -> Objects.equals(x.getString("rowtype"), "9"));
        if (this.isLastBatchFlag()) {
            RowMeta rowMeta = (RowMeta)this.getOwnedChain().getContextProp("rowMeta");
            DataSet totalDataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(Collections.singletonList(this.totalRowValues).iterator(), rowMeta);
            batchEntries.add(totalDataSet.next());
        }
        return batchEntries;
    }
}

