/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.export;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.service.balance.account.IAccountTreeModel;
import kd.fi.bd.util.BDUtil;

public class BalanceSumService {
    public static DataSet sumAccountBalance(DataSet balanceDataSet, IAccountTreeModel accountModel, QueryParam param, String acctSelector, String oriSelector, Integer level) {
        String[] accountCols;
        balanceDataSet = BalanceSumService.levelSumAccountBalance(balanceDataSet, accountModel, param, level);
        String acctSel = acctSelector;
        List resultCols = BDUtil.getDataSetCols((DataSet)balanceDataSet);
        resultCols.removeIf(str -> str.equalsIgnoreCase("parent"));
        if (acctSel.trim().length() == 0) {
            accountCols = null;
        } else {
            accountCols = acctSel.replaceFirst(", id", "").split(",");
            for (int i = 0; i < accountCols.length; ++i) {
                String[] sel = accountCols[i].trim().split(" ");
                if (sel.length <= 1) continue;
                accountCols[i] = sel[1].trim();
            }
        }
        QFilter qFilter = new QFilter("id", "in", (Object)accountModel.getDisplayAccountIds());
        DataSet acctDataSet = QueryServiceHelper.queryDataSet((String)(BalanceSumService.class.getName() + ".account"), (String)"bd_accountview", (String)acctSelector, (QFilter[])qFilter.toArray(), null);
        balanceDataSet = balanceDataSet.join(acctDataSet, JoinType.INNER).on("account", "id").select(resultCols.toArray(new String[0]), accountCols).finish();
        oriSelector = oriSelector.replace("account.isleaf", "_tag_leaf").replace("account.", "");
        balanceDataSet = balanceDataSet.select(oriSelector);
        return balanceDataSet;
    }

    private static DataSet levelSumAccountBalance(DataSet balance, IAccountTreeModel accountModel, QueryParam param, Integer level) {
        boolean notSumAssgrp = false;
        Field[] fields = balance.getRowMeta().getFields();
        HashSet<String> sumFieldSet = new HashSet<String>();
        HashSet<String> groupFieldSet = new HashSet<String>();
        ArrayList<String> selectSet = new ArrayList<String>();
        HashSet<String> leftSelectSet = new HashSet<String>();
        for (Field field : fields) {
            String name = field.getName().toLowerCase();
            if (!param.isSumAssgrp() && "assgrp".equals(name)) {
                notSumAssgrp = true;
                continue;
            }
            selectSet.add(name);
            if (!"account".equalsIgnoreCase(name)) {
                leftSelectSet.add(name);
            }
            if (field.getDataType() instanceof BigDecimalType || "count".equalsIgnoreCase(name)) {
                sumFieldSet.add(name);
                continue;
            }
            groupFieldSet.add(name);
        }
        String[] groupFields = groupFieldSet.toArray(new String[0]);
        String[] sumFields = sumFieldSet.toArray(new String[0]);
        String[] selector = selectSet.toArray(new String[0]);
        String[] leftSelector = leftSelectSet.toArray(new String[0]);
        return BalanceSumService.accountSum(balance, notSumAssgrp, groupFields, sumFields, selector, leftSelector, accountModel, level);
    }

    private static DataSet accountSum(DataSet balance, boolean notSumAssgrp, String[] groupFields, String[] sumFields, String[] selector, String[] leftSelector, IAccountTreeModel accountModel, Integer level) {
        DataSet ds;
        DataSet pacctDataSet = balance;
        DataSet sumDataSet = null;
        boolean existParent = false;
        for (Object[] acc : accountModel.getAccountTreeData()) {
            if (acc[2] == null) continue;
            existParent = true;
            break;
        }
        DataSet upperTreeDataSet = accountModel.getTreeDataSet();
        if (!Objects.equals(-1, level)) {
            upperTreeDataSet = upperTreeDataSet.filter(" level > " + level);
        }
        while (existParent && (ds = pacctDataSet.copy().join(upperTreeDataSet.copy(), JoinType.INNER).on("org", "org").on("account", "id").select(leftSelector, new String[]{"parent account"}).finish().filter("account !=0")).hasNext()) {
            GroupbyDataSet group = ds.groupBy(groupFields);
            GroupbyDataSet groupbyDataSet = sumFields;
            int n = ((GroupbyDataSet)groupbyDataSet).length;
            for (int i = 0; i < n; ++i) {
                GroupbyDataSet sumField = groupbyDataSet[i];
                group.sum((String)sumField);
            }
            pacctDataSet = group.finish().select(selector);
            if (Objects.equals(-1, level)) {
                sumDataSet = sumDataSet == null ? pacctDataSet : sumDataSet.union(pacctDataSet);
                continue;
            }
            sumDataSet = pacctDataSet;
        }
        if (sumDataSet != null) {
            GroupbyDataSet group = sumDataSet.groupBy(groupFields);
            for (String sumField : sumFields) {
                group.sum(sumField);
            }
            sumDataSet = group.finish().select(selector);
            if (notSumAssgrp) {
                sumDataSet = sumDataSet.addField("0L", "assgrp");
                List cols = BDUtil.getDataSetCols((DataSet)balance);
                sumDataSet = sumDataSet.select(cols.toArray(new String[0]));
            }
            DataSet lowerTreeDataSet = accountModel.getTreeDataSet().copy();
            if (!Objects.equals(-1, level)) {
                lowerTreeDataSet = lowerTreeDataSet.filter(" level <= " + level);
            }
            balance = balance.join(lowerTreeDataSet, JoinType.INNER).on("org", "org").on("account", "id").select(leftSelector, new String[]{"id account"}).finish().filter("account !=0").select(selector);
            return balance.addField("true", "_tag_leaf").union(sumDataSet.addField("false", "_tag_leaf"));
        }
        return balance.addField("true", "_tag_leaf");
    }
}

