/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.treelist;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import kd.fi.gl.report.accbalance.treelist.ColIndex;
import kd.fi.gl.report.accbalance.treelist.RowWrapGroup;

public class RowWrap {
    private RowWrapGroup rowGroup;
    private Object[] data;
    private int level = 0;
    private RowType rowType;
    private List<Object[]> assistRows = new ArrayList<Object[]>();
    private List<Object[]> measureunitRows = new ArrayList<Object[]>();

    public RowWrap(RowWrapGroup rowGroup, Object[] data, RowType rowType) {
        this.rowGroup = rowGroup;
        this.data = data;
        this.rowType = rowType;
    }

    public RowWrap() {
    }

    public void refineTreeAttr(ColIndex colIndex) {
        if (this.rowGroup.isAllCurrency()) {
            this.data[colIndex.getRowid()] = this.join(new int[]{colIndex.getAccountId(), colIndex.getCurrencyId(), colIndex.getOrgId()});
            this.data[colIndex.getPid()] = this.join(new int[]{colIndex.getAccountId(), colIndex.getCurrencyId(), colIndex.getPorgid()});
            if (RowType.CURRENCY_SUM == this.rowType || RowType.ORG_SUM == this.rowType) {
                this.data[colIndex.getIsgroupnode()] = true;
            }
        } else {
            this.data[colIndex.getRowid()] = this.join(new int[]{colIndex.getAccountId(), colIndex.getOrgId()});
            this.data[colIndex.getPid()] = this.join(new int[]{colIndex.getAccountId(), colIndex.getPorgid()});
            if (RowType.ACCOUNT_SUM == this.rowType || RowType.CURRENCY_SUM == this.rowType || RowType.ORG_SUM == this.rowType) {
                this.data[colIndex.getIsgroupnode()] = true;
            }
        }
        if (RowType.ACCOUNT_SUM == this.rowType || RowType.CURRENCY_SUM == this.rowType || RowType.SINGLE == this.rowType) {
            this.data[colIndex.getPid()] = "0";
        }
        StringBuilder formatOrgName = new StringBuilder();
        for (int i = 0; i < this.getLevel(); ++i) {
            formatOrgName.append("  ");
        }
        formatOrgName.append(this.data[colIndex.getForgName()]);
        this.data[colIndex.getForgName()] = formatOrgName.toString();
        if (RowType.DETAIL == this.rowType) {
            this.data[colIndex.getIsgroupnode()] = false;
        } else {
            this.data[colIndex.getOrgName()] = this.getDataItem(colIndex.getOrgName());
        }
    }

    public <T> T getDataItem(int itemIndex) {
        return (T)this.data[itemIndex];
    }

    public String join(int[] indexes) {
        return this.join(this.data, indexes);
    }

    public String join(Object[] data, int[] indexes) {
        HashSet valueSet = new HashSet(indexes.length);
        Arrays.stream(indexes).forEach(x -> valueSet.add(x >= 0 && null != data[x] ? data[x].toString() : ""));
        return String.join((CharSequence)"", valueSet);
    }

    public String joinAssistgrp(Object[] data, ColIndex colIndex, int[] commonIndex) {
        int commonLen = commonIndex.length;
        int[] indexes = new int[commonLen + colIndex.getComassists().size() + 2];
        System.arraycopy(commonIndex, 0, indexes, 0, commonLen);
        for (int i = 0; i < colIndex.getComassists().size(); ++i) {
            indexes[commonLen + i] = colIndex.getComassists().get(i);
        }
        indexes[indexes.length - 2] = colIndex.getMeasureunit();
        indexes[indexes.length - 1] = colIndex.getOrgId();
        HashSet valueSet = new HashSet(indexes.length);
        Arrays.stream(indexes).forEach(x -> valueSet.add(x >= 0 && null != data[x] ? data[x].toString() : ""));
        return String.join((CharSequence)"", valueSet);
    }

    public void setAmountDataItem(int itemIndex, BigDecimal value) {
        this.data[itemIndex] = value;
    }

    public void setDataItem(int itemIndex, Object value) {
        this.data[itemIndex] = value;
    }

    public Object[] getData() {
        return this.data;
    }

    public boolean isDetail() {
        return RowType.DETAIL == this.getRowType() || RowType.SINGLE == this.getRowType();
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void addAssistRow(Object[] assistRow) {
        this.assistRows.add(assistRow);
    }

    public List<Object[]> getAssistRows() {
        return this.assistRows;
    }

    public List<Object[]> getMeasureunitRows() {
        return this.measureunitRows;
    }

    public void addMeasureunitRow(Object[] measureunitRow) {
        this.measureunitRows.add(measureunitRow);
    }

    public RowWrap cloneRow() {
        return new RowWrap(this.rowGroup, (Object[])this.data.clone(), RowType.ORG_SUM);
    }

    public RowType getRowType() {
        return this.rowType;
    }

    public void setRowType(RowType rowType) {
        this.rowType = rowType;
    }

    public static enum RowType {
        TOTAL,
        ACCOUNT_SUM,
        ORG_SUM,
        CURRENCY_SUM,
        ASSIST_SUM,
        DETAIL,
        SINGLE;

    }
}

