/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.treelist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.accbalance.treelist.ColIndex;
import kd.fi.gl.report.accbalance.treelist.RowWrapGroup;
import kd.fi.gl.util.DataSetHelper;

public class TreeReportHelper {
    private static final Log logger = LogFactory.getLog(TreeReportHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSet rebuildDataBySumUpView(DataSet rawDs, MulOrgQPRpt qpRpt) {
        rawDs = TreeReportHelper.appendOrgInfo(rawDs, qpRpt);
        if (DebugTrace.enable()) {
            DataSetHelper.logDataSet((String)"accbalance appendorg data", (DataSet)rawDs);
        }
        RowMeta rowMeta = rawDs.getRowMeta();
        ColIndex colIndex = ColIndex.instance(rowMeta);
        int cols = rowMeta.getFieldCount();
        try {
            Map<String, RowWrapGroup> accRowGrpMap = TreeReportHelper.buildrowWrapGroup(rawDs, colIndex, qpRpt, cols);
            accRowGrpMap.values().stream().forEach(x -> x.rebuildRow(qpRpt, colIndex));
            Field[] newFields = new Field[cols + 5];
            for (int i = 0; i < cols; ++i) {
                newFields[i] = rowMeta.getField(i);
            }
            newFields[colIndex.getOrgName()] = new Field("orgname", (DataType)DataType.StringType);
            newFields[colIndex.getForgName()] = new Field("forgname", (DataType)DataType.StringType);
            newFields[colIndex.getRowid()] = new Field("rowid", (DataType)DataType.StringType);
            newFields[colIndex.getPid()] = new Field("pid", (DataType)DataType.StringType);
            newFields[colIndex.getIsgroupnode()] = new Field("isgroupnode", (DataType)DataType.BooleanType);
            Algo algo = Algo.create((String)"TreeReportHelper.rebuildDataBySumUpView");
            DataSetBuilder builder = algo.createDataSetBuilder(new RowMeta(newFields));
            ArrayList<RowWrapGroup> sortedAccRowGrps = new ArrayList<RowWrapGroup>(accRowGrpMap.values());
            sortedAccRowGrps.sort(Comparator.comparingInt(RowWrapGroup::getSequence));
            sortedAccRowGrps.stream().forEach(rowGrp -> rowGrp.getRows().forEach(row -> {
                String orgName;
                builder.append(row.getData());
                if (!row.getAssistRows().isEmpty()) {
                    row.getData()[colIndex.getIsgroupnode()] = true;
                    orgName = (String)row.getDataItem(colIndex.getOrgName());
                    if (!orgName.startsWith("<nolink>")) {
                        row.getData()[colIndex.getOrgName()] = "<nolink>" + orgName;
                    }
                    row.getAssistRows().stream().forEach(subrow -> {
                        if (qpRpt.isAllCurrency()) {
                            subrow[colIndex.getRowid()] = row.joinAssistgrp((Object[])subrow, colIndex, new int[]{colIndex.getAccountId(), colIndex.getCurrencyId(), colIndex.getAssgrp()});
                            subrow[colIndex.getPid()] = row.join((Object[])subrow, new int[]{colIndex.getAccountId(), colIndex.getCurrencyId(), colIndex.getOrgId()});
                        } else {
                            subrow[colIndex.getRowid()] = row.joinAssistgrp((Object[])subrow, colIndex, new int[]{colIndex.getAccountId(), colIndex.getAssgrp()});
                            subrow[colIndex.getPid()] = row.join((Object[])subrow, new int[]{colIndex.getAccountId(), colIndex.getOrgId()});
                        }
                        subrow[colIndex.getIsgroupnode()] = false;
                        subrow[colIndex.getOrgName()] = orgName.replaceAll("<nolink>", "");
                        subrow[colIndex.getForgName()] = "  " + row.getDataItem(colIndex.getForgName());
                        builder.append(subrow);
                    });
                }
                if (!row.getMeasureunitRows().isEmpty()) {
                    row.getData()[colIndex.getIsgroupnode()] = true;
                    orgName = (String)row.getDataItem(colIndex.getOrgName());
                    if (!orgName.startsWith("<nolink>")) {
                        row.getData()[colIndex.getOrgName()] = "<nolink>" + orgName;
                    }
                    row.getMeasureunitRows().stream().forEach(subrow -> {
                        if (qpRpt.isAllCurrency()) {
                            subrow[colIndex.getRowid()] = row.join((Object[])subrow, new int[]{colIndex.getAccountId(), colIndex.getCurrencyId(), colIndex.getMeasureunit(), colIndex.getOrgId()});
                            subrow[colIndex.getPid()] = row.join((Object[])subrow, new int[]{colIndex.getAccountId(), colIndex.getCurrencyId(), colIndex.getOrgId()});
                        } else {
                            subrow[colIndex.getRowid()] = row.join((Object[])subrow, new int[]{colIndex.getAccountId(), colIndex.getMeasureunit(), colIndex.getOrgId()});
                            subrow[colIndex.getPid()] = row.join((Object[])subrow, new int[]{colIndex.getAccountId(), colIndex.getOrgId()});
                        }
                        subrow[colIndex.getIsgroupnode()] = false;
                        subrow[colIndex.getOrgName()] = orgName.replaceAll("<nolink>", "");
                        subrow[colIndex.getForgName()] = "  " + row.getDataItem(colIndex.getForgName());
                        builder.append(subrow);
                    });
                }
            }));
            DataSet dataSet = builder.build();
            return dataSet;
        }
        finally {
            rawDs.close();
        }
    }

    private static Map<String, RowWrapGroup> buildrowWrapGroup(DataSet ds, ColIndex colIndex, MulOrgQPRpt qpRpt, int cols) {
        int newDsCols = cols + 5;
        Object[] totalValues = null;
        int rowIndex = 0;
        HashMap<String, RowWrapGroup> accRowGrpMap = new HashMap<String, RowWrapGroup>(128);
        while (ds.hasNext()) {
            long orgId;
            boolean hasComAssist;
            String key;
            Row row = ds.next();
            Object[] values = new Object[newDsCols];
            for (int i = 0; i < cols; ++i) {
                values[i] = row.get(i);
            }
            if (Objects.isNull(row.get(colIndex.getAccountId()))) {
                totalValues = values;
                continue;
            }
            long accId = row.getLong(colIndex.getAccountId());
            long currencyId = 0L;
            if (qpRpt.isAllCurrency() && Objects.nonNull(row.get(colIndex.getCurrencyId()))) {
                currencyId = row.getLong(colIndex.getCurrencyId());
            }
            if (Objects.isNull(accRowGrpMap.get(key = String.format("%s_%s", accId, currencyId)))) {
                accRowGrpMap.put(key, new RowWrapGroup(rowIndex, accId, currencyId, qpRpt.isAllCurrency()));
            }
            boolean bl = hasComAssist = !colIndex.getComassists().isEmpty() && colIndex.getComassists().stream().anyMatch(x -> Objects.nonNull(row.get(x.intValue())));
            if (colIndex.getAssgrp() > 0 && Objects.nonNull(row.get(colIndex.getAssgrp())) || hasComAssist) {
                orgId = row.getLong(colIndex.getOrgId());
                ((RowWrapGroup)accRowGrpMap.get(key)).getDetailRowByOrgId(orgId).addAssistRow(values);
            } else if (colIndex.getMeasureunit() > 0 && Objects.nonNull(row.get(colIndex.getMeasureunit()))) {
                orgId = row.getLong(colIndex.getOrgId());
                ((RowWrapGroup)accRowGrpMap.get(key)).getDetailRowByOrgId(orgId).addMeasureunitRow(values);
            } else {
                ((RowWrapGroup)accRowGrpMap.get(key)).addRow(values, colIndex);
            }
            ++rowIndex;
        }
        if (Objects.nonNull(totalValues)) {
            String totalKey = String.format("%s_%s", Long.MAX_VALUE, 0);
            accRowGrpMap.put(totalKey, new RowWrapGroup(rowIndex, Long.MAX_VALUE, 0L, qpRpt.isAllCurrency()));
            ((RowWrapGroup)accRowGrpMap.get(totalKey)).addRow(totalValues, colIndex);
        }
        return accRowGrpMap;
    }

    public static DataSet appendOrgInfo(DataSet oriDataSet, MulOrgQPRpt qpRpt) {
        String selectFields = "org orgid,parent porgid,isleaf";
        try (DataSet orgDataSet = BatchProcessUtil.batchQueryDataSet((int)10000, (Collection)qpRpt.getChildOrg(), k -> QueryServiceHelper.queryDataSet((String)"TreeReportHelper.appendOrgInfo", (String)"bos_org_structure", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("view.treetype", "=", (Object)"10"), new QFilter("view", "=", (Object)qpRpt.getOrgViewId()), new QFilter("org", "in", k)}, (String)"level asc"));){
            oriDataSet = oriDataSet.join(orgDataSet, JoinType.LEFT).on("org", "orgid").select(TreeReportHelper.getDataSetCols(oriDataSet, new ArrayList<String>(0)).toArray(new String[0]), new String[]{"porgid"}).finish();
            ArrayList<String> orderList = new ArrayList<String>();
            orderList.add("number");
            if (qpRpt.isShowCurrency()) {
                orderList.add("currency");
            }
            if (qpRpt.isShowOrg() || qpRpt.isShowOrgTree()) {
                orderList.add("org");
            }
            if (qpRpt.isShowAssist()) {
                orderList.add("assgrp");
            }
            if (qpRpt.isShowQty()) {
                orderList.add("measureunit");
            }
            DataSet dataSet = oriDataSet = oriDataSet.orderBy(orderList.toArray(new String[0]));
            return dataSet;
        }
    }

    public static List<String> getDataSetCols(DataSet ds, List<String> filterFields) {
        RowMeta rowMeta = ds.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<String> list = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            if (filterFields.contains(field.getName())) continue;
            list.add(field.getName());
        }
        return list;
    }

    public static List<String> printDataSet(DataSet dataSet) {
        return TreeReportHelper.printDataSet(dataSet, null);
    }

    public static List<String> printDataSet(DataSet dataSet, List<String> printCols) {
        return TreeReportHelper.printDataSet(dataSet, null, printCols);
    }

    public static List<String> printDataSet(DataSet dataSet, Integer maxRows, List<String> oriPrintCols) {
        Iterator iter;
        int rowIndex;
        Field[] printFieldArr;
        List<String> printCols;
        if (Objects.isNull(dataSet)) {
            return Collections.singletonList("null");
        }
        if (Objects.isNull(maxRows)) {
            maxRows = 100;
        }
        int[] colWidths = null;
        int[] charMaxSizes = null;
        int colCount = 0;
        try (DataSet dataSetCopy = dataSet.copy();){
            int i;
            RowMeta rowType = dataSetCopy.getRowMeta();
            printCols = Objects.isNull(oriPrintCols) ? Arrays.asList(rowType.getFieldNames()) : new ArrayList<String>(oriPrintCols);
            Iterator<String> it = printCols.iterator();
            while (it.hasNext()) {
                if (Arrays.asList(rowType.getFieldNames()).contains(it.next())) continue;
                it.remove();
            }
            colCount = printCols.size();
            printFieldArr = new Field[colCount];
            for (i = 0; i < printFieldArr.length; ++i) {
                printFieldArr[i] = rowType.getField(printCols.get(i));
            }
            colWidths = new int[colCount];
            charMaxSizes = new int[colCount];
            for (i = 0; i < colCount; ++i) {
                String colAlias = printFieldArr[i].getAlias();
                int colWidth = colAlias.length() > 4 ? colAlias.length() : 4;
                colWidths[i] = StringUtils.isEmpty((String)colAlias) ? 10 : colWidth;
                charMaxSizes[i] = StringUtils.isEmpty((String)colAlias) ? 10 : colWidth;
            }
            rowIndex = 0;
            iter = dataSetCopy.iterator();
            while (iter.hasNext()) {
                if (++rowIndex > maxRows) {
                    break;
                }
                Row row = (Row)iter.next();
                for (int i2 = 0; i2 < colCount; ++i2) {
                    Object value = row.get(printFieldArr[i2].getAlias());
                    if (!Objects.nonNull(value)) continue;
                    String valueStr = String.valueOf(value);
                    int length = 0;
                    if (!StringUtils.isEmpty((String)valueStr)) {
                        for (char c : valueStr.toCharArray()) {
                            if (!TreeReportHelper.isChinese(c)) {
                                ++length;
                                continue;
                            }
                            length += 2;
                        }
                    }
                    if (length > colWidths[i2]) {
                        colWidths[i2] = length;
                    }
                    if (valueStr.length() <= charMaxSizes[i2]) continue;
                    charMaxSizes[i2] = valueStr.length();
                }
            }
        }
        StringBuilder formatBuilder = new StringBuilder();
        for (int i = 0; i < colWidths.length; ++i) {
            formatBuilder.append('%').append(colWidths[i]).append("s|");
        }
        ArrayList<String> lines = new ArrayList<String>(maxRows);
        try (DataSet dataSetCopy = dataSet.copy();){
            lines.add(String.format(formatBuilder.toString(), printCols.toArray()));
            rowIndex = 0;
            iter = dataSetCopy.iterator();
            while (iter.hasNext()) {
                if (++rowIndex > maxRows) {
                    break;
                }
                Row row = (Row)iter.next();
                Object[] rowValues = new Object[colCount];
                int[] nonEngCharCnts = new int[colCount];
                for (int i = 0; i < colCount; ++i) {
                    Object value = row.get(printFieldArr[i].getAlias());
                    rowValues[i] = Objects.isNull(value) ? "null" : String.valueOf(value);
                    int nonEngCharCnt = 0;
                    for (char c : String.valueOf(rowValues[i]).toCharArray()) {
                        if (!TreeReportHelper.isChinese(c)) continue;
                        ++nonEngCharCnt;
                    }
                    nonEngCharCnts[i] = nonEngCharCnt;
                }
                StringBuilder rowFormatBuilder = new StringBuilder();
                for (int i = 0; i < colWidths.length; ++i) {
                    rowFormatBuilder.append('%').append(colWidths[i] - nonEngCharCnts[i]).append("s|");
                }
                lines.add(String.format(rowFormatBuilder.toString(), rowValues));
            }
        }
        return lines;
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static String getRowidExpr(DataSet rawDs) {
        RowMeta rowMeta = rawDs.getRowMeta();
        StringBuilder rowidExpr = new StringBuilder("concat(");
        Arrays.asList("accountnumber", "currency", "assgrp", "measureunit", "org").stream().forEach(x -> {
            if (rowMeta.getFieldIndex(x, false) >= 0) {
                rowidExpr.append("String(").append((String)x).append("),");
            }
        });
        Arrays.stream(rowMeta.getFieldNames()).forEach(x -> {
            if (x.startsWith("comassist")) {
                rowidExpr.append("String(").append((String)x).append("),");
            }
        });
        rowidExpr.replace(rowidExpr.lastIndexOf(","), rowidExpr.length(), ")");
        return rowidExpr.toString();
    }
}

