/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.business.service.PeriodService;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.accbalance.v2.AccBalQueryUtil;
import kd.fi.gl.report.accbalance.v2.collect.TreeNodeUtil;
import kd.fi.gl.util.AccountUtils;

public class AcctLevelTree {
    private final Map<String, List<Long>> leafLongNum2Mid;
    private final Set<Long> leafIds;
    private final boolean selectAllNum;

    AcctLevelTree(long acctTableId, Date date, Set<String> acctLongNumRange, QFilter extFilter) {
        boolean largeNumSelected;
        QFilter filter = extFilter;
        this.selectAllNum = acctLongNumRange == null;
        boolean bl = largeNumSelected = acctLongNumRange != null && acctLongNumRange.size() > 10;
        if (acctLongNumRange != null && acctLongNumRange.size() > 0 && !largeNumSelected) {
            QFilter numF = QFilter.of((String)acctLongNumRange.stream().map(num -> "longnumber like '" + num + "%' ").collect(Collectors.joining(" or ")), (Object[])new Object[0]);
            if (filter != null) {
                filter.and(numF);
            } else {
                filter = numF;
            }
        }
        this.leafLongNum2Mid = new TreeMap<String, List<Long>>();
        this.leafIds = new HashSet<Long>();
        AccountUtils.getAccountDataSet((long)acctTableId, (Date)date, (boolean)true, (QFilter)filter, (String[])new String[]{"longnumber", "masterid", "id"}).forEach(r -> {
            block3: {
                Long mid;
                String longNum;
                block2: {
                    longNum = r.getString("longnumber");
                    mid = r.getLong("masterid");
                    if (!largeNumSelected) break block2;
                    if (!TreeNodeUtil.getAllSuperLevelTable(Sets.newHashSet((Object[])new String[]{longNum}), '_').values().stream().anyMatch(acctLongNumRange::contains)) break block3;
                }
                this.leafLongNum2Mid.computeIfAbsent(longNum, x -> new ArrayList()).add(mid);
                this.leafIds.add(r.getLong("id"));
            }
        });
    }

    public static AcctLevelTree create(MulOrgQPRpt param) {
        return AcctLevelTree.create(param, null);
    }

    public static AcctLevelTree create(MulOrgQPRpt param, QFilter extFilter) {
        Date endDate = PeriodService.getEndDate((long)param.getEndPeriod());
        DynamicObjectCollection acctDos = param.getFilterInfo().getDynamicObjectCollection("account");
        HashSet<String> selectedAcctNums = new HashSet<String>();
        if (acctDos != null) {
            acctDos.forEach(dyo -> selectedAcctNums.add(dyo.getString("longnumber")));
        } else if (param.isHideUnused()) {
            List<QFilter> balFilters = AccBalQueryUtil.getBalBaseFilters(param, param.getAllEntityOrgSet(), null);
            QueryServiceHelper.queryDataSet((String)"AcctLevelTree", (String)"gl_acctbalance", (String)"account.longnumber longnumber", (QFilter[])balFilters.toArray(new QFilter[0]), null).forEach(r -> selectedAcctNums.add(r.getString("longnumber")));
        }
        return new AcctLevelTree(param.getAccountTable(), endDate, selectedAcctNums.isEmpty() ? null : selectedAcctNums, extFilter);
    }

    public TreeMap<String, Set<Long>> getFirstLevelNum2ChildrenMid() {
        TreeMap<String, Set<Long>> res = new TreeMap<String, Set<Long>>(Comparator.comparing(x -> x));
        this.leafLongNum2Mid.forEach((detailLongNum, mid) -> {
            String firstLevelNum = detailLongNum;
            int endIndex = detailLongNum.indexOf("_");
            if (endIndex != -1) {
                firstLevelNum = detailLongNum.substring(0, endIndex);
            }
            Set mids = res.computeIfAbsent(firstLevelNum, x -> new HashSet());
            mids.addAll(mid);
        });
        return res;
    }

    public Map<String, List<Long>> getLeafLongNum2Mid() {
        return this.leafLongNum2Mid;
    }

    public Set<Long> getLeafIds() {
        return this.leafIds;
    }

    public boolean isSelectAllNum() {
        return this.selectAllNum;
    }
}

