/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoException;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.PersistedArrayRow;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.LogFactory;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.model.BalGroup;
import kd.fi.gl.report.accbalance.v2.model.BalSumGroup;
import kd.fi.gl.report.accbalance.v2.model.BalanceRow;
import kd.fi.gl.util.GLApp;

public class PLBalanceCacheHelper {
    static DistributeSessionlessCache getCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    }

    public static void cache(String queryId, Map<BalGroup, BalanceRow> plBalMap) {
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("data", (DataType)DataType.StringType)});
        CachedDataSet.Builder builder = Algo.create((String)"PLBalanceCacheHelper").createCachedDataSetBuilder(rowMeta, CacheHint.getDefault());
        plBalMap.forEach((grp, row) -> {
            row.setBalSumGroup(grp.getBalSumGroup());
            row.setBalDetailGroup(grp.getBalDetailGroup());
            builder.append((Row)new PersistedArrayRow(rowMeta, new Object[]{SerializationUtils.serializeToBase64((Object)row)}, false));
        });
        String plBalCacheId = builder.build().getCacheId();
        PLBalanceCacheHelper.getCache().put(queryId + "#plBalCache", (Object)plBalCacheId);
    }

    public static Map<BalGroup, BalanceRow> getPlBalFromCache(AccBalQueryContext context, BalSumGroup sumGroup) {
        String plBalCacheId = (String)PLBalanceCacheHelper.getCache().get(context.getQueryId() + "#plBalCache");
        if (plBalCacheId != null) {
            try {
                HashMap<BalGroup, BalanceRow> res = new HashMap<BalGroup, BalanceRow>(128);
                CachedDataSet plBalCache = Algo.getCacheDataSet((String)plBalCacheId);
                plBalCache.iterator(0, plBalCache.getRowCount()).forEachRemaining(r -> {
                    BalanceRow row = (BalanceRow)SerializationUtils.deSerializeFromBase64((String)r.getString("data"));
                    if (row.getBalSumGroup().equals(sumGroup)) {
                        res.put(BalGroup.createGrp(context, row), row);
                    }
                });
                return res;
            }
            catch (AlgoException e) {
                LogFactory.getLog(PLBalanceCacheHelper.class).error((Throwable)e);
                LogFactory.getLog(PLBalanceCacheHelper.class).warn("cache id expired.");
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u7f13\u5b58\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u3002", (String)"PLBalanceCacheHelper_001", (String)GLApp.instance.reportModule(), (Object[])new Object[0]));
    }

    public static void clear(String queryId) {
        String plBalCacheId = (String)PLBalanceCacheHelper.getCache().get(queryId + "#plBalCache");
        if (plBalCacheId != null) {
            PLBalanceCacheHelper.getCache().remove(queryId + "#plBalCache");
            Algo.removeCacheDataSet((String)plBalCacheId);
        }
    }
}

