/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2;

import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.fi.gl.configuration.ReportConfiguration;

public class RowLimitManager {
    private final String cacheKey;
    private final AtomicInteger remainingRowSize;

    public RowLimitManager(String queryId) {
        this.cacheKey = queryId + "#rowSizeLeft";
        int rowSizeLeft = ReportConfiguration.ACCBAL_DISPLAY_LIMIT.getInt();
        String rowSizeLeftStr = (String)this.getCache().get(this.cacheKey);
        if (rowSizeLeftStr != null) {
            rowSizeLeft = Integer.parseInt(rowSizeLeftStr);
        }
        this.remainingRowSize = new AtomicInteger(rowSizeLeft);
    }

    final DistributeSessionlessCache getCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    }

    public boolean isOutOfRowLimit() {
        return this.remainingRowSize.get() <= 0;
    }

    public void increment() {
        this.remainingRowSize.incrementAndGet();
    }

    public boolean tryDecrement() {
        return !this.isOutOfRowLimit() && this.remainingRowSize.decrementAndGet() >= 0;
    }

    public void cacheResult() {
        this.getCache().put(this.cacheKey, (Object)this.remainingRowSize.toString());
    }
}

