/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.collect;

import java.util.Iterator;
import java.util.Map;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.RowLimitManager;
import kd.fi.gl.report.accbalance.v2.collect.CollectUtils;
import kd.fi.gl.report.accbalance.v2.collect.TotalCollectService;
import kd.fi.gl.report.accbalance.v2.ds.impl.DetailBalanceDS;
import kd.fi.gl.report.accbalance.v2.model.BalGroup;
import kd.fi.gl.report.accbalance.v2.model.BalSumGroup;
import kd.fi.gl.report.accbalance.v2.model.BalanceRow;
import kd.fi.gl.report.accbalance.v2.model.IBalanceRow;
import kd.fi.gl.report.accbalance.v2.model.RowType;
import kd.fi.gl.report.accbalance.v2.model.StateChart;

public class DetailBalCollectService {
    public static Iterator<BalanceRow> getData(BalSumGroup balSumGroup, Map<BalGroup, BalanceRow> plBalMap, AccBalQueryContext context) {
        Iterator<IBalanceRow> detailBalItr = new DetailBalanceDS(balSumGroup, context).getData();
        Iterator<BalanceRow> detailItr = DetailBalCollectService.get(balSumGroup, detailBalItr, plBalMap, context);
        if (plBalMap != null) {
            detailItr = DetailBalCollectService.filterEmptyRow(detailItr, context);
        }
        return detailItr;
    }

    private static Iterator<BalanceRow> filterEmptyRow(final Iterator<BalanceRow> detailItr, final AccBalQueryContext context) {
        return new Iterator<BalanceRow>(){
            private BalanceRow curRow;

            @Override
            public boolean hasNext() {
                while (this.curRow == null) {
                    if (!detailItr.hasNext()) {
                        return false;
                    }
                    this.curRow = (BalanceRow)detailItr.next();
                    if (CollectUtils.checkAmt(this.curRow, context.getQueryParam())) continue;
                    this.curRow = null;
                }
                return true;
            }

            @Override
            public BalanceRow next() {
                BalanceRow res = this.curRow;
                this.curRow = null;
                return res;
            }
        };
    }

    private static Iterator<BalanceRow> get(final BalSumGroup balSumGroup, final Iterator<IBalanceRow> rawDetailBal, final Map<BalGroup, BalanceRow> plBalMap, final AccBalQueryContext context) {
        final StateChart stateChart = context.getStateChart();
        final RowLimitManager rowLimit = context.getRowLimit();
        final TotalCollectService totalCollectService = context.getTotalCollectService();
        return new Iterator<BalanceRow>(){
            private BalGroup curGrp = null;
            private BalanceRow curRow = null;
            private Iterator<BalanceRow> remainedPlProfitRowItr;

            @Override
            public boolean hasNext() {
                boolean hasNext;
                boolean bl = hasNext = !rowLimit.isOutOfRowLimit() && (rawDetailBal.hasNext() || this.curRow != null);
                if (!hasNext) {
                    if (this.remainedPlProfitRowItr == null) {
                        this.remainedPlProfitRowItr = plBalMap.entrySet().stream().filter(e -> ((BalGroup)e.getKey()).getBalSumGroup().equals(balSumGroup)).map(Map.Entry::getValue).iterator();
                    }
                    hasNext = this.remainedPlProfitRowItr.hasNext();
                }
                if (!hasNext) {
                    rowLimit.cacheResult();
                    totalCollectService.cache();
                }
                return hasNext;
            }

            @Override
            public BalanceRow next() {
                BalanceRow res = null;
                if (this.remainedPlProfitRowItr != null && this.remainedPlProfitRowItr.hasNext()) {
                    res = this.remainedPlProfitRowItr.next();
                } else {
                    while (rawDetailBal.hasNext()) {
                        if (this.curRow == null) {
                            this.curRow = BalanceRow.create(context);
                        }
                        IBalanceRow nextRow = (IBalanceRow)rawDetailBal.next();
                        BalGroup nextGrp = new BalGroup(context, nextRow.getOrgId(), "", (Long)context.getShowAcctMidAndLongNum((Long)Long.valueOf((long)nextRow.getAccountMid())).item1, "", nextRow.getCurrencyId(), nextRow.getMeasureUnit(), nextRow.getAssgrpId(), nextRow.getComAssistIds());
                        if (this.curGrp == null) {
                            this.curGrp = nextGrp;
                        }
                        if (nextGrp.equals(this.curGrp)) {
                            CollectUtils.sumTo(this.curRow, nextRow, stateChart);
                            continue;
                        }
                        res = this.curRow;
                        res.setBalSumGroup(this.curGrp.getBalSumGroup());
                        res.setBalDetailGroup(this.curGrp.getBalDetailGroup());
                        if (plBalMap != null && plBalMap.containsKey(this.curGrp)) {
                            CollectUtils.sumTo(this.curRow, (IBalanceRow)plBalMap.get(this.curGrp), stateChart);
                        }
                        this.curRow = BalanceRow.create(context);
                        this.curGrp = nextGrp;
                        CollectUtils.sumTo(this.curRow, nextRow, stateChart);
                        break;
                    }
                    if (res == null && this.curRow != null) {
                        res = this.curRow;
                        res.setBalSumGroup(this.curGrp.getBalSumGroup());
                        res.setBalDetailGroup(this.curGrp.getBalDetailGroup());
                        if (plBalMap != null && plBalMap.containsKey(this.curGrp)) {
                            CollectUtils.sumTo(this.curRow, (IBalanceRow)plBalMap.get(this.curGrp), stateChart);
                        }
                        this.curRow = null;
                    }
                }
                if (res != null) {
                    rowLimit.tryDecrement();
                    res.setRowType(RowType.DETAIL_SUMMARY);
                    res.setAcctLongNum(context.getAcctLongNumByEntityOrgMid(res.getAccountMid()));
                    if (stateChart.isShowOrgTree()) {
                        res.setOrgLevel(context.getOrgLevelById(res.getOrgId()) - context.getMinParentLevel());
                    }
                    res.setAccountDc(context.getAcctDcByMid(res.getAccountMid()));
                    if (plBalMap != null && this.curGrp != null) {
                        plBalMap.remove(this.curGrp);
                    }
                }
                return res;
            }
        };
    }
}

