/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.collect.simplenode;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.accbalance.v2.AccBalActionTracer;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.collect.AbstractSumTreeNode;
import kd.fi.gl.report.accbalance.v2.collect.BalanceRowList;
import kd.fi.gl.report.accbalance.v2.collect.CollectUtils;
import kd.fi.gl.report.accbalance.v2.collect.ISumNode;
import kd.fi.gl.report.accbalance.v2.collect.TreeDataCollectService;
import kd.fi.gl.report.accbalance.v2.collect.simplenode.AccSumTreeNodeFactory;
import kd.fi.gl.report.accbalance.v2.collect.simplenode.DetailGroupNode;
import kd.fi.gl.report.accbalance.v2.collect.simplenode.RootNode;
import kd.fi.gl.report.accbalance.v2.model.BalDetailGroup;
import kd.fi.gl.report.accbalance.v2.model.BalanceRow;
import kd.fi.gl.report.accbalance.v2.model.IBalanceRow;
import kd.fi.gl.report.accbalance.v2.model.StateChart;

public abstract class AbstractAccBalNode
extends AbstractSumTreeNode<Object, IBalanceRow, List<BalanceRow>> {
    protected final AccBalQueryContext context = AccBalQueryContext.getCurrent();
    private final AccBalActionTracer tracer = AccBalActionTracer.get();
    private final Object value;
    protected BalanceRow mySumRow;

    public AbstractAccBalNode(Object value) {
        this.value = value;
        this.mySumRow = BalanceRow.create(this.context);
        this.tracer.logCreatingNode(this);
    }

    protected void enhanceChildData(BalanceRowList childRows) {
        if (this.mySumRow != null && !childRows.getAllData().isEmpty()) {
            childRows.getSumData().setPid(this.mySumRow.getRowId());
        }
    }

    protected BalanceRow enhanceSumData(BalanceRow mySumRow, List<BalanceRow> childRows) {
        if (mySumRow != null) {
            Class<ISumNode> childType;
            StateChart stateChart = this.context.getStateChart();
            if (!childRows.isEmpty()) {
                mySumRow.setSumRow(true);
            } else {
                MulOrgQPRpt queryParam = this.context.getQueryParam();
                List<Function<BalanceRow, BigDecimal>> amtGetters = CollectUtils.getCheckAmtGetters(queryParam);
                if (!CollectUtils.checkAmt(mySumRow, amtGetters)) {
                    mySumRow = null;
                    this.context.getRowLimit().increment();
                } else if (stateChart.isShowRptCurr()) {
                    CollectUtils.setRptAmt(mySumRow, this.context.getRptRate());
                }
            }
            if (mySumRow != null && DetailGroupNode.class.equals(childType = this.getChildType()) && CollectionUtils.isNotEmpty(childRows)) {
                mySumRow.setLink(false);
            }
        }
        return mySumRow;
    }

    protected void sumChildData(BalanceRow mySumRow, BalanceRowList singleChildData) {
        CollectUtils.sumAmtTo(mySumRow, singleChildData.getSumData(), this.context.getStateChart());
    }

    @Override
    protected void setLeafData(IBalanceRow balanceRow) {
        CollectUtils.sumAmtTo(this.mySumRow, balanceRow, this.context.getStateChart());
    }

    @Override
    public List<BalanceRow> getAllData() {
        boolean isNotRoot;
        LinkedList<BalanceRow> res = new LinkedList<BalanceRow>();
        Map children = this.getChildren();
        Class<? extends AbstractAccBalNode> childType = ((AccSumTreeNodeFactory)this.getNodeFactory()).getNodeType(this.getLevel() + 1);
        StateChart stateChart = this.context.getStateChart();
        boolean bl = isNotRoot = !(this instanceof RootNode);
        if (childType != null && TreeDataCollectService.showMultiLevelNode(childType, stateChart)) {
            LinkedList<BalanceRowList> data = new LinkedList<BalanceRowList>();
            children.forEach((childValue, childNode) -> data.add(new BalanceRowList(childValue, (List)childNode.getAllData())));
            this.mySumRow = null;
            if (isNotRoot) {
                this.context.getRowLimit().increment();
            }
            this.tracer.logBuildingMultiLevelData(this, data);
            List<BalanceRowList> multiLevelData = TreeDataCollectService.buildMultiLevelData(childType, data, this.context);
            multiLevelData.forEach(rowList -> {
                this.enhanceChildData((BalanceRowList)rowList);
                res.addAll(rowList.getAllData());
            });
        } else {
            children.forEach((value, childNode) -> {
                BalanceRowList childRows = new BalanceRowList(value, (List)childNode.getAllData());
                if (CollectionUtils.isNotEmpty(childRows.getAllData())) {
                    this.enhanceChildData(childRows);
                    this.sumChildData(this.mySumRow, childRows);
                }
                res.addAll(childRows.getAllData());
            });
        }
        if (isNotRoot) {
            this.mySumRow = this.enhanceSumData(this.mySumRow, res);
            if (this.mySumRow != null) {
                if (DetailGroupNode.class.equals(childType) && res.size() == 1 && ((BalanceRow)res.get(0)).getBalDetailGroup().equals(BalDetailGroup.EMPTY)) {
                    res.clear();
                    this.mySumRow.setSumRow(false);
                }
                res.add(0, this.mySumRow);
            }
        }
        this.tracer.logReturnData(this, res);
        this.close();
        return res;
    }

    @Override
    public Object getValue() {
        return this.value;
    }
}

