/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.collect.simplenode;

import java.util.List;
import kd.fi.gl.report.accbalance.v2.collect.BalanceRowList;
import kd.fi.gl.report.accbalance.v2.collect.ISumNode;
import kd.fi.gl.report.accbalance.v2.collect.simplenode.AbstractAccBalNode;
import kd.fi.gl.report.accbalance.v2.collect.simplenode.DetailGroupNode;
import kd.fi.gl.report.accbalance.v2.model.BalSumGroup;
import kd.fi.gl.report.accbalance.v2.model.BalanceRow;
import kd.fi.gl.report.accbalance.v2.model.RowType;

public class CurrencyNode
extends AbstractAccBalNode {
    public CurrencyNode(Long value) {
        super(value);
    }

    @Override
    protected void enhanceChildData(BalanceRowList childRows) {
        super.enhanceChildData(childRows);
        for (BalanceRow childRow : childRows.getAllData()) {
            childRow.setBalSumGroup(BalSumGroup.createGrp(this.context, childRow.getOrgId(), childRow.getAccountMid(), (Long)this.getValue()));
        }
    }

    @Override
    protected BalanceRow enhanceSumData(BalanceRow mySumRow, List<BalanceRow> childRows) {
        if ((mySumRow = super.enhanceSumData(mySumRow, childRows)) != null) {
            long pOrg = this.context.getQueryParam().getPorg();
            mySumRow.setBalSumGroup(BalSumGroup.createGrp(this.context, pOrg, 0L, (Long)this.getValue()));
            mySumRow.setRowType(RowType.CURR_SUMMARY);
            Class<ISumNode> childType = this.getChildType();
            mySumRow.setDetailSumRow(childType == null || childType.equals(DetailGroupNode.class));
        }
        return mySumRow;
    }
}

