/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.collect.treenode;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.fi.gl.report.accbalance.v2.AccBalActionTracer;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.collect.AbstractSumTreeNode;
import kd.fi.gl.report.accbalance.v2.collect.BalanceRowList;
import kd.fi.gl.report.accbalance.v2.collect.CollectUtils;
import kd.fi.gl.report.accbalance.v2.collect.TreeNodeUtil;
import kd.fi.gl.report.accbalance.v2.model.BalDetailGroup;
import kd.fi.gl.report.accbalance.v2.model.BalGroup;
import kd.fi.gl.report.accbalance.v2.model.BalanceRow;
import kd.fi.gl.report.accbalance.v2.model.RowType;
import kd.fi.gl.report.accbalance.v2.model.StateChart;
import org.apache.commons.lang3.StringUtils;

public class AccountSumTreeNode
extends AbstractSumTreeNode<String, BalanceRowList, List<BalanceRow>> {
    private final Map<BalGroup, BalanceRow> sumData = new TreeMap<BalGroup, BalanceRow>(BalGroup.COMPARATOR);
    private BalanceRowList leafAcctData;
    private final String acctLongNum;
    private final Long acctMid;
    private final boolean isLeafAcct;
    private final AccBalQueryContext context = AccBalQueryContext.getCurrent();
    private final AccBalActionTracer tracer = AccBalActionTracer.get();
    private final StateChart stateChart = this.context.getStateChart();

    public AccountSumTreeNode(String acctLongNum, Long acctMid, int level, boolean isLeafAcct) {
        this.acctLongNum = acctLongNum;
        this.acctMid = acctMid;
        this.isLeafAcct = isLeafAcct;
        this.tracer.logCreatingNode(this);
        this.setLevel(level);
    }

    @Override
    public String getValue() {
        return this.acctLongNum;
    }

    @Override
    protected void setLeafData(BalanceRowList balanceRowList) {
        if (this.isLeafAcct) {
            this.leafAcctData = balanceRowList;
            this.leafAcctData.getSumData().setRowType(RowType.ACCT_SUMMARY);
        } else {
            balanceRowList.getAllData().forEach(this::addDataRow);
        }
    }

    private void addDataRow(BalanceRow balRow) {
        BalGroup balGroup = new BalGroup(this.context, balRow.getOrgId(), balRow.getOrgLongNum(), this.acctMid, this.acctLongNum, balRow.getCurrencyId(), balRow.getMeasureUnit(), 0L, balRow.getComAssistIds());
        if (balRow.getRowType() == RowType.DETAIL_SUMMARY && balGroup.getBalDetailGroup().equals(BalDetailGroup.EMPTY)) {
            return;
        }
        BalanceRow sumRow = this.sumData.get(balGroup);
        if (sumRow == null) {
            if (!this.context.getRowLimit().tryDecrement()) {
                return;
            }
            sumRow = BalanceRow.create(this.context);
            sumRow.setRowType(balRow.getRowType());
            sumRow.setOrgLevel(balRow.getOrgLevel());
            this.sumData.put(balGroup, sumRow);
        }
        CollectUtils.sumTo(sumRow, balRow, this.stateChart);
    }

    @Override
    public List<BalanceRow> getAllData() {
        LinkedList<BalanceRow> res = new LinkedList<BalanceRow>();
        int curAcctLevel = this.getLevel();
        boolean isRoot = curAcctLevel == 0;
        this.getChildren().forEach((longNum, child) -> {
            if (isRoot) {
                res.addAll((Collection)child.getAllData());
            } else {
                ((List)child.getAllData()).forEach(childRow -> {
                    if (childRow.getAccountLevel() - 1 == curAcctLevel) {
                        this.addDataRow((BalanceRow)childRow);
                    }
                    res.add((BalanceRow)childRow);
                });
            }
        });
        if (this.isLeafAcct && this.leafAcctData != null) {
            this.leafAcctData.getAllData().forEach(row -> {
                row.setAccountLevel(curAcctLevel);
                res.add((BalanceRow)row);
            });
        } else if (!isRoot) {
            HashMap grp2RowId = new HashMap(this.sumData.size());
            LinkedList sumRows = new LinkedList();
            this.sumData.forEach((balGrp, sumRow) -> {
                sumRow.setBalSumGroup(balGrp.getBalSumGroup());
                sumRow.setBalDetailGroup(balGrp.getBalDetailGroup());
                sumRow.setOrgLongNum(balGrp.getOrgLongNum());
                sumRow.setAcctLongNum(this.acctLongNum);
                grp2RowId.put(balGrp, sumRow.getRowId());
                BalGroup parentGrp = null;
                if (sumRow.getRowType() == RowType.DETAIL_SUMMARY) {
                    parentGrp = new BalGroup(this.context, balGrp.getOrgId(), balGrp.getOrgLongNum(), balGrp.getAccountId(), balGrp.getAcctLongNum(), balGrp.getCurrencyId(), 0L, 0L, BalDetailGroup.NO_COM_ASSIST);
                } else {
                    String parentLongNum = TreeNodeUtil.getParentOrgLongNum(balGrp.getOrgLongNum());
                    if (parentLongNum != null) {
                        int parentLevel = StringUtils.countMatches((CharSequence)parentLongNum, (char)'!');
                        Long parentOrgId = this.context.getOrgIdByLongNum(parentLongNum);
                        if (parentLevel >= this.context.getMinParentLevel() && parentOrgId != null) {
                            parentGrp = new BalGroup(this.context, parentOrgId, parentLongNum, balGrp.getAccountId(), balGrp.getAcctLongNum(), balGrp.getCurrencyId(), 0L, 0L, BalDetailGroup.NO_COM_ASSIST);
                        }
                    }
                }
                if (parentGrp != null) {
                    this.sumData.get(parentGrp).setSumRow(true);
                    Integer pid = grp2RowId.getOrDefault(parentGrp, -1);
                    sumRow.setPid(pid);
                }
                sumRow.setAccountLevel(curAcctLevel);
                sumRows.add(sumRow);
            });
            while (!sumRows.isEmpty()) {
                res.addFirst((BalanceRow)sumRows.pollLast());
            }
        }
        this.tracer.logReturnData(this, res);
        return res;
    }

    @Override
    public void close() {
        super.close();
        this.leafAcctData = null;
        this.sumData.clear();
    }

    public Long getAcctMid() {
        return this.acctMid;
    }

    public boolean isLeafAcct() {
        return this.isLeafAcct;
    }
}

