/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.collect.treenode;

import com.google.common.collect.Table;
import java.util.Map;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.collect.BalanceRowList;
import kd.fi.gl.report.accbalance.v2.collect.INodeFactory;
import kd.fi.gl.report.accbalance.v2.collect.ISumNode;
import kd.fi.gl.report.accbalance.v2.collect.treenode.OrgSumTreeNode;
import kd.fi.gl.report.accbalance.v2.model.BalanceRow;

public class OrgTreeFactory
implements INodeFactory<String, BalanceRowList, BalanceRowList> {
    private final Table<String, Integer, String> longNum2Level2num;
    private final Map<Long, String> entityOrgId2LongNum;
    private final Map<String, Long> number2Id;
    private final int minParentLevel;
    private final AccBalQueryContext context;

    public OrgTreeFactory(Map<Long, String> entityOrgId2LongNum, Table<String, Integer, String> longNum2Level2num, Map<String, Long> longNum2Id, AccBalQueryContext context) {
        this.longNum2Level2num = longNum2Level2num;
        this.entityOrgId2LongNum = entityOrgId2LongNum;
        this.number2Id = longNum2Id;
        this.minParentLevel = context.getMinParentLevel();
        this.context = context;
    }

    public OrgSumTreeNode createRoot() {
        OrgSumTreeNode root = new OrgSumTreeNode("", 0L, this.minParentLevel - 1);
        root.setNodeFactory(this);
        return root;
    }

    @Override
    public String extractChildValue(ISumNode<BalanceRowList, BalanceRowList> parentNode, BalanceRowList detailOrgRows) {
        BalanceRow detailOrgSumRow = detailOrgRows.getSumData();
        String longNum = detailOrgSumRow.getOrgLongNum();
        if (longNum.length() == 0) {
            longNum = this.entityOrgId2LongNum.get(detailOrgSumRow.getOrgId());
            detailOrgSumRow.setOrgLongNum(longNum);
        }
        return (String)this.longNum2Level2num.get((Object)longNum, (Object)(parentNode.getLevel() + 1));
    }

    @Override
    public ISumNode<BalanceRowList, BalanceRowList> createChildNode(ISumNode<BalanceRowList, BalanceRowList> parentNode, BalanceRowList detailOrgRows) {
        OrgSumTreeNode parent = (OrgSumTreeNode)parentNode;
        int childLevel = parent.getLevel() + 1;
        BalanceRow detailOrgSumRow = detailOrgRows.getSumData();
        String longNum = detailOrgSumRow.getOrgLongNum();
        String childNum = (String)this.longNum2Level2num.get((Object)longNum, (Object)childLevel);
        if (childNum != null && !longNum.equals(childNum)) {
            if (!this.context.getRowLimit().tryDecrement()) {
                return null;
            }
            OrgSumTreeNode child = new OrgSumTreeNode(childNum, this.number2Id.get(childNum), childLevel);
            child.setNodeFactory(this);
            return child;
        }
        return null;
    }
}

