/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.ds.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.AccBalQueryUtil;
import kd.fi.gl.report.accbalance.v2.ds.IDataSource;
import kd.fi.gl.report.accbalance.v2.model.IBalanceRow;
import kd.fi.gl.report.accbalance.v2.model.StateChart;
import kd.fi.gl.report.accbalance.v2.model.StreamBalLogRow;
import kd.fi.gl.util.MulCurReportUtil;

public class BalanceLogDS
implements IDataSource {
    public static BalanceLogDS getInstance() {
        return new BalanceLogDS();
    }

    @Override
    public Iterator<IBalanceRow> getData() {
        AccBalQueryContext context = AccBalQueryContext.getCurrent();
        return AccBalQueryUtil.createItr(this.getDs(context), row -> new StreamBalLogRow((Row)row, context));
    }

    private DataSet getDs(AccBalQueryContext context) {
        MulOrgQPRpt queryParam = context.getQueryParam();
        List<QFilter> filters = this.getFilters(queryParam, context);
        Tuple<String[], String[]> grpAndAmtFields = BalanceLogDS.getFields(queryParam, context.getStateChart());
        String[] sumFields = (String[])Arrays.stream((Object[])grpAndAmtFields.item2).map(amt -> {
            String aliaName = amt;
            String oriName = amt;
            if (amt.contains(" ")) {
                String[] splits = amt.split(" ");
                oriName = splits[0];
                aliaName = splits[1];
            }
            return String.format("sum(%s) %s", oriName, aliaName);
        }).toArray(String[]::new);
        ORM orm = ORM.create();
        return orm.aggregate("BalanceLogDS", "gl_balance_log", sumFields, filters.toArray(new QFilter[0]), (String[])grpAndAmtFields.item1).limit(0, 1000000);
    }

    private List<QFilter> getFilters(MulOrgQPRpt queryParam, AccBalQueryContext context) {
        List<QFilter> balFilter = AccBalQueryUtil.getBalBaseFilters(queryParam, context);
        balFilter.removeIf(x -> "endperiod".equals(x.getProperty()));
        balFilter.add(new QFilter("calculated", "=", (Object)"0"));
        return balFilter;
    }

    protected static Tuple<String[], String[]> getFields(MulOrgQPRpt queryParam, StateChart stateChart) {
        ArrayList<String> grpFields = new ArrayList<String>();
        ArrayList<String> amtFields = new ArrayList<String>();
        if (stateChart.isShowOrg()) {
            grpFields.add("org");
        }
        grpFields.add("account");
        grpFields.addAll(queryParam.getCommonAssistKeys());
        if (stateChart.isShowAssist()) {
            grpFields.add("assgrp");
        }
        amtFields.add("count");
        MulCurReportUtil.addBalanceLogAmountFields2(amtFields, (String)queryParam.getLocaleCurType());
        if (stateChart.isQueryCurrency()) {
            grpFields.add("currency");
            amtFields.add("debitfor");
            amtFields.add("creditfor");
        }
        if (stateChart.isShowQty()) {
            grpFields.add("measureunit");
            amtFields.add("debitqty");
            amtFields.add("creditqty");
        }
        grpFields.add("period");
        return new Tuple((Object)grpFields.toArray(new String[0]), (Object)amtFields.toArray(new String[0]));
    }
}

