/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.ds.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.AccBalQueryUtil;
import kd.fi.gl.report.accbalance.v2.ds.IDataSource;
import kd.fi.gl.report.accbalance.v2.model.IBalanceRow;
import kd.fi.gl.report.accbalance.v2.model.StateChart;
import kd.fi.gl.report.accbalance.v2.model.StreamPLInitBalRow;
import kd.fi.gl.util.MulCurReportUtil;

public class PLInitBalanceDS
implements IDataSource {
    public static PLInitBalanceDS getInstance() {
        return new PLInitBalanceDS();
    }

    @Override
    public Iterator<IBalanceRow> getData() {
        AccBalQueryContext context = AccBalQueryContext.getCurrent();
        return AccBalQueryUtil.createItr(this.getDs(context), row -> new StreamPLInitBalRow((Row)row, context));
    }

    protected DataSet getDs(AccBalQueryContext context) {
        MulOrgQPRpt queryParam = context.getQueryParam();
        List<Long> orgIds = AccSysUtil.getBookFromAccSys(context.getEntityOrgIdSet(), (long)queryParam.getBookType()).stream().filter(AccountBookInfo::isIsendinit).map(AccountBookInfo::getOrgId).collect(Collectors.toList());
        List<QFilter> filters = this.getFilters(queryParam, orgIds, context.getAcctMids());
        return QueryServiceHelper.queryDataSet((String)"PLInitBalanceDS", (String)"gl_initbalance", (String)String.join((CharSequence)", ", this.getSelectFields(queryParam, context.getStateChart())), (QFilter[])filters.toArray(new QFilter[0]), null);
    }

    protected List<QFilter> getFilters(MulOrgQPRpt qpRpt, List<Long> orgIds, List<Long> acctMids) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "in", orgIds));
        filters.add(new QFilter("booktype", "=", (Object)qpRpt.getBookType()));
        filters.add(new QFilter("accounttable", "=", (Object)qpRpt.getAccountTable()));
        if (!qpRpt.isSynCurrency() && !qpRpt.isAllCurrency()) {
            filters.add(new QFilter("currency", "=", (Object)qpRpt.getCurrency()));
        }
        if (CollectionUtils.isNotEmpty(acctMids)) {
            filters.add(new QFilter("account.masterid", "in", acctMids));
        }
        filters.add(new QFilter("account.pltype", "!=", (Object)"0"));
        filters.addAll(qpRpt.getComAssistFiltersForBill(x -> x));
        return filters;
    }

    protected List<String> getSelectFields(MulOrgQPRpt queryParam, StateChart stateChart) {
        ArrayList<String> fields = new ArrayList<String>();
        if (stateChart.isShowOrg()) {
            fields.add("org");
        }
        fields.add("account.masterid account");
        fields.addAll(queryParam.getCommonAssistKeys());
        if (stateChart.isShowAssist()) {
            fields.add("assgrp");
        }
        fields.addAll(MulCurReportUtil.getInitBalanceLocalAmountFields2((String)queryParam.getLocaleCurType()));
        if (stateChart.isQueryCurrency()) {
            fields.add("currency");
            fields.add("yeardebitfor");
            fields.add("yearcreditfor");
            fields.add("yearprofitdebitfor");
            fields.add("yearprofitcreditfor");
        }
        if (stateChart.isShowQty()) {
            fields.add("measureunit");
            fields.add("yeardebitqty");
            fields.add("yearcreditqty");
            fields.add("yearprofitdebitqty");
            fields.add("yearprofitcreditqty");
        }
        return fields;
    }
}

