/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.model;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Row;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.model.AbstractStreamBalRow;
import kd.fi.gl.report.accbalance.v2.model.BalDetailGroup;
import kd.fi.gl.util.GLUtil;

public class StreamBalRow
extends AbstractStreamBalRow {
    private final Set<PeriodState> periodStates;
    private final boolean queryAssgrp;

    public StreamBalRow(Row streamRow, AccBalQueryContext context, boolean queryAssgrp) {
        super(streamRow, context);
        boolean isInitPeriod;
        Long period = streamRow.getLong("period");
        Long orgId = streamRow.getLong("org");
        long selStartPeriod = context.getQueryParam().getStartPeriod();
        this.periodStates = StreamBalRow.getPeriodState(period, streamRow.getLong("endperiod"), selStartPeriod, context.getQueryParam().getEndPeriod(), context.getQueryYear());
        boolean bl = isInitPeriod = period > selStartPeriod && period.equals(context.getQueryParam().getOrgStartPeriodMap().get(orgId));
        if (isInitPeriod) {
            this.periodStates.add(PeriodState.begin);
        }
        this.queryAssgrp = queryAssgrp;
    }

    @Override
    public long getOrgId() {
        return this.stateChart.isShowOrg() ? this.streamRow.getLong("org") : 0L;
    }

    @Override
    public long getAccountMid() {
        return this.streamRow.getLong("account");
    }

    @Override
    public long getCurrencyId() {
        return this.stateChart.isQueryCurrency() ? this.streamRow.getLong("currency") : 0L;
    }

    @Override
    public long getMeasureUnit() {
        return this.stateChart.isShowQty() ? this.streamRow.getLong("measureunit") : 0L;
    }

    @Override
    public long getAssgrpId() {
        return this.queryAssgrp ? this.streamRow.getLong("assgrp") : 0L;
    }

    @Override
    public long[] getComAssistIds() {
        List<String> commonAssistKeys = this.context.getCommonAssistKeys();
        if (!commonAssistKeys.isEmpty()) {
            return commonAssistKeys.stream().mapToLong(arg_0 -> ((Row)this.streamRow).getLong(arg_0)).toArray();
        }
        return BalDetailGroup.NO_COM_ASSIST;
    }

    @Override
    public BigDecimal getBeginQty() {
        if (this.periodStates.contains((Object)PeriodState.veryBegin)) {
            return this.streamRow.getBigDecimal("endqty");
        }
        if (this.periodStates.contains((Object)PeriodState.begin)) {
            return this.streamRow.getBigDecimal("beginqty");
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getBeginFor() {
        if (this.periodStates.contains((Object)PeriodState.veryBegin)) {
            return this.streamRow.getBigDecimal("endfor");
        }
        if (this.periodStates.contains((Object)PeriodState.begin)) {
            return this.streamRow.getBigDecimal("beginfor");
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getBeginLocal() {
        if (this.periodStates.contains((Object)PeriodState.veryBegin)) {
            return this.streamRow.getBigDecimal("endlocal");
        }
        if (this.periodStates.contains((Object)PeriodState.begin)) {
            return this.streamRow.getBigDecimal("beginlocal");
        }
        return BigDecimal.ZERO;
    }

    @Override
    public int getCount() {
        if (this.periodStates.contains((Object)PeriodState.period)) {
            return this.streamRow.getInteger("count");
        }
        return 0;
    }

    @Override
    public BigDecimal getDebitQty() {
        if (this.periodStates.contains((Object)PeriodState.period)) {
            return this.streamRow.getBigDecimal("debitqty");
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getDebitFor() {
        if (this.periodStates.contains((Object)PeriodState.period)) {
            return this.streamRow.getBigDecimal("debitfor");
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getDebitLocal() {
        if (this.periodStates.contains((Object)PeriodState.period)) {
            return this.streamRow.getBigDecimal("debitlocal");
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getCreditQty() {
        if (this.periodStates.contains((Object)PeriodState.period)) {
            return this.streamRow.getBigDecimal("creditqty");
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getCreditFor() {
        if (this.periodStates.contains((Object)PeriodState.period)) {
            return this.streamRow.getBigDecimal("creditfor");
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getCreditLocal() {
        if (this.periodStates.contains((Object)PeriodState.period)) {
            return this.streamRow.getBigDecimal("creditlocal");
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getYearDebitQty() {
        if (this.periodStates.contains((Object)PeriodState.year)) {
            return this.streamRow.getBigDecimal("yeardebitqty");
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getYearDebitFor() {
        if (this.periodStates.contains((Object)PeriodState.year)) {
            return this.streamRow.getBigDecimal("yeardebitfor");
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getYearDebitLocal() {
        if (this.periodStates.contains((Object)PeriodState.year)) {
            return this.streamRow.getBigDecimal("yeardebitlocal");
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getYearCreditQty() {
        if (this.periodStates.contains((Object)PeriodState.year)) {
            return this.streamRow.getBigDecimal("yearcreditqty");
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getYearCreditFor() {
        if (this.periodStates.contains((Object)PeriodState.year)) {
            return this.streamRow.getBigDecimal("yearcreditfor");
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getYearCreditLocal() {
        if (this.periodStates.contains((Object)PeriodState.year)) {
            return this.streamRow.getBigDecimal("yearcreditlocal");
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getEndQty() {
        if (this.periodStates.contains((Object)PeriodState.end)) {
            return this.streamRow.getBigDecimal("endqty");
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getEndFor() {
        if (this.periodStates.contains((Object)PeriodState.end)) {
            return this.streamRow.getBigDecimal("endfor");
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getEndLocal() {
        if (this.periodStates.contains((Object)PeriodState.end)) {
            return this.streamRow.getBigDecimal("endlocal");
        }
        return BigDecimal.ZERO;
    }

    static Set<PeriodState> getPeriodState(long period, long endPeriod, long selStartPeriod, long selEndPeriod, long queryYear) {
        HashSet<PeriodState> periodStates = new HashSet<PeriodState>(4);
        if (period < selStartPeriod) {
            periodStates.add(PeriodState.veryBegin);
        } else if (period == selStartPeriod) {
            periodStates.add(PeriodState.begin);
        }
        if (period >= selStartPeriod) {
            periodStates.add(PeriodState.period);
        }
        if (endPeriod > selEndPeriod) {
            periodStates.add(PeriodState.end);
            if (queryYear == GLUtil.getYear((long)period)) {
                periodStates.add(PeriodState.year);
            }
        }
        return periodStates;
    }

    static enum PeriodState {
        veryBegin,
        begin,
        period,
        end,
        year;

    }
}

