/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2.model;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.Row;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.model.AbstractStreamBalRow;
import kd.fi.gl.util.GLUtil;

public class StreamPLVchRow
extends AbstractStreamBalRow {
    private final Set<PeriodState> periodState;

    public StreamPLVchRow(Row streamRow, AccBalQueryContext context) {
        super(streamRow, context);
        this.periodState = StreamPLVchRow.getPeriodState(streamRow.getLong("period"), context.getQueryParam().getStartPeriod(), context.getQueryYear());
    }

    @Override
    public int getCount() {
        return -1;
    }

    @Override
    public BigDecimal getBeginQty() {
        return !this.periodState.contains((Object)PeriodState.begin) ? BigDecimal.ZERO : this.getEndQty();
    }

    @Override
    public BigDecimal getBeginFor() {
        return !this.periodState.contains((Object)PeriodState.begin) ? BigDecimal.ZERO : this.getEndFor();
    }

    @Override
    public BigDecimal getBeginLocal() {
        return !this.periodState.contains((Object)PeriodState.begin) ? BigDecimal.ZERO : this.getEndLocal();
    }

    @Override
    public BigDecimal getDebitQty() {
        return !this.periodState.contains((Object)PeriodState.period) ? BigDecimal.ZERO : this.streamRow.getBigDecimal("debitqty").negate();
    }

    @Override
    public BigDecimal getDebitFor() {
        return !this.periodState.contains((Object)PeriodState.period) ? BigDecimal.ZERO : this.streamRow.getBigDecimal("debitfor").negate();
    }

    @Override
    public BigDecimal getDebitLocal() {
        return !this.periodState.contains((Object)PeriodState.period) ? BigDecimal.ZERO : this.streamRow.getBigDecimal("debitlocal").negate();
    }

    @Override
    public BigDecimal getCreditQty() {
        return !this.periodState.contains((Object)PeriodState.period) ? BigDecimal.ZERO : this.streamRow.getBigDecimal("creditqty").negate();
    }

    @Override
    public BigDecimal getCreditFor() {
        return !this.periodState.contains((Object)PeriodState.period) ? BigDecimal.ZERO : this.streamRow.getBigDecimal("creditfor").negate();
    }

    @Override
    public BigDecimal getCreditLocal() {
        return !this.periodState.contains((Object)PeriodState.period) ? BigDecimal.ZERO : this.streamRow.getBigDecimal("creditlocal").negate();
    }

    @Override
    public BigDecimal getYearDebitQty() {
        return !this.periodState.contains((Object)PeriodState.year) ? BigDecimal.ZERO : this.streamRow.getBigDecimal("debitqty").negate();
    }

    @Override
    public BigDecimal getYearDebitFor() {
        return !this.periodState.contains((Object)PeriodState.year) ? BigDecimal.ZERO : this.streamRow.getBigDecimal("debitfor").negate();
    }

    @Override
    public BigDecimal getYearDebitLocal() {
        return !this.periodState.contains((Object)PeriodState.year) ? BigDecimal.ZERO : this.streamRow.getBigDecimal("debitlocal").negate();
    }

    @Override
    public BigDecimal getYearCreditQty() {
        return !this.periodState.contains((Object)PeriodState.year) ? BigDecimal.ZERO : this.streamRow.getBigDecimal("creditqty").negate();
    }

    @Override
    public BigDecimal getYearCreditFor() {
        return !this.periodState.contains((Object)PeriodState.year) ? BigDecimal.ZERO : this.streamRow.getBigDecimal("creditfor").negate();
    }

    @Override
    public BigDecimal getYearCreditLocal() {
        return !this.periodState.contains((Object)PeriodState.year) ? BigDecimal.ZERO : this.streamRow.getBigDecimal("creditlocal").negate();
    }

    @Override
    public BigDecimal getEndQty() {
        return this.streamRow.getBigDecimal("debitqty").subtract(this.streamRow.getBigDecimal("creditqty")).negate();
    }

    @Override
    public BigDecimal getEndFor() {
        return this.streamRow.getBigDecimal("debitfor").subtract(this.streamRow.getBigDecimal("creditfor")).negate();
    }

    @Override
    public BigDecimal getEndLocal() {
        return this.streamRow.getBigDecimal("debitlocal").subtract(this.streamRow.getBigDecimal("creditlocal")).negate();
    }

    static Set<PeriodState> getPeriodState(long period, long selStartPeriod, long endPeriodYear) {
        long periodYear = GLUtil.getYear((long)period);
        HashSet<PeriodState> periodStates = new HashSet<PeriodState>(4);
        if (period < selStartPeriod) {
            periodStates.add(PeriodState.begin);
        } else {
            periodStates.add(PeriodState.period);
        }
        if (periodYear == endPeriodYear) {
            periodStates.add(PeriodState.year);
        }
        return periodStates;
    }

    static enum PeriodState {
        begin,
        year,
        period;

    }
}

