/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.assistbalance;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.report.assistbalance.PlaceHolder;
import kd.fi.gl.report.assistbalance.model.AccTreeData;
import kd.fi.gl.report.assistbalance.model.AssistBalanceAmountRow;
import kd.fi.gl.report.assistbalance.model.AssistBalanceKey;
import kd.fi.gl.report.assistbalance.model.BalanceRow;
import kd.fi.gl.report.assistbalance.model.TreeGroupKey;

public class AccIDSumUpTree {
    public static int INIT_COUNT = 0;
    private static final Log LOG = LogFactory.getLog(AccIDSumUpTree.class);
    private final BiTreeNode<Long, PlaceHolder> _rootNode;
    private final Map<Long, BiTreeNode<Long, PlaceHolder>> _nodeIndex;
    private final Map<Long, Integer> _nodeLevelIndex;
    private final AccTreeData accTreeData;

    public AccIDSumUpTree(List<BiTreeNode.TreeNodeRelation<Long>> nodeRelations) {
        ++INIT_COUNT;
        this._rootNode = BiTreeNode.quickBuildTree(nodeRelations, PlaceHolder.class);
        this._nodeIndex = new HashMap<Long, BiTreeNode<Long, PlaceHolder>>(8);
        this._nodeLevelIndex = new HashMap<Long, Integer>(8);
        this._nodeLevelIndex.put((Long)this._rootNode.getId(), 0);
        this._rootNode.preTravel(x -> {
            this._nodeIndex.put((Long)x.getId(), (BiTreeNode<Long, PlaceHolder>)x);
            if (x != this._rootNode) {
                long parentId = (Long)x.getParentId();
                this._nodeLevelIndex.put((Long)x.getId(), this._nodeLevelIndex.get(parentId) + 1);
            }
        });
        if (DebugTrace.enable()) {
            LOG.info("org account number tree:  {}", (Object)this._rootNode.showFormatTree("\n"));
        }
        this.accTreeData = new AccTreeData();
    }

    public void accept(TreeGroupKey groupKey, BalanceRow balanceRow) {
        long accId = balanceRow.getBalanceKey().getAccountId();
        if (null == this._nodeIndex.get(accId)) {
            throw new KDBizException("failed to find accid ");
        }
        BiTreeNode<Long, PlaceHolder> targetNode = this._nodeIndex.get(accId);
        this.accTreeData.feed(groupKey, (Long)targetNode.getId(), balanceRow);
    }

    public long getTopAccountId(long accountId) {
        BiTreeNode curAccNode = this._nodeIndex.get(accountId);
        while (-999L != (Long)curAccNode.getParent().getId()) {
            curAccNode = curAccNode.getParent();
        }
        return (Long)curAccNode.getId();
    }

    public void sumUpEnhance(TreeGroupKey groupKey) {
        if (DebugTrace.enable()) {
            LOG.info("sumUp groupKey: " + groupKey.toString());
        }
        Map<Long, BalanceRow> nodeDataMap = this.accTreeData.listAvailableNodes(groupKey);
        if (DebugTrace.enable()) {
            LOG.info("sumUp groupKey: {} with balance data: {}, json: {}", new Object[]{groupKey.toString(), nodeDataMap, SerializationUtils.toJsonString(nodeDataMap)});
        }
        if (!nodeDataMap.isEmpty()) {
            for (Map.Entry<Long, BalanceRow> entry : nodeDataMap.entrySet()) {
                long nodeId = entry.getKey();
                BalanceRow curBalance = entry.getValue();
                if (DebugTrace.enable()) {
                    LOG.info("sumUp groupKey: {} node Id: {}, cur Balance: {}, json: {}", new Object[]{groupKey.toString(), nodeId, curBalance, SerializationUtils.toJsonString((Object)curBalance)});
                }
                BiTreeNode curNode = this._nodeIndex.get(nodeId);
                while (curNode.getParent() != this._rootNode) {
                    BalanceRow parentData = this.accTreeData.get(groupKey, (Long)curNode.getParentId());
                    if (DebugTrace.enable()) {
                        LOG.info("sumUp groupKey: {} parentData: {}, json:{}", new Object[]{groupKey.toString(), parentData, SerializationUtils.toJsonString((Object)parentData)});
                    }
                    if (null == parentData) {
                        AssistBalanceKey sampleBalanceKey = curBalance.getBalanceKey();
                        long parentAccId = (Long)curNode.getParentId();
                        ArrayList<Long> comAssistList = new ArrayList<Long>(8);
                        sampleBalanceKey.getComAssistVals().forEach(x -> comAssistList.add(0L));
                        AssistBalanceKey newBalanceKey = AssistBalanceKey.retrievalFromCacheOrBuild(sampleBalanceKey.getOrgId(), parentAccId, sampleBalanceKey.getMeasureUnitId(), sampleBalanceKey.getCurrencyId(), comAssistList, sampleBalanceKey.getAssistValues());
                        AssistBalanceAmountRow newAmountRow = null;
                        try {
                            newAmountRow = curBalance.getAmount().clone();
                        }
                        catch (CloneNotSupportedException e) {
                            throw new KDBizException("not support clone");
                        }
                        if (DebugTrace.enable()) {
                            LOG.info("sumUp groupKey: {} newAmountRow == curBalance.getAmount: {}", (Object)groupKey.toString(), (Object)(newAmountRow == curBalance.getAmount() ? 1 : 0));
                        }
                        parentData = new BalanceRow(newBalanceKey, newAmountRow);
                        if (DebugTrace.enable()) {
                            LOG.info("sumUp groupKey: {} parentAccId: {}, parentData {}, json: {}", new Object[]{groupKey.toString(), parentAccId, parentData, SerializationUtils.toJsonString((Object)parentData)});
                        }
                        this.accTreeData.feed(groupKey, (Long)curNode.getParentId(), parentData);
                        if (DebugTrace.enable()) {
                            LOG.info("sumUp groupKey: {} actual parent data: {},", (Object)groupKey.toString(), (Object)this.accTreeData.get(groupKey, (Long)curNode.getParentId()));
                        }
                    } else {
                        parentData.merge(curBalance, false);
                        if (DebugTrace.enable()) {
                            LOG.info("sumUp groupKey: {} after merge, parent data: {}, json: {}", new Object[]{groupKey.toString(), this.accTreeData.get(groupKey, (Long)curNode.getParentId()), SerializationUtils.toJsonString((Object)this.accTreeData.get(groupKey, (Long)curNode.getParentId()))});
                        }
                    }
                    curNode = curNode.getParent();
                }
            }
        }
    }

    public void sumUpAll() {
        for (TreeGroupKey groupKey : this.accTreeData.listKeys()) {
            if (DebugTrace.enable()) {
                LOG.info("listKeys: groupKey: {} - {}", (Object)groupKey, (Object)groupKey.toString());
            }
            this.sumUpEnhance(groupKey);
        }
    }

    public List<BalanceRow> collectAll() {
        return this.accTreeData.listKeys().stream().flatMap(k -> this.accTreeData.collect((TreeGroupKey)k).stream()).collect(Collectors.toList());
    }

    public List<BalanceRow> collect(TreeGroupKey groupKey) {
        return new ArrayList<BalanceRow>(this.accTreeData.collect(groupKey));
    }

    public void clearAllKeyData() {
        this.accTreeData.clearAllKeyData();
    }

    public void clearKeyData(TreeGroupKey key) {
        this.accTreeData.clearKeyData(key);
    }

    public int getTreeDeepth() {
        return Collections.max(this._nodeLevelIndex.values());
    }
}

