/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.assistbalance;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.OrgType;
import kd.fi.gl.report.ReportHelper;
import org.apache.commons.lang3.StringUtils;

class AssistBalHelper
extends ReportHelper {
    private static final Log LOG = LogFactory.getLog(AssistBalHelper.class);
    private static final String MEASUREUNITNAME = "measureunitname";
    private static final String CURRENCYID = "currencyid";
    private static final String ACCOUNTNUMBER = "number";
    private static final String ACCOUNTNAME = "name";
    private static final String ORGID = "orgid";
    private static final String BEGIN = "begin";
    private static final String NOW = "";
    private static final String YEAR = "year";
    private static final String END = "end";
    private static final String YEARBEGIN = "yearbegin";
    private static final String ASSIST_FIELD_PREFIX = "assval";

    private static LocaleString getASS_NUMBER() {
        return new LocaleString(ResManager.loadKDString((String)"\u9879\u76ee\u7f16\u7801", (String)"AssistBalHelper_0", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getACC_NUMBER() {
        return new LocaleString(ResManager.loadKDString((String)"\u79d1\u76ee\u7f16\u7801", (String)"AssistBalHelper_1", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getACC_NAME() {
        return new LocaleString(ResManager.loadKDString((String)"\u79d1\u76ee\u540d\u79f0", (String)"AssistBalHelper_2", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getCURRENCY() {
        return new LocaleString(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"AssistBalHelper_3", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getORG() {
        return new LocaleString(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"AssistBalHelper_4", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getBALANCE_BEGIN() {
        return new LocaleString(ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"AssistBalHelper_5", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getAMOUNT_NOW() {
        return new LocaleString(ResManager.loadKDString((String)"\u672c\u671f\u53d1\u751f\u989d", (String)"AssistBalHelper_6", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getAMOUNT_YEAR() {
        return new LocaleString(ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1", (String)"AssistBalHelper_7", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getBALANCE_END() {
        return new LocaleString(ResManager.loadKDString((String)"\u671f\u672b\u4f59\u989d", (String)"AssistBalHelper_8", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getUNIT() {
        return new LocaleString(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"AssistBalHelper_9", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getYearBalanceBegin() {
        return new LocaleString(ResManager.loadKDString((String)"\u5e74\u521d\u4f59\u989d", (String)"AssistBalHelper_10", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    public AssistBalHelper(MulOrgQPRpt param) {
        super(param);
    }

    public List<AbstractReportColumn> getReportColumn(List<AbstractReportColumn> columns, List<Tuple<String, String>> asstypeNames, String treeAlias) {
        String comAssistValsListStr;
        ReportColumn column;
        int i;
        ArrayList<Object> list = new ArrayList<Object>(16);
        for (i = 0; i < columns.size(); ++i) {
            ReportColumn col = (ReportColumn)columns.get(i);
            if (!ORGID.equals(col.getFieldKey())) continue;
            columns.remove(i);
        }
        if (treeAlias != null) {
            for (i = 0; i < asstypeNames.size(); ++i) {
                String assVal;
                String string = assVal = i == 0 ? ASSIST_FIELD_PREFIX : ASSIST_FIELD_PREFIX + i;
                if (!assVal.equals(treeAlias)) continue;
                LocaleString captionNumber = new LocaleString(String.format(ResManager.loadKDString((String)"%s\u7f16\u7801", (String)"AssistBalHelper_11", (String)"fi-gl-report", (Object[])new Object[0]), asstypeNames.get((int)i).item1));
                column = AssistBalHelper.createColumn(captionNumber, "treenumber", "text");
                column.setFreeze(true);
                list.add(column);
                LocaleString caption = new LocaleString((String)asstypeNames.get((int)i).item1);
                column = AssistBalHelper.createColumn(caption, "treename", "text");
                column.setFreeze(true);
                list.add(column);
            }
            column = AssistBalHelper.createColumn(AssistBalHelper.getASS_NUMBER(), "treeleaf", "integer");
            column.setHide(true);
            list.add(column);
            column = AssistBalHelper.createColumn(AssistBalHelper.getASS_NUMBER(), "treelevel", "integer");
            column.setHide(true);
            list.add(column);
        }
        list.addAll(ReportHelper.buildAssColumn(asstypeNames, treeAlias));
        column = AssistBalHelper.createColumn(AssistBalHelper.getACC_NUMBER(), ACCOUNTNUMBER, "text");
        column.setFreeze(true);
        column.setHyperlink(true);
        list.add(column);
        column = AssistBalHelper.createColumn(AssistBalHelper.getACC_NAME(), ACCOUNTNAME, "text");
        column.setFreeze(true);
        list.add(column);
        if (!this.qParam.getComAssistValsList().isEmpty() && !StringUtils.isBlank((CharSequence)(comAssistValsListStr = (String)this.qParam.getCustomParam("ComAssistEntityListStr")))) {
            List comAssistList = (List)SerializationUtils.fromJsonString((String)comAssistValsListStr, List.class);
            for (List fieldList : comAssistList) {
                String comFieldKey = (String)fieldList.get(0);
                String entityId = (String)fieldList.get(1);
                LocaleString nameLocal = new LocaleString();
                LinkedHashMap nameMap = (LinkedHashMap)fieldList.get(2);
                for (Map.Entry map : nameMap.entrySet()) {
                    String key = (String)map.getKey();
                    String val = (String)map.getValue();
                    nameLocal.setItem(key, (Object)val);
                }
                columns.add((AbstractReportColumn)this.createComAssist(comFieldKey, entityId, nameLocal));
            }
        }
        column = AssistBalHelper.createColumn(AssistBalHelper.getCURRENCY(), CURRENCYID, "basedata");
        column.setEntityId("bd_currency");
        column.setHide(true);
        column.setFreeze(true);
        if (this.qParam.isAllCurrency()) {
            column.setHide(false);
            if (this.qParam.getOrgType() == OrgType.ENTITY) {
                column.setHyperlink(true);
            }
        }
        list.add(column);
        if (this.qParam.getOrgType() != OrgType.ENTITY && this.qParam.isShowOrg()) {
            column = AssistBalHelper.createColumn(AssistBalHelper.getORG(), ORGID, "basedata");
            column.setEntityId("t_org_org");
            column.setDisplayProp(ACCOUNTNAME);
            if (this.qParam.getOrgType() != OrgType.ENTITY) {
                column.setHyperlink(true);
            }
            column.setFreeze(true);
            list.add(column);
        }
        if (this.qParam.isShowQty()) {
            ReportColumn unitColumn = AssistBalHelper.createColumn(AssistBalHelper.getUNIT(), MEASUREUNITNAME, "text");
            unitColumn.setFreeze(true);
            list.add(unitColumn);
        }
        list.add(this.columnCreateHelper(YEARBEGIN));
        list.add(this.columnCreateHelper(BEGIN));
        list.add(this.columnCreateHelper(NOW));
        list.add(this.columnCreateHelper(YEAR));
        list.add(this.columnCreateHelper(END));
        columns.addAll(list);
        if (DebugTrace.enable()) {
            LOG.info("assist_balance report_columns_info as:" + StringUtils.join((Object[])new List[]{columns}));
        }
        return columns;
    }

    private ReportColumn createComAssist(String fieldKey, String entityId, LocaleString nameLocal) {
        ReportColumn reportColumn = AssistBalHelper.createColumn(nameLocal, fieldKey, "basedata");
        reportColumn.setEntityId(entityId);
        return reportColumn;
    }

    private AbstractReportColumn columnCreateHelper(String prefix) {
        ReportColumnGroup group = new ReportColumnGroup();
        group.setCaption((LocaleString)(prefix.equals(YEARBEGIN) ? AssistBalHelper.getYearBalanceBegin() : (prefix.equals(BEGIN) ? AssistBalHelper.getBALANCE_BEGIN() : (prefix.equals(NOW) ? AssistBalHelper.getAMOUNT_NOW() : (prefix.equals(YEAR) ? AssistBalHelper.getAMOUNT_YEAR() : (prefix.startsWith(END) ? AssistBalHelper.getBALANCE_END() : null))))));
        group.setFieldKey(prefix.equals(YEARBEGIN) ? "yearBeginGroup" : (prefix.equals(BEGIN) ? "beginGroup" : (prefix.equals(NOW) ? "amountGroup" : (prefix.equals(YEAR) ? "yearGroup" : (prefix.startsWith(END) ? "endGroup" : null)))));
        return this.getColumnGroup(group, prefix);
    }
}

