/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.assistbalance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.algo.DataType;
import kd.bos.cache.ThreadCache;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.ReportMulLang;
import kd.fi.gl.report.assistbalance.AccountIndex;
import kd.fi.gl.report.assistbalance.AssistBalanceContext;
import kd.fi.gl.report.assistbalance.model.AssistBalanceSubtotal;
import kd.fi.gl.report.assistbalance.model.BalanceUnitVO;
import kd.fi.gl.report.assistbalance.model.SubtotalType;
import kd.fi.gl.util.ColumnMeta;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.IDataSetMeta;

public class AssistBalanceDSMeta
implements IDataSetMeta<AssistBalanceSubtotal> {
    private static final String ASSIST_FIELD_PREFIX = "assval";
    private List<ColumnMeta<AssistBalanceSubtotal>> rowConverter = new ArrayList<ColumnMeta<AssistBalanceSubtotal>>(8);

    public AssistBalanceDSMeta(List<FlexUtils.AssistFilterEntry> assistFilterEntries, MulOrgQPRpt qParam, int comassistLength) {
        int index;
        Optional<Object> rptCurrency = Optional.ofNullable(qParam.isShowRpt() ? Long.valueOf(qParam.getCurRpt()) : null);
        long localCurrency = qParam.getCurLocal();
        boolean isShowCurrencyColumn = qParam.isAllCurrency();
        AccountIndex accountIndex = AssistBalanceContext.get().getAccountIndex();
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("_rowtype", (DataType)DataType.StringType, subtotal -> subtotal.getType().toString()));
        String treeAssistAlias = (String)ThreadCache.get((Object)"_tree_assist_field");
        for (int i = 0; i < assistFilterEntries.size(); ++i) {
            FlexUtils.AssistFilterEntry assistFilterEntry = assistFilterEntries.get(i);
            index = i;
            String fieldKey = String.format("assval%s", i == 0 ? "" : Integer.valueOf(i));
            if (Objects.equals(treeAssistAlias, fieldKey)) {
                this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta(fieldKey, (DataType)DataType.StringType, subtotal -> subtotal.getType() == SubtotalType.Total ? "" : (null == subtotal.getAssistTreeCategoryVO() ? subtotal.getSampleBalanceKey().getAssistValues().get(index) : subtotal.getAssistTreeCategoryVO().getId())));
                continue;
            }
            if (assistFilterEntry.isManualAssist()) {
                this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta(fieldKey, (DataType)DataType.StringType, subtotal -> subtotal.getType() == SubtotalType.Total ? "" : subtotal.getSampleBalanceKey().getAssistValues().get(index)));
                continue;
            }
            this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta(fieldKey, (DataType)DataType.LongType, subtotal -> subtotal.getType() == SubtotalType.Total ? Long.valueOf(0L) : subtotal.getSampleBalanceKey().getAssistValues().get(index)));
        }
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("number", (DataType)DataType.StringType, subtotal -> subtotal.getType() == SubtotalType.Total ? "" : accountIndex.getAccountVO(subtotal.getSampleBalanceKey().getAccountId()).getNumber()));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("account", (DataType)DataType.LongType, subtotal -> subtotal.getType() == SubtotalType.Total ? 0L : subtotal.getSampleBalanceKey().getAccountId()));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("currencyid", (DataType)DataType.LongType, subtotal -> {
            boolean isSetOriginCurrency;
            boolean bl = isSetOriginCurrency = isShowCurrencyColumn && (SubtotalType.Currency == subtotal.getType() || SubtotalType.Org == subtotal.getType() || SubtotalType.MeasureUnit == subtotal.getType() || SubtotalType.ComAssist == subtotal.getType()) || !isShowCurrencyColumn;
            if (isSetOriginCurrency) {
                return subtotal.getSampleBalanceKey().getCurrencyId();
            }
            return 0L;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("orgid", (DataType)DataType.LongType, subtotal -> subtotal.getType() != SubtotalType.Org ? Long.valueOf(0L) : subtotal.getSampleBalanceKey().getOrgId()));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("measureunit", (DataType)DataType.LongType, subtotal -> subtotal.getType() != SubtotalType.MeasureUnit ? Long.valueOf(0L) : subtotal.getSampleBalanceKey().getMeasureUnitId()));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("measureunitname", (DataType)DataType.StringType, subtotal -> subtotal.getType() != SubtotalType.MeasureUnit ? "" : subtotal.getSampleBalanceKey().getMeasureUnitName()));
        boolean isHideLocalAmount = localCurrency == 0L;
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("currencylocalid", (DataType)DataType.LongType, subtotal -> {
            if (qParam.isShowOrg() && subtotal.getType() == SubtotalType.Org || !isHideLocalAmount) {
                return qParam.getOrgCurMap().get(subtotal.getSampleBalanceKey().getOrgId());
            }
            return localCurrency;
        }));
        for (int i = 0; i < comassistLength; ++i) {
            index = i;
            this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta(String.format("comassist%sid", i + 1), (DataType)DataType.LongType, subtotal -> {
                if (subtotal.getType() != SubtotalType.Total && subtotal.getNestSubtotals().isEmpty()) {
                    return subtotal.getSampleBalanceKey().getComAssistVals().get(index);
                }
                return 0L;
            }));
        }
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("name", (DataType)DataType.StringType, subtotal -> subtotal.getType() == SubtotalType.Total ? ReportMulLang.getHeJi() : AssistBalanceContext.getAccountVOById(subtotal.getSampleBalanceKey().getAccountId()).getName()));
        if (rptCurrency.isPresent()) {
            this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("currencyrptid", (DataType)DataType.LongType, x -> (Long)rptCurrency.get()));
        }
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("treeid", (DataType)DataType.LongType, subtotal -> null == subtotal.getAssistTreeCategoryVO() ? null : subtotal.getAssistTreeCategoryVO().getId()));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("treeparent", (DataType)DataType.LongType, subtotal -> {
            if (null != subtotal.getParentPoint()) {
                return subtotal.getParentPoint().getAssistTreeCategoryVO().getId();
            }
            return null;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("treename", (DataType)DataType.StringType, subtotal -> null == subtotal.getAssistTreeCategoryVO() ? null : subtotal.getAssistTreeCategoryVO().getName()));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("treenumber", (DataType)DataType.StringType, subtotal -> null == subtotal.getAssistTreeCategoryVO() ? null : subtotal.getAssistTreeCategoryVO().getNumber()));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("longnumber", (DataType)DataType.StringType, subtotal -> null == subtotal.getAssistTreeCategoryVO() ? null : subtotal.getAssistTreeCategoryVO().getLongNumber()));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("treelevel", (DataType)DataType.IntegerType, subtotal -> null == subtotal.getAssistTreeCategoryVO() ? null : subtotal.getAssistTreeCategoryVO().getLevel()));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("treeleaf", (DataType)DataType.IntegerType, subtotal -> null == subtotal.getAssistTreeCategoryVO() ? null : Integer.valueOf(subtotal.getAssistTreeCategoryVO().getIsLeaf() ? 1 : 0)));
        this.buildYearBegin(isHideLocalAmount, qParam.isShowOrg());
        this.buildPeriodBegin(isHideLocalAmount, qParam.isShowOrg());
        this.buildPeriod(isHideLocalAmount, qParam.isShowOrg());
        this.buildYearAccumulated(isHideLocalAmount, qParam.isShowOrg());
        this.buildPeriodEnd(isHideLocalAmount, qParam.isShowOrg());
    }

    private void buildYearBegin(boolean isHideLocalAmount, boolean isShowOrg) {
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("yearbegindebitfor", (DataType)DataType.BigDecimalType, subtotal -> {
            Optional<BalanceUnitVO> origin = subtotal.getAmount().getOrigin();
            return origin.isPresent() ? origin.get().getYearBeginDebit() : BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("yearbegincreditfor", (DataType)DataType.BigDecimalType, subtotal -> {
            Optional<BalanceUnitVO> origin = subtotal.getAmount().getOrigin();
            return origin.isPresent() ? origin.get().getYearBeginCredit() : BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("yearbegindebitlocal", (DataType)DataType.BigDecimalType, subtotal -> {
            if (isShowOrg && subtotal.getType() == SubtotalType.Org || !isHideLocalAmount) {
                BalanceUnitVO local = subtotal.getAmount().getLocal();
                return local.getYearBeginDebit();
            }
            return BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("yearbegincreditlocal", (DataType)DataType.BigDecimalType, subtotal -> {
            if (isShowOrg && subtotal.getType() == SubtotalType.Org || !isHideLocalAmount) {
                BalanceUnitVO local = subtotal.getAmount().getLocal();
                return local.getYearBeginCredit();
            }
            return BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("yearbegindebitqty", (DataType)DataType.BigDecimalType, subtotal -> {
            if (subtotal.getType() == SubtotalType.MeasureUnit) {
                Optional<BalanceUnitVO> qty = subtotal.getAmount().getQty();
                return qty.isPresent() ? qty.get().getYearBeginDebit() : BigDecimal.ZERO;
            }
            return BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("yearbegincreditqty", (DataType)DataType.BigDecimalType, subtotal -> {
            if (subtotal.getType() == SubtotalType.MeasureUnit) {
                Optional<BalanceUnitVO> qty = subtotal.getAmount().getQty();
                return qty.isPresent() ? qty.get().getYearBeginCredit() : BigDecimal.ZERO;
            }
            return BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("yearbegindebitrpt", (DataType)DataType.BigDecimalType, subtotal -> {
            Optional<BalanceUnitVO> rpt = subtotal.getAmount().getRpt();
            return rpt.isPresent() ? rpt.get().getYearBeginDebit() : BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("yearbegincreditrpt", (DataType)DataType.BigDecimalType, subtotal -> {
            Optional<BalanceUnitVO> rpt = subtotal.getAmount().getRpt();
            return rpt.isPresent() ? rpt.get().getYearBeginCredit() : BigDecimal.ZERO;
        }));
    }

    private void buildPeriodBegin(boolean isHideLocalAmount, boolean isShowOrg) {
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("begindebitfor", (DataType)DataType.BigDecimalType, subtotal -> {
            Optional<BalanceUnitVO> origin = subtotal.getAmount().getOrigin();
            return origin.isPresent() ? origin.get().getBeginDebit() : BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("begincreditfor", (DataType)DataType.BigDecimalType, subtotal -> {
            Optional<BalanceUnitVO> origin = subtotal.getAmount().getOrigin();
            return origin.isPresent() ? origin.get().getBeginCredit() : BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("begindebitlocal", (DataType)DataType.BigDecimalType, subtotal -> {
            if (isShowOrg && subtotal.getType() == SubtotalType.Org || !isHideLocalAmount) {
                BalanceUnitVO local = subtotal.getAmount().getLocal();
                return local.getBeginDebit();
            }
            return BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("begincreditlocal", (DataType)DataType.BigDecimalType, subtotal -> {
            if (isShowOrg && subtotal.getType() == SubtotalType.Org || !isHideLocalAmount) {
                BalanceUnitVO local = subtotal.getAmount().getLocal();
                return local.getBeginCredit();
            }
            return BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("begindebitqty", (DataType)DataType.BigDecimalType, subtotal -> {
            if (subtotal.getType() == SubtotalType.MeasureUnit) {
                Optional<BalanceUnitVO> qty = subtotal.getAmount().getQty();
                return qty.isPresent() ? qty.get().getBeginDebit() : BigDecimal.ZERO;
            }
            return BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("begincreditqty", (DataType)DataType.BigDecimalType, subtotal -> {
            if (subtotal.getType() == SubtotalType.MeasureUnit) {
                Optional<BalanceUnitVO> qty = subtotal.getAmount().getQty();
                return qty.isPresent() ? qty.get().getBeginCredit() : BigDecimal.ZERO;
            }
            return BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("begindebitrpt", (DataType)DataType.BigDecimalType, subtotal -> {
            Optional<BalanceUnitVO> rpt = subtotal.getAmount().getRpt();
            return rpt.isPresent() ? rpt.get().getBeginDebit() : BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("begincreditrpt", (DataType)DataType.BigDecimalType, subtotal -> {
            Optional<BalanceUnitVO> rpt = subtotal.getAmount().getRpt();
            return rpt.isPresent() ? rpt.get().getBeginCredit() : BigDecimal.ZERO;
        }));
    }

    private void buildPeriod(boolean isHideLocalAmount, boolean isShowOrg) {
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("debitfor", (DataType)DataType.BigDecimalType, subtotal -> {
            Optional<BalanceUnitVO> origin = subtotal.getAmount().getOrigin();
            return origin.isPresent() ? origin.get().getDebit() : BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("creditfor", (DataType)DataType.BigDecimalType, subtotal -> {
            Optional<BalanceUnitVO> origin = subtotal.getAmount().getOrigin();
            return origin.isPresent() ? origin.get().getCredit() : BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("debitlocal", (DataType)DataType.BigDecimalType, subtotal -> {
            if (isShowOrg && subtotal.getType() == SubtotalType.Org || !isHideLocalAmount) {
                BalanceUnitVO local = subtotal.getAmount().getLocal();
                return local.getDebit();
            }
            return BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("creditlocal", (DataType)DataType.BigDecimalType, subtotal -> {
            if (isShowOrg && subtotal.getType() == SubtotalType.Org || !isHideLocalAmount) {
                BalanceUnitVO local = subtotal.getAmount().getLocal();
                return local.getCredit();
            }
            return BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("debitqty", (DataType)DataType.BigDecimalType, subtotal -> {
            if (subtotal.getType() == SubtotalType.MeasureUnit) {
                Optional<BalanceUnitVO> qty = subtotal.getAmount().getQty();
                return qty.isPresent() ? qty.get().getDebit() : BigDecimal.ZERO;
            }
            return BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("creditqty", (DataType)DataType.BigDecimalType, subtotal -> {
            if (subtotal.getType() == SubtotalType.MeasureUnit) {
                Optional<BalanceUnitVO> qty = subtotal.getAmount().getQty();
                return qty.isPresent() ? qty.get().getCredit() : BigDecimal.ZERO;
            }
            return BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("debitrpt", (DataType)DataType.BigDecimalType, subtotal -> {
            Optional<BalanceUnitVO> rpt = subtotal.getAmount().getRpt();
            return rpt.isPresent() ? rpt.get().getDebit() : BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("creditrpt", (DataType)DataType.BigDecimalType, subtotal -> {
            Optional<BalanceUnitVO> rpt = subtotal.getAmount().getRpt();
            return rpt.isPresent() ? rpt.get().getCredit() : BigDecimal.ZERO;
        }));
    }

    private void buildYearAccumulated(boolean isHideLocalAmount, boolean isShowOrg) {
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("yeardebitfor", (DataType)DataType.BigDecimalType, subtotal -> {
            Optional<BalanceUnitVO> origin = subtotal.getAmount().getOrigin();
            return origin.isPresent() ? origin.get().getYearDebit() : BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("yearcreditfor", (DataType)DataType.BigDecimalType, subtotal -> {
            Optional<BalanceUnitVO> origin = subtotal.getAmount().getOrigin();
            return origin.isPresent() ? origin.get().getYearCredit() : BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("yeardebitlocal", (DataType)DataType.BigDecimalType, subtotal -> {
            if (isShowOrg && subtotal.getType() == SubtotalType.Org || !isHideLocalAmount) {
                BalanceUnitVO local = subtotal.getAmount().getLocal();
                return local.getYearDebit();
            }
            return BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("yearcreditlocal", (DataType)DataType.BigDecimalType, subtotal -> {
            if (isShowOrg && subtotal.getType() == SubtotalType.Org || !isHideLocalAmount) {
                BalanceUnitVO local = subtotal.getAmount().getLocal();
                return local.getYearCredit();
            }
            return BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("yeardebitqty", (DataType)DataType.BigDecimalType, subtotal -> {
            if (subtotal.getType() == SubtotalType.MeasureUnit) {
                Optional<BalanceUnitVO> qty = subtotal.getAmount().getQty();
                return qty.isPresent() ? qty.get().getYearDebit() : BigDecimal.ZERO;
            }
            return BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("yearcreditqty", (DataType)DataType.BigDecimalType, subtotal -> {
            if (subtotal.getType() == SubtotalType.MeasureUnit) {
                Optional<BalanceUnitVO> qty = subtotal.getAmount().getQty();
                return qty.isPresent() ? qty.get().getYearCredit() : BigDecimal.ZERO;
            }
            return BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("yeardebitrpt", (DataType)DataType.BigDecimalType, subtotal -> {
            Optional<BalanceUnitVO> rpt = subtotal.getAmount().getRpt();
            return rpt.isPresent() ? rpt.get().getYearDebit() : BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("yearcreditrpt", (DataType)DataType.BigDecimalType, subtotal -> {
            Optional<BalanceUnitVO> rpt = subtotal.getAmount().getRpt();
            return rpt.isPresent() ? rpt.get().getYearCredit() : BigDecimal.ZERO;
        }));
    }

    private void buildPeriodEnd(boolean isHideLocalAmount, boolean isShowOrg) {
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("enddebitfor", (DataType)DataType.BigDecimalType, subtotal -> {
            Optional<BalanceUnitVO> origin = subtotal.getAmount().getOrigin();
            return origin.isPresent() ? origin.get().getEndDebit() : BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("endcreditfor", (DataType)DataType.BigDecimalType, subtotal -> {
            Optional<BalanceUnitVO> origin = subtotal.getAmount().getOrigin();
            return origin.isPresent() ? origin.get().getEndCredit() : BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("enddebitlocal", (DataType)DataType.BigDecimalType, subtotal -> {
            if (isShowOrg && subtotal.getType() == SubtotalType.Org || !isHideLocalAmount) {
                BalanceUnitVO local = subtotal.getAmount().getLocal();
                return local.getEndDebit();
            }
            return BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("endcreditlocal", (DataType)DataType.BigDecimalType, subtotal -> {
            if (isShowOrg && subtotal.getType() == SubtotalType.Org || !isHideLocalAmount) {
                BalanceUnitVO local = subtotal.getAmount().getLocal();
                return local.getEndCredit();
            }
            return BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("enddebitqty", (DataType)DataType.BigDecimalType, subtotal -> {
            if (subtotal.getType() == SubtotalType.MeasureUnit) {
                Optional<BalanceUnitVO> qty = subtotal.getAmount().getQty();
                return qty.isPresent() ? qty.get().getEndDebit() : BigDecimal.ZERO;
            }
            return BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("endcreditqty", (DataType)DataType.BigDecimalType, subtotal -> {
            if (subtotal.getType() == SubtotalType.MeasureUnit) {
                Optional<BalanceUnitVO> qty = subtotal.getAmount().getQty();
                return qty.isPresent() ? qty.get().getEndCredit() : BigDecimal.ZERO;
            }
            return BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("enddebitrpt", (DataType)DataType.BigDecimalType, subtotal -> {
            Optional<BalanceUnitVO> rpt = subtotal.getAmount().getRpt();
            return rpt.isPresent() ? rpt.get().getEndDebit() : BigDecimal.ZERO;
        }));
        this.rowConverter.add((ColumnMeta<AssistBalanceSubtotal>)new ColumnMeta("endcreditrpt", (DataType)DataType.BigDecimalType, subtotal -> {
            Optional<BalanceUnitVO> rpt = subtotal.getAmount().getRpt();
            return rpt.isPresent() ? rpt.get().getEndCredit() : BigDecimal.ZERO;
        }));
    }

    public List<ColumnMeta<AssistBalanceSubtotal>> build() {
        return this.rowConverter;
    }
}

