/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.assistbalance;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.Tuple;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.service.balance.account.IAccountTreeModel;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.bd.util.TreeNodeRelationFactory;
import kd.fi.gl.enums.AssistShowType;
import kd.fi.gl.enums.CurrencyType;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.OrgType;
import kd.fi.gl.report.RateVO;
import kd.fi.gl.report.assistbalance.AccountIndex;
import kd.fi.gl.report.assistbalance.AssistBalanceAggregateCache;
import kd.fi.gl.report.assistbalance.AssistBalanceContext;
import kd.fi.gl.report.assistbalance.BalanceSubtotalSorter;
import kd.fi.gl.report.assistbalance.BalanceSumUpService;
import kd.fi.gl.report.assistbalance.QuickTotalService;
import kd.fi.gl.report.assistbalance.SubTotalCalculator;
import kd.fi.gl.report.assistbalance.model.AccountDistinctKey;
import kd.fi.gl.report.assistbalance.model.AccountVO;
import kd.fi.gl.report.assistbalance.model.AssistBalanceAmountRow;
import kd.fi.gl.report.assistbalance.model.AssistBalanceKey;
import kd.fi.gl.report.assistbalance.model.AssistBalanceSubtotal;
import kd.fi.gl.report.assistbalance.model.AssistSubtotalKey;
import kd.fi.gl.report.assistbalance.model.AssistTreeCategoryVO;
import kd.fi.gl.report.assistbalance.model.BalanceRow;
import kd.fi.gl.report.assistbalance.model.BalanceUnitVO;
import kd.fi.gl.report.assistbalance.model.RawBalanceRow;
import kd.fi.gl.report.assistbalance.model.RawPLVoucherRow;
import kd.fi.gl.report.assistbalance.model.SubtotalType;
import kd.fi.gl.util.DataSetHelper;
import kd.fi.gl.util.FastKey;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.SubsiDiaryHelper;
import kd.fi.gl.vo.AssistTreeStyleVO;
import org.apache.commons.lang3.StringUtils;

public class AssistBalanceProcessor {
    private static final Log LOG = LogFactory.getLog(AssistBalanceProcessor.class);
    public static final String CACHE_KEY_TREE_ASSIST_FIELD = "_tree_assist_field";
    private static final Long FAKE_GROUP_ROOT = 0L;
    private final MulOrgQPRpt qParam;
    private final Boolean isShowByDC;
    private final Boolean isShowOrigin;
    private final List<Tuple<String, String>> assistFieldAndProps;
    private final Map<Long, RateVO> orgRptRateMap;
    private final AccountIndex accountIndex;
    private final AccountIndex virtualOrgAccountIndex;
    private final BalanceSumUpService sumUpService;
    private final QuickTotalService quickTotalService;
    private final Set<AssistSubtotalKey> limitedSubtotalKeys = new HashSet<AssistSubtotalKey>(1024);
    private final Set<AssistSubtotalKey> otherSubtotalKeys = new HashSet<AssistSubtotalKey>(1024);
    private boolean finalDataSetBatch;
    private boolean exportAll;
    private final AssistBalanceAggregateCache aggregateRawBalanceCache;
    private final int showAssistLimit;
    private int showRowSize = 0;
    private int _rowIndex;
    private static volatile Predicate<AssistTreeStyleVO> isMulTree = x -> null != x && null != x.getCategory();
    private Table<Long, Long, AccountDistinctKey> accountTopAccCache = HashBasedTable.create();

    public AssistBalanceProcessor(int showAssistLimit, MulOrgQPRpt qParam, boolean isShowByDC, boolean isShowOrigin, List<Tuple<String, String>> assistFieldAndProps, IAccountTreeModel accTreeModel) {
        Preconditions.checkArgument((!CollectionUtils.isEmpty(assistFieldAndProps) ? 1 : 0) != 0);
        LOG.info("show assist size: {}", (Object)showAssistLimit);
        this.showAssistLimit = showAssistLimit;
        this.qParam = qParam;
        this.orgRptRateMap = qParam.getOrgCurRateMap();
        if (DebugTrace.enable()) {
            for (Map.Entry<Long, RateVO> entry : this.orgRptRateMap.entrySet()) {
                LOG.info("orgRptRateMap: org[{}] -> RateVO: [{}]", (Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        this.isShowByDC = isShowByDC;
        this.isShowOrigin = isShowOrigin;
        Map accRelations = accTreeModel.toMap();
        LOG.info("load account size:" + accRelations.size());
        this.sumUpService = new BalanceSumUpService(accRelations);
        this.assistFieldAndProps = assistFieldAndProps;
        this.accountIndex = new AccountIndex(accTreeModel, qParam.isShowAccountFullName(), this.sumUpService);
        this.virtualOrgAccountIndex = new AccountIndex(accTreeModel, qParam, this.sumUpService, this.accountIndex);
        AssistBalanceContext.get().setAccountIndex(this.accountIndex);
        boolean isEnableRawBalanceAggegateCache = BillParamUtil.getBooleanValue((String)"83bfebc8000017ac", (String)"fi.gl.report.assistbalance.aggegatecache.enable", (boolean)true);
        this.aggregateRawBalanceCache = isEnableRawBalanceAggegateCache ? new AssistBalanceAggregateCache() : null;
        LOG.info("aggegatecache.enable =  {}", (Object)(null != this.aggregateRawBalanceCache ? 1 : 0));
        this.quickTotalService = new QuickTotalService(qParam);
    }

    public void processBalance(RawBalanceRow rawRow) {
        ++this._rowIndex;
        Long accId = this.accountIndex.getAccountVOByOrgAndMid(rawRow.orgId, rawRow.accMid);
        AccountVO accountVO = this.accountIndex.getAccountVO(accId);
        AccountDistinctKey accDistinctKey = this.getAccountDistinctKeyFromCache(rawRow.orgId, accId);
        AssistSubtotalKey assistSubtotalKey = this.buildAssistSubtotalKey(rawRow, accDistinctKey);
        boolean isInShow = this.limitedSubtotalKeys.contains(assistSubtotalKey);
        if (isInShow) {
            if (null == this.aggregateRawBalanceCache) {
                AssistBalanceKey balanceKey = AssistBalanceKey.retrievalFromCacheOrBuild(rawRow.orgId, accId, rawRow.measureUnitId, rawRow.currencyId, rawRow.comAssistVals, rawRow.assistValues);
                AssistBalanceAmountRow balanceRow = this.buildBalanceRow(rawRow, this.isShowOrigin, accountVO.getDc());
                if (DebugTrace.enable()) {
                    LOG.info("detail_debug: processor: {}, compose key: {}, balanceKey {}, Amount: {} go to showin Process", new Object[]{this, assistSubtotalKey, balanceKey, balanceRow});
                }
                this.sumUpService.accept(balanceKey, balanceRow);
            } else {
                boolean isCacheSuccess = this.aggregateRawBalanceCache.push(rawRow);
                if (!isCacheSuccess) {
                    AssistBalanceKey balanceKey = AssistBalanceKey.retrievalFromCacheOrBuild(rawRow.orgId, accId, rawRow.measureUnitId, rawRow.currencyId, rawRow.comAssistVals, rawRow.assistValues);
                    AssistBalanceAmountRow balanceRow = this.buildBalanceRow(rawRow, this.isShowOrigin, accountVO.getDc());
                    if (DebugTrace.enable()) {
                        LOG.info("detail_debug: processor: {}, aggregate cached, balanceKey {}, Amount: {} go to showin Process", new Object[]{this, balanceKey, balanceRow});
                    }
                    this.sumUpService.accept(balanceKey, balanceRow);
                }
            }
        } else if (this.getCurrentShowPageComposeCount() < this.showAssistLimit) {
            if (null == this.aggregateRawBalanceCache) {
                AssistBalanceKey balanceKey = AssistBalanceKey.retrievalFromCacheOrBuild(rawRow.orgId, accId, rawRow.measureUnitId, rawRow.currencyId, rawRow.comAssistVals, rawRow.assistValues);
                AssistBalanceAmountRow balanceRow = this.buildBalanceRow(rawRow, this.isShowOrigin, accountVO.getDc());
                this.sumUpService.accept(balanceKey, balanceRow);
                if (DebugTrace.enable()) {
                    LOG.info("detail_debug: processor: {}, compose key: {}, balanceKey {}, Amount: {} go to showin Process", new Object[]{this, assistSubtotalKey, balanceKey, balanceRow});
                }
            } else {
                boolean isCacheSuccess = this.aggregateRawBalanceCache.push(rawRow);
                if (!isCacheSuccess) {
                    AssistBalanceKey balanceKey = AssistBalanceKey.retrievalFromCacheOrBuild(rawRow.orgId, accId, rawRow.measureUnitId, rawRow.currencyId, rawRow.comAssistVals, rawRow.assistValues);
                    AssistBalanceAmountRow balanceRow = this.buildBalanceRow(rawRow, this.isShowOrigin, accountVO.getDc());
                    this.sumUpService.accept(balanceKey, balanceRow);
                }
            }
            this.limitedSubtotalKeys.add(assistSubtotalKey);
        } else {
            AssistBalanceAmountRow balanceRow = this.buildBalanceRow(rawRow, this.isShowOrigin, accountVO.getDc());
            this.quickTotalService.accept(assistSubtotalKey, balanceRow);
            if (DebugTrace.enable()) {
                LOG.info("detail_debug: processor: {}, compose key: {}, balanceKey {}, Amount: {} go to quick Process", new Object[]{this, assistSubtotalKey, assistSubtotalKey, balanceRow});
            }
        }
    }

    public void computeAggregateCache() {
        if (null != this.aggregateRawBalanceCache) {
            Collection<RawBalanceRow> aggregatedRawRows = this.aggregateRawBalanceCache.listRowsAndClear();
            LOG.info("compute aggregate rawBalance cache sie: {}, merge times: {}, _outLimitTimes: {}", new Object[]{aggregatedRawRows.size(), this.aggregateRawBalanceCache.getMergeTimes(), this.aggregateRawBalanceCache.getOutLimitTimes()});
            LOG.info("compute aggregate rawBalance cache :" + aggregatedRawRows.size());
            for (RawBalanceRow rawRow : aggregatedRawRows) {
                Long accId = this.accountIndex.getAccountVOByOrgAndMid(rawRow.orgId, rawRow.accMid);
                AccountVO accountVO = this.accountIndex.getAccountVO(accId);
                AssistBalanceKey balanceKey = AssistBalanceKey.retrievalFromCacheOrBuild(rawRow.orgId, accId, rawRow.measureUnitId, rawRow.currencyId, rawRow.comAssistVals, rawRow.assistValues);
                AssistBalanceAmountRow balanceRow = this.buildBalanceRow(rawRow, this.isShowOrigin, accountVO.getDc());
                if (DebugTrace.enable()) {
                    LOG.info("computeAggregateCache row: key - {}, row: {}", (Object)balanceKey, (Object)balanceRow);
                }
                this.sumUpService.accept(balanceKey, balanceRow);
            }
        }
    }

    public Map<List<Object>, Map<AccountDistinctKey, AssistBalanceAmountRow>> _listAllAssistSubtotals() {
        SubTotalCalculator subtotalCalculator = new SubTotalCalculator(this.qParam);
        this.sumUpService.executeSumUp();
        List<BalanceRow> showBalanceRows = this.sumUpService.collectAllAndClear();
        List<AssistBalanceSubtotal> showSubtotals = subtotalCalculator.calculateSubtotal(showBalanceRows);
        HashMap<List<Object>, Map<AccountDistinctKey, AssistBalanceAmountRow>> indexCache = new HashMap<List<Object>, Map<AccountDistinctKey, AssistBalanceAmountRow>>();
        for (AssistBalanceSubtotal subtotal : showSubtotals) {
            AssistBalanceKey balanceKey = subtotal.getSampleBalanceKey();
            List<Object> assists = balanceKey.getAssistValues();
            if (!indexCache.containsKey(assists)) {
                indexCache.put(assists, new HashMap());
            }
            AccountDistinctKey accNum = AssistBalanceContext.get().getAccountIndex().getAccountVO(balanceKey.getAccountId()).convertTo();
            ((Map)indexCache.get(assists)).put(accNum, subtotal.getAmount());
        }
        Map<AssistSubtotalKey, AssistBalanceAmountRow> quickSubtotals = this.quickTotalService.getDimensionBalances();
        for (Map.Entry<AssistSubtotalKey, AssistBalanceAmountRow> entry : quickSubtotals.entrySet()) {
            AccountDistinctKey accKey = entry.getKey().getAccountKey();
            List<Object> assists = entry.getKey().getAssistValues();
            if (!indexCache.containsKey(assists)) {
                indexCache.put(assists, new HashMap());
            }
            if (null != ((Map)indexCache.get(assists)).get(accKey)) {
                String assistMsg = String.join((CharSequence)",", assists.stream().map(x -> String.valueOf(x)).collect(Collectors.toList()));
                throw new KDBizException("assist: " + assistMsg + ", account number: " + accKey + " had existed, logic error");
            }
            ((Map)indexCache.get(assists)).put(accKey, entry.getValue());
        }
        return indexCache;
    }

    public Tuple<List<AssistBalanceSubtotal>, List<AssistBalanceSubtotal>> computeSubTotalAndTotal(boolean isZeroAmtNoDisplay) {
        SubTotalCalculator subtotalCalculator = new SubTotalCalculator(this.qParam);
        if (!this.qParam.isShowLeafAccount()) {
            this.sumUpService.executeSumUp();
        }
        List<BalanceRow> showBalanceRows = this.sumUpService.collectAllAndClear();
        boolean transVirtulOrg = BillParamUtil.getBooleanValue((String)"83bfebc8000017ac", (String)"fi.gl.report.assistbalance.trans.virtualorg", (boolean)false);
        if (this.qParam.getOrgType() != OrgType.ENTITY && transVirtulOrg) {
            ArrayList<BalanceRow> transBalanceRows = new ArrayList<BalanceRow>(showBalanceRows.size());
            block0: for (BalanceRow row : showBalanceRows) {
                AssistBalanceKey assistBalanceKey = row.getBalanceKey();
                Iterator<Map.Entry<Long, AssistBalanceAmountRow>> accountVO = this.accountIndex.getAccountVO(assistBalanceKey.getAccountId());
                String longNumber = ((AccountVO)((Object)accountVO)).getLongNumber();
                String[] numbers = longNumber.split("_");
                for (int i = numbers.length - 1; i >= 0; --i) {
                    String showAccountNumber = numbers[i];
                    AccountVO virtualOrgAccountVO = this.virtualOrgAccountIndex.getAccountVO(showAccountNumber);
                    if (Objects.nonNull(virtualOrgAccountVO)) {
                        AssistBalanceKey newBalanceKey = AssistBalanceKey.retrievalFromCacheOrBuild(assistBalanceKey.getOrgId(), virtualOrgAccountVO.getId(), assistBalanceKey.getMeasureUnitId(), assistBalanceKey.getCurrencyId(), assistBalanceKey.getComAssistVals(), assistBalanceKey.getAssistValues());
                        BalanceRow balanceRow = new BalanceRow(newBalanceKey, row.getAmount());
                        transBalanceRows.add(balanceRow);
                        continue block0;
                    }
                    if (!this.qParam.isShowLeafAccount()) continue block0;
                }
            }
            showBalanceRows = transBalanceRows;
        }
        showBalanceRows.stream().forEach(x -> x.getAmount().autoAdjustAmount(this.qParam.isShowDataByDC(), this.accountIndex.getAccountVO(x.getBalanceKey().getAccountId()).getDc()));
        List<BalanceRow> filteredBalanceRows = AssistBalanceProcessor.filterShowBalance(showBalanceRows, this.qParam.isNoZeroBalance(), isZeroAmtNoDisplay);
        if (DebugTrace.enable()) {
            for (BalanceRow balanceRow : filteredBalanceRows) {
                LOG.info("result subtotal item: {} - {}", (Object)balanceRow.getBalanceKey(), (Object)balanceRow.getAmount());
            }
        }
        List<AssistBalanceSubtotal> showSubtotals = subtotalCalculator.calculateSubtotal(filteredBalanceRows);
        LOG.info("collect assist compose {},  would generate {} page rows.", (Object)this.getCurrentShowPageComposeCount(), (Object)showSubtotals.stream().mapToInt(AssistBalanceSubtotal::estimateTargetRowCount).sum());
        List<AssistBalanceSubtotal> totals = subtotalCalculator.calculateTotalFromSubtotal(showSubtotals);
        Map<Long, AssistBalanceAmountRow> quickTotalMap = this.quickTotalService.calculatedTotal();
        if (DebugTrace.enable()) {
            LOG.info("quick calculated total result as : {}", (Object)StringUtils.join((Object[])new List[]{quickTotalMap.entrySet().stream().map(e -> e.getKey() + " [currency] -> " + ((AssistBalanceAmountRow)e.getValue()).toString()).collect(Collectors.toList())}));
        }
        if (AssistBalanceContext.get().getIsEnableCurrencyGroup().booleanValue()) {
            for (AssistBalanceSubtotal total : totals) {
                Long currency = total.getSampleBalanceKey().getCurrencyId();
                if (!quickTotalMap.containsKey(currency)) continue;
                AssistBalanceAmountRow quickAmount = quickTotalMap.remove(currency);
                total.getAmount().merge(quickAmount);
            }
            if (!quickTotalMap.isEmpty()) {
                throw new KDBizException(GLErrorCode.BIZ_ERR, new Object[0]);
            }
        } else if (totals.isEmpty()) {
            totals = new ArrayList<AssistBalanceSubtotal>(8);
            for (Map.Entry<Long, AssistBalanceAmountRow> entry : quickTotalMap.entrySet()) {
                AssistBalanceSubtotal subtotal = new AssistBalanceSubtotal(SubtotalType.Total, new AssistBalanceKey(0L, 0L, 0L, 0L, new ArrayList<Object>(8), new ArrayList<Long>(8)), FastKey.EMPTY);
                subtotal.setAmount(entry.getValue());
                totals.add(subtotal);
            }
        } else {
            Preconditions.checkState((totals.size() == 1 && quickTotalMap.size() <= 1 ? 1 : 0) != 0, (Object)"logic error");
            if (!quickTotalMap.isEmpty()) {
                AssistBalanceAmountRow amountRow = totals.get(0).getAmount();
                amountRow.merge(new ArrayList<AssistBalanceAmountRow>(quickTotalMap.values()).get(0), true);
            }
        }
        int showPageComposeCnt = showSubtotals.size();
        int quickTotalComposeCnt = this.quickTotalService.getTotalComposeAmount();
        LOG.warn("real assist compose should be : {}, show page count: {}, quick total compose count: {}", new Object[]{showPageComposeCnt + quickTotalComposeCnt, showPageComposeCnt, quickTotalComposeCnt});
        this.quickTotalService.clear();
        return Tuple.create(showSubtotals, totals);
    }

    private static List<BalanceRow> filterShowBalance(List<BalanceRow> balanceRows, boolean isNoZeroBalance, boolean isZeroAmtNoDisplay) {
        if (DebugTrace.enable()) {
            LOG.info("options: isNoZeroBalance  - {}, isZeroAmtNoDisplay - {}", (Object)isNoZeroBalance, (Object)isZeroAmtNoDisplay);
        }
        if (!isNoZeroBalance && !isZeroAmtNoDisplay) {
            return balanceRows;
        }
        if (DebugTrace.enable()) {
            for (BalanceRow balanceRow : balanceRows) {
                LOG.info("subtotal item: {} - {}", (Object)balanceRow.getBalanceKey(), (Object)balanceRow.getAmount());
            }
        }
        return balanceRows.stream().filter(x -> x.filterNoDisplay(isNoZeroBalance, isZeroAmtNoDisplay)).collect(Collectors.toList());
    }

    public AssistBalanceAmountRow buildBalanceRow(RawBalanceRow rawRow, boolean isShowOrigin, int accountDC) {
        boolean isShowQty = this.qParam.isShowQty();
        RateVO rateVO = null;
        if (this.qParam.isShowRpt()) {
            rateVO = this.orgRptRateMap.get(rawRow.orgId);
        }
        AssistBalanceAmountRow row = new AssistBalanceAmountRow(this.isShowByDC, accountDC, isShowOrigin, isShowQty, rawRow, rateVO, rawRow.ventryCount);
        if (DebugTrace.enable()) {
            LOG.info("assistbalancerow: {}", (Object)row);
        }
        return row;
    }

    public void processBalanceLog(RawBalanceRow rawRow, boolean isShowOrigin) {
        ++this._rowIndex;
        int endPeriodYear = (int)PeriodUtil.getYear((long)this.qParam.getEndPeriod());
        long accId = this.accountIndex.getAccountVOByOrgAndMid(rawRow.orgId, rawRow.accMid);
        AssistBalanceKey balanceKey = AssistBalanceKey.retrievalFromCacheOrBuild(rawRow.orgId, accId, rawRow.measureUnitId, rawRow.currencyId, rawRow.comAssistVals, rawRow.assistValues);
        BalanceUnitVO originUnit = null;
        BalanceUnitVO qtyUnit = null;
        AccountVO accountVO = this.accountIndex.getAccountVO(accId);
        if (isShowOrigin) {
            BigDecimal debitFor = rawRow.debitfor;
            BigDecimal creditFor = rawRow.creditfor;
            BigDecimal[] originAmountFacts = this.extractAmountFactorForBalanceLog(rawRow.period, endPeriodYear, debitFor, creditFor);
            originUnit = new BalanceUnitVO(CurrencyType.Origin, this.isShowByDC, accountVO.getDc(), originAmountFacts[0], originAmountFacts[1], originAmountFacts[2], originAmountFacts[3], originAmountFacts[4], originAmountFacts[5]);
        }
        BigDecimal debitLocal = rawRow.debitlocal;
        BigDecimal creditLocal = rawRow.creditlocal;
        BigDecimal[] localAmountFacts = this.extractAmountFactorForBalanceLog(rawRow.period, endPeriodYear, debitLocal, creditLocal);
        BalanceUnitVO localUnit = new BalanceUnitVO(CurrencyType.Local, this.isShowByDC, accountVO.getDc(), localAmountFacts[0], localAmountFacts[1], localAmountFacts[2], localAmountFacts[3], localAmountFacts[4], localAmountFacts[5]);
        if (this.qParam.isShowQty()) {
            BigDecimal debitQty = rawRow.debitqty;
            BigDecimal creditQty = rawRow.creditqty;
            BigDecimal[] qtyAmountFacts = this.extractAmountFactorForBalanceLog(rawRow.period, endPeriodYear, debitQty, creditQty);
            qtyUnit = new BalanceUnitVO(CurrencyType.Qty, this.isShowByDC, accountVO.getDc(), qtyAmountFacts[0], qtyAmountFacts[1], qtyAmountFacts[2], qtyAmountFacts[3], qtyAmountFacts[4], qtyAmountFacts[5]);
        }
        RateVO rateVO = null;
        if (this.qParam.isShowRpt()) {
            rateVO = this.orgRptRateMap.get(balanceKey.getOrgId());
        }
        AccountDistinctKey accDistinctKey = this.getAccountDistinctKeyFromCache(rawRow.orgId, accId);
        AssistSubtotalKey assistSubtotalKey = this.buildAssistSubtotalKey(rawRow, accDistinctKey);
        AssistBalanceAmountRow amountRow = new AssistBalanceAmountRow(originUnit, localUnit, qtyUnit, rateVO, rawRow.ventryCount);
        this.feedByRoute(assistSubtotalKey, balanceKey, amountRow);
    }

    private void feedByRoute(AssistSubtotalKey assistSubtotalKey, AssistBalanceKey balanceKey, AssistBalanceAmountRow amountRow) {
        if (this.exportAll) {
            if (this.finalDataSetBatch) {
                if (!this.otherSubtotalKeys.contains(assistSubtotalKey)) {
                    this.sumUpService.accept(balanceKey, amountRow);
                }
            } else if (this.limitedSubtotalKeys.contains(assistSubtotalKey)) {
                this.otherSubtotalKeys.add(assistSubtotalKey);
                this.sumUpService.accept(balanceKey, amountRow);
            }
        } else {
            if (this.getCurrentShowPageComposeCount() < this.showAssistLimit) {
                this.limitedSubtotalKeys.add(assistSubtotalKey);
            }
            if (this.limitedSubtotalKeys.contains(assistSubtotalKey)) {
                this.sumUpService.accept(balanceKey, amountRow);
            } else {
                this.quickTotalService.accept(assistSubtotalKey, amountRow);
            }
        }
    }

    public void subtractPLVoucher(RawPLVoucherRow rawPLVouRow) {
        ++this._rowIndex;
        long accId = this.accountIndex.getAccountVOByOrgAndMid(rawPLVouRow.orgId, rawPLVouRow.accMid);
        AssistBalanceKey balanceKey = AssistBalanceKey.retrievalFromCacheOrBuild(rawPLVouRow.orgId, accId, this.qParam.isShowQty() ? rawPLVouRow.measureUnitId : null, !this.qParam.isSynCurrency() ? rawPLVouRow.currencyId : null, rawPLVouRow.comAssistVals, rawPLVouRow.assistValues);
        BalanceUnitVO originUnit = null;
        BalanceUnitVO qtyUnit = null;
        AccountVO accountVO = this.accountIndex.getAccountVO(accId);
        if (this.isShowOrigin.booleanValue()) {
            BigDecimal endFor = rawPLVouRow.vbeginfor.add(rawPLVouRow.vdebitfor.subtract(rawPLVouRow.vcreditfor));
            originUnit = new BalanceUnitVO(CurrencyType.Origin, this.isShowByDC, accountVO.getDc(), rawPLVouRow.vdebitfor, rawPLVouRow.vcreditfor, rawPLVouRow.vbeginfor, endFor, rawPLVouRow.yearvdebitfor, rawPLVouRow.yearvcreditfor);
            originUnit.adaptForPLVoucher();
        }
        BigDecimal endLocal = rawPLVouRow.vbeginlocal.add(rawPLVouRow.vdebitlocal.subtract(rawPLVouRow.vcreditlocal));
        BalanceUnitVO localUnit = new BalanceUnitVO(CurrencyType.Local, this.isShowByDC, accountVO.getDc(), rawPLVouRow.vdebitlocal, rawPLVouRow.vcreditlocal, rawPLVouRow.vbeginlocal, endLocal, rawPLVouRow.yearvdebitlocal, rawPLVouRow.yearvcreditlocal);
        localUnit.adaptForPLVoucher();
        if (this.qParam.isShowQty()) {
            BigDecimal endQty = rawPLVouRow.vbeginqty.add(rawPLVouRow.vdebitqty.subtract(rawPLVouRow.vcreditqty));
            qtyUnit = new BalanceUnitVO(CurrencyType.Qty, this.isShowByDC, accountVO.getDc(), rawPLVouRow.vdebitqty, rawPLVouRow.vcreditqty, rawPLVouRow.vbeginqty, endQty, rawPLVouRow.yearvdebitqty, rawPLVouRow.yearvcreditqty);
            qtyUnit.adaptForPLVoucher();
        }
        RateVO rateVO = null;
        if (this.qParam.isShowRpt()) {
            rateVO = this.orgRptRateMap.get(balanceKey.getOrgId());
        }
        AccountDistinctKey accDistinctKey = this.getAccountDistinctKeyFromCache(rawPLVouRow.orgId, accId);
        AssistSubtotalKey assistSubtotalKey = this.buildAssistSubtotalKey(rawPLVouRow, accDistinctKey);
        AssistBalanceAmountRow amountRow = new AssistBalanceAmountRow(originUnit, localUnit, qtyUnit, rateVO, -rawPLVouRow.getVentryCount());
        this.feedByRoute(assistSubtotalKey, balanceKey, amountRow);
    }

    public List<AssistBalanceSubtotal> calculateByAssist(List<AssistBalanceSubtotal> accSubtotals, List<AssistBalanceSubtotal> totals, Optional<AssistTreeStyleVO> treeStyle, BalanceSubtotalSorter sorter) {
        totals.forEach(x -> x.setAssistTreeCategoryVO(new AssistTreeCategoryVO()));
        ArrayList<AssistBalanceSubtotal> allSubtotals = new ArrayList<AssistBalanceSubtotal>(8);
        if (!accSubtotals.isEmpty() && treeStyle.isPresent()) {
            ArrayList<AssistBalanceSubtotal> rawSubtotals = new ArrayList<AssistBalanceSubtotal>(8);
            int treeAssistIndex = this.getTreeAssistIndex(treeStyle.get().getAssistProp());
            ThreadCache.put((Object)CACHE_KEY_TREE_ASSIST_FIELD, (Object)this.assistFieldAndProps.get((int)treeAssistIndex).item1);
            HashMap detailIdToSubtotalMap = new HashMap(8);
            for (AssistBalanceSubtotal subtotal : accSubtotals) {
                long assistId = (Long)subtotal.getSampleBalanceKey().getAssistValues().get(treeAssistIndex);
                detailIdToSubtotalMap.putIfAbsent(assistId, new ArrayList(8));
            }
            Set assistIds = detailIdToSubtotalMap.keySet();
            DataSet _detailAssistInfoDS = QueryServiceHelper.queryDataSet((String)(AssistBalanceProcessor.class.getName() + ".getDetailAssist"), (String)treeStyle.get().getEntityId(), (String)"id,number,name", (QFilter[])new QFilter("id", "in", assistIds).toArray(), null);
            HashMap<Long, Tuple<String, String>> assistIdNumNameMap = new HashMap<Long, Tuple<String, String>>(8);
            while (_detailAssistInfoDS.hasNext()) {
                Row row = _detailAssistInfoDS.next();
                assistIdNumNameMap.put(row.getLong("id"), (Tuple<String, String>)new Tuple((Object)row.getString("number"), (Object)row.getString("name")));
            }
            HashMap assistTreeInfoIndex = new HashMap(8);
            Optional<BiTreeNode<Long, AssistTreeCategoryVO>> assistTree = this.getTreeLevelSet(treeStyle.get(), assistIdNumNameMap);
            if (assistTree.isPresent()) {
                assistTree.get().preTravel(x -> assistTreeInfoIndex.put(x.getId(), x.getData()));
                Set assistIdWithCategory = assistTreeInfoIndex.keySet();
                assistIdWithCategory.remove(FAKE_GROUP_ROOT);
                HashBasedTable assistSubtotalTable = HashBasedTable.create();
                SubTotalCalculator subtotalCalculator = new SubTotalCalculator(this.qParam);
                Function<AssistBalanceKey, FastKey> accGroupFunc = subtotalCalculator.getSubtotalFunctionByAccount().getGroupKeyFunc().get();
                for (AssistBalanceSubtotal assistBalanceSubtotal : accSubtotals) {
                    AssistBalanceKey originAssitKey = assistBalanceSubtotal.getSampleBalanceKey();
                    ArrayList<Object> excludedAssistValues = new ArrayList<Object>(2);
                    Long assistId = null;
                    for (int k = 0; k < originAssitKey.getAssistValues().size(); ++k) {
                        if (k != treeAssistIndex) {
                            excludedAssistValues.add(originAssitKey.getAssistValues().get(k));
                            continue;
                        }
                        assistId = (Long)originAssitKey.getAssistValues().get(k);
                        excludedAssistValues.add(null);
                    }
                    if (null == assistId) {
                        throw new KDBizException("logic error: the assistId can not be null.");
                    }
                    if (!assistIdWithCategory.contains(assistId)) {
                        AssistTreeCategoryVO categoryVO = new AssistTreeCategoryVO();
                        Tuple numberAndName = (Tuple)assistIdNumNameMap.get(assistId);
                        if (null != numberAndName) {
                            categoryVO.setName((String)numberAndName.item2);
                            categoryVO.setNumber((String)numberAndName.item1);
                        }
                        categoryVO.setLongNumber(categoryVO.getNumber());
                        categoryVO.setIsLeaf(true);
                        assistBalanceSubtotal.setAssistTreeCategoryVO(categoryVO);
                        rawSubtotals.add(assistBalanceSubtotal);
                        continue;
                    }
                    AssistBalanceKey excludedTreeAssitKey = AssistBalanceKey.retrievalFromCacheOrBuild(0L, originAssitKey.getAccountId(), originAssitKey.getMeasureUnitId(), originAssitKey.getCurrencyId(), originAssitKey.getComAssistVals(), excludedAssistValues);
                    assistSubtotalTable.put((Object)accGroupFunc.apply(excludedTreeAssitKey), (Object)assistId, (Object)assistBalanceSubtotal);
                }
                Set excludeBalanceKeyGroupSet = assistSubtotalTable.rowKeySet();
                for (FastKey groupKey : excludeBalanceKeyGroupSet) {
                    Map assistSubtotalMap = assistSubtotalTable.row((Object)groupKey);
                    long rootAssistId = (Long)assistTree.get().getId();
                    BiTreeNode subtotalTree = new BiTreeNode((Object)rootAssistId, null);
                    HashMap<Long, BiTreeNode> subtotalTreeIndex = new HashMap<Long, BiTreeNode>(8);
                    subtotalTreeIndex.put(rootAssistId, subtotalTree);
                    assistTree.get().preTravel(x -> {
                        long assistId = (Long)x.getId();
                        if (!subtotalTreeIndex.containsKey(assistId)) {
                            BiTreeNode newNode = new BiTreeNode((Object)assistId, null);
                            subtotalTreeIndex.put(assistId, newNode);
                            newNode.quickSetParent((BiTreeNode)subtotalTreeIndex.get(x.getParentId()));
                        }
                    });
                    for (Map.Entry entry : assistSubtotalMap.entrySet()) {
                        long assistId = (Long)entry.getKey();
                        if (!subtotalTreeIndex.containsKey(assistId)) {
                            LOG.info("subtotalTreeIndex all IDs:" + StringUtils.join(subtotalTreeIndex.keySet(), (String)","));
                            throw new KDBizException("maybe logic error: subtotalTreeIndex does not contain assistId:" + assistId);
                        }
                        ((BiTreeNode)subtotalTreeIndex.get(assistId)).setData((Serializable)entry.getValue());
                    }
                    long disTick = System.currentTimeMillis();
                    subtotalTree.postTravel(x -> {
                        BiTreeNode node = x;
                        node.batchRemoveChild(c -> null == c.getData() && CollectionUtils.isEmpty((Collection)c.getChild()));
                    });
                    if (DebugTrace.enable()) {
                        LOG.info("remove nonused nodes cost: {}.", (Object)(System.currentTimeMillis() - disTick));
                    }
                    subtotalTree.postTravel(_x -> {
                        if (_x.getId() == FAKE_GROUP_ROOT) {
                            return;
                        }
                        BiTreeNode node = _x;
                        if (!CollectionUtils.isEmpty((Collection)node.getChild())) {
                            for (BiTreeNode oneChild : node.getChild()) {
                                if (null == node.getData()) {
                                    try {
                                        AssistBalanceSubtotal subtotalClone = ((AssistBalanceSubtotal)oneChild.getData()).clone();
                                        node.setData((Serializable)subtotalClone);
                                        continue;
                                    }
                                    catch (CloneNotSupportedException e) {
                                        throw new KDBizException("AssistBalanceSubtotal clone failed.");
                                    }
                                }
                                ((AssistBalanceSubtotal)node.getData()).merge((AssistBalanceSubtotal)oneChild.getData());
                            }
                        }
                    });
                    subtotalTree.preTravel(x -> {
                        if (!FAKE_GROUP_ROOT.equals(x.getId())) {
                            rawSubtotals.add((AssistBalanceSubtotal)x.getData());
                        }
                        if (null != x.getData()) {
                            x.getChild().forEach(c -> ((AssistBalanceSubtotal)c.getData()).setParentPoint((AssistBalanceSubtotal)x.getData()));
                        }
                        if (null != x.getData()) {
                            AssistBalanceSubtotal subtotal = (AssistBalanceSubtotal)x.getData();
                            long assistId = (Long)x.getId();
                            subtotal.setAssistTreeCategoryVO((AssistTreeCategoryVO)assistTreeInfoIndex.get(assistId));
                        }
                    });
                }
                boolean bl = AssistShowType.FollowLevel.getValue() == treeStyle.get().getShowType();
                int levelThreshold = bl ? Integer.MAX_VALUE : treeStyle.get().getSpecificLevel();
                List<AssistBalanceSubtotal> sortedAccSubtotals = sorter.executeForTreeStyle(rawSubtotals, treeAssistIndex, assistTree.get(), !this.qParam.isSynCurrency());
                for (AssistBalanceSubtotal accSubtotal : sortedAccSubtotals) {
                    if (null == accSubtotal.getAssistTreeCategoryVO().getLevel() || accSubtotal.getAssistTreeCategoryVO().getLevel() <= levelThreshold) {
                        allSubtotals.addAll(accSubtotal.collect());
                    }
                    if (allSubtotals.size() < this.showAssistLimit) continue;
                    break;
                }
            } else {
                LOG.warn("No available tree style to use.");
                allSubtotals.addAll(accSubtotals.stream().flatMap(x -> x.collect().stream()).collect(Collectors.toList()));
            }
        } else {
            allSubtotals.addAll(accSubtotals.stream().flatMap(x -> x.collect().stream()).collect(Collectors.toList()));
        }
        allSubtotals.addAll(totals);
        return allSubtotals;
    }

    private int getTreeAssistIndex(String assistProp) {
        for (int i = 0; i < this.assistFieldAndProps.size(); ++i) {
            Tuple<String, String> item = this.assistFieldAndProps.get(i);
            if (!((String)item.item2).equals(assistProp)) continue;
            return i;
        }
        throw new KDBizException("logic error, can not find assist index by prop:" + assistProp);
    }

    private BigDecimal[] extractAmountFactorForBalanceLog(long period, int endPeriodYear, BigDecimal debitAmount, BigDecimal creditAmount) {
        BigDecimal debit = BigDecimal.ZERO;
        BigDecimal credit = BigDecimal.ZERO;
        if (period >= this.qParam.getStartPeriod() && period <= this.qParam.getEndPeriod()) {
            debit = debitAmount;
            credit = creditAmount;
        }
        BigDecimal yearDebit = BigDecimal.ZERO;
        BigDecimal yearCredit = BigDecimal.ZERO;
        if ((int)PeriodUtil.getYear((long)period) == endPeriodYear) {
            yearDebit = debitAmount;
            yearCredit = creditAmount;
        }
        BigDecimal diff = debitAmount.subtract(creditAmount);
        BigDecimal begin = BigDecimal.ZERO;
        if (period < this.qParam.getStartPeriod()) {
            begin = diff;
        }
        BigDecimal end = diff;
        return new BigDecimal[]{debit, credit, begin, end, yearDebit, yearCredit};
    }

    private static String buildGroupDetailEntity(String entityId) {
        return entityId + "groupdetail";
    }

    private Optional<BiTreeNode<Long, AssistTreeCategoryVO>> getTreeLevelSet(AssistTreeStyleVO treeStyle, Map<Long, Tuple<String, String>> usedAssistInfoMap) {
        Set usedAssistIds = usedAssistInfoMap.keySet();
        String entityId = treeStyle.getEntityId();
        if (FlexUtils.specialEntity.contains(entityId)) {
            Optional<BiTreeNode<Long, AssistTreeCategoryVO>> assistTree;
            Object vo;
            long viewId = SubsiDiaryHelper.getOrgViewId((String)"1", (String)entityId, (String)treeStyle.getAssistProp());
            QFilter fview = new QFilter("view", "=", (Object)viewId);
            String selStructure = "org treeid,parent treeparent,longnumber,level treelevel,isleaf";
            DataSet orgStructureDS = QueryServiceHelper.queryDataSet((String)"SubsiDiaryHelper.queryStructTree", (String)((String)FlexUtils.specialEntityMap.get(entityId)), (String)selStructure, (QFilter[])new QFilter[]{fview}, null);
            HashMap<Long, Object> orgInfoMap = new HashMap<Long, Object>(8);
            HashMap<Long, Long> orgToParentMap = new HashMap<Long, Long>(8);
            while (orgStructureDS.hasNext()) {
                Row row = orgStructureDS.next();
                vo = new AssistTreeCategoryVO();
                ((AssistTreeCategoryVO)vo).setId(row.getLong("treeid"));
                ((AssistTreeCategoryVO)vo).setParent(row.getLong("treeparent"));
                ((AssistTreeCategoryVO)vo).setLongNumber(row.getString("longnumber"));
                ((AssistTreeCategoryVO)vo).setLevel(row.getInteger("treelevel"));
                ((AssistTreeCategoryVO)vo).setIsLeaf(row.getBoolean("isleaf"));
                orgInfoMap.put(((AssistTreeCategoryVO)vo).getId(), vo);
                orgToParentMap.put(((AssistTreeCategoryVO)vo).getId(), ((AssistTreeCategoryVO)vo).getParent());
            }
            HashMap<Long, AssistTreeCategoryVO> availableOrgs = new HashMap<Long, AssistTreeCategoryVO>(8);
            vo = usedAssistIds.iterator();
            while (vo.hasNext()) {
                long usedOrgId = (Long)vo.next();
                Long curOrgId = usedOrgId;
                while (null != curOrgId) {
                    AssistTreeCategoryVO info = (AssistTreeCategoryVO)orgInfoMap.get(curOrgId);
                    if (!availableOrgs.containsKey(curOrgId) && null != info) {
                        availableOrgs.put(curOrgId, info);
                    }
                    curOrgId = (Long)orgToParentMap.get(curOrgId);
                }
            }
            Set orgIds = availableOrgs.values().stream().map(AssistTreeCategoryVO::getId).collect(Collectors.toSet());
            String selOrg = "name treename,number treenumber,id";
            DataSet orgDetailSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityId, (String)selOrg, (QFilter[])new QFilter("id", "in", orgIds).toArray(), null);
            while (orgDetailSet.hasNext()) {
                Row row = orgDetailSet.next();
                long orgId = row.getLong("id");
                AssistTreeCategoryVO categoryVO = (AssistTreeCategoryVO)orgInfoMap.get(orgId);
                categoryVO.setName(row.getString("treename"));
                categoryVO.setNumber(row.getString("treenumber"));
            }
            HashMap assistCategoryTreeIndex = new HashMap(8);
            if (!availableOrgs.isEmpty()) {
                Map<Long, AssistTreeCategoryVO> categoryIndex = availableOrgs.values().stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
                assistTree = Optional.of(this.buildAssistTree(availableOrgs.values()));
                assistTree.get().preTravel(x -> {
                    x.setData((Serializable)categoryIndex.get(x.getId()));
                    assistCategoryTreeIndex.put(x.getId(), x);
                });
            } else {
                assistTree = Optional.empty();
            }
            if (DebugTrace.enable()) {
                LOG.info("assit_category_details\uff1a" + String.join((CharSequence)"\n", assistCategoryTreeIndex.entrySet().stream().map(x -> String.format("assistId: %s -> category: %s", x.getKey(), x.getValue())).collect(Collectors.toList())));
            }
            return assistTree;
        }
        if (null != treeStyle.getCategory()) {
            if (isMulTree.test(treeStyle)) {
                entityId = entityId + "group";
            }
            Long standardId = treeStyle.getCategory();
            String groupSelectFields = "id treeid,parent treeparent,name treename,number treenumber,longnumber,level treelevel";
            DataSet groupDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityId, (String)groupSelectFields, (QFilter[])new QFilter("standard", "=", (Object)standardId).toArray(), null);
            if (DebugTrace.enable()) {
                LOG.info("query tree category info with: entityId: {}, group fields: {}, standard id:{}", new Object[]{entityId, groupSelectFields, standardId});
            }
            ArrayList<AssistTreeCategoryVO> assistGroupVOs = new ArrayList<AssistTreeCategoryVO>(8);
            while (groupDS.hasNext()) {
                Row row = groupDS.next();
                AssistTreeCategoryVO vo = new AssistTreeCategoryVO();
                vo.setId(row.getLong("treeid"));
                vo.setParent(row.getLong("treeparent"));
                vo.setName(row.getString("treename"));
                vo.setNumber(row.getString("treenumber"));
                vo.setLongNumber(row.getString("longnumber"));
                vo.setLevel(row.getInteger("treelevel"));
                vo.setIsLeaf(false);
                assistGroupVOs.add(vo);
            }
            Map<Long, AssistTreeCategoryVO> categoryIndex = assistGroupVOs.stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
            Optional<BiTreeNode<Long, AssistTreeCategoryVO>> assistTree = Optional.empty();
            if (!assistGroupVOs.isEmpty()) {
                assistTree = Optional.of(this.buildAssistTree(assistGroupVOs));
                HashMap assistCategoryTreeIndex = new HashMap(8);
                assistTree.get().preTravel(x -> {
                    x.setData((Serializable)categoryIndex.get(x.getId()));
                    assistCategoryTreeIndex.put(x.getId(), x);
                });
                if (DebugTrace.enable()) {
                    LOG.info("assit_category_details\uff1a" + String.join((CharSequence)"\n", assistCategoryTreeIndex.entrySet().stream().map(x -> String.format("assistId: %s -> category: %s", x.getKey(), x.getValue())).collect(Collectors.toList())));
                }
                String detailPropName = treeStyle.getEntityId().split("_")[1];
                QFilter standardIdQfilter = new QFilter("standard", "=", (Object)standardId);
                Lists.partition(new ArrayList(usedAssistIds), (int)999).forEach(detailIds -> {
                    QFilter detailIdsQfilter = new QFilter(detailPropName, "in", detailIds);
                    DataSet detailGroupDs = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "groupdetail"), (String)AssistBalanceProcessor.buildGroupDetailEntity(treeStyle.getEntityId()), (String)("group, " + detailPropName + " detail"), (QFilter[])new QFilter[]{standardIdQfilter, detailIdsQfilter}, null);
                    if (DebugTrace.enable()) {
                        LOG.info("processing category with standard ID: {} on detail ids: {}", (Object)standardId, detailIds);
                        DataSetHelper.logDataSet((String)"detail_with_category_dataset", (DataSet)detailGroupDs);
                    }
                    while (detailGroupDs.hasNext()) {
                        Row detailGroupRow = detailGroupDs.next();
                        long detailId = detailGroupRow.getLong("detail");
                        long groupId = detailGroupRow.getLong("group");
                        BiTreeNode parentNode = (BiTreeNode)assistCategoryTreeIndex.get(groupId);
                        if (null == parentNode) {
                            LOG.warn("assit_category_details\uff1a" + String.join((CharSequence)"\n", assistCategoryTreeIndex.entrySet().stream().map(x -> String.format("assistId: %s -> category: %s", x.getKey(), x.getValue())).collect(Collectors.toList())));
                            LOG.warn("failed to get assist category info by assist:" + groupId);
                            continue;
                        }
                        AssistTreeCategoryVO categoryVO = new AssistTreeCategoryVO();
                        categoryVO.setId(detailId);
                        categoryVO.setParent(groupId);
                        Tuple numberAndName = (Tuple)usedAssistInfoMap.get(detailId);
                        categoryVO.setName((String)numberAndName.item2);
                        categoryVO.setNumber((String)numberAndName.item1);
                        AssistTreeCategoryVO parentCategoryVO = (AssistTreeCategoryVO)parentNode.getData();
                        categoryVO.setLongNumber(parentCategoryVO.getLongNumber() + "." + categoryVO.getNumber());
                        categoryVO.setLevel(parentCategoryVO.getLevel() + 1);
                        categoryVO.setIsLeaf(true);
                        BiTreeNode newNode = new BiTreeNode((Object)detailId, (Serializable)categoryVO);
                        newNode.quickSetParent(parentNode);
                    }
                });
                long tick = System.currentTimeMillis();
                assistTree.get().postTravel(x -> {
                    BiTreeNode node = x;
                    node.batchRemoveChild(c -> !FAKE_GROUP_ROOT.equals(c.getId()) && !((AssistTreeCategoryVO)c.getData()).getIsLeaf() && CollectionUtils.isEmpty((Collection)c.getChild()));
                });
                if (DebugTrace.enable()) {
                    LOG.info("remove assist tree node in last cycle cost: {}", (Object)(System.currentTimeMillis() - tick));
                    LOG.info("assist_tree_as: \n" + assistTree.get().showFormatTree("\n"));
                }
            }
            return assistTree;
        }
        HashMap<Long, AssistTreeCategoryVO> allCategories = new HashMap<Long, AssistTreeCategoryVO>(8);
        Set parentAssistIds = usedAssistIds;
        int cycle = 0;
        while (!parentAssistIds.isEmpty()) {
            Tuple<List<AssistTreeCategoryVO>, Set<Long>> oneCategoryResult = this.queryParentCategoryInfo(entityId, parentAssistIds);
            for (AssistTreeCategoryVO vo : (List)oneCategoryResult.item1) {
                if (allCategories.containsKey(vo.getId())) continue;
                allCategories.put(vo.getId(), vo);
            }
            parentAssistIds = (Set)oneCategoryResult.item2;
            if (cycle++ <= 2000) continue;
            LOG.error("loop cycle exceed max times, abort");
            break;
        }
        Optional<BiTreeNode<Long, AssistTreeCategoryVO>> assistTree = Optional.empty();
        if (!allCategories.isEmpty()) {
            assistTree = Optional.of(this.buildAssistTree(allCategories.values()));
            assistTree.get().preTravel(x -> x.setData((Serializable)allCategories.get(x.getId())));
        }
        return assistTree;
    }

    private Tuple<List<AssistTreeCategoryVO>, Set<Long>> queryParentCategoryInfo(String entityId, Set<Long> assistIds) {
        String selectFields = "id treeid,parent treeparent,name treename,number treenumber,longnumber,level treelevel,isleaf";
        DataSet groupDS = QueryServiceHelper.queryDataSet((String)"queryParentCategoryInfo", (String)entityId, (String)selectFields, (QFilter[])new QFilter("id", "in", assistIds).toArray(), null);
        ArrayList<AssistTreeCategoryVO> assistGroupVOs = new ArrayList<AssistTreeCategoryVO>(8);
        HashSet<Long> parentIds = new HashSet<Long>(8);
        while (groupDS.hasNext()) {
            Row row = groupDS.next();
            AssistTreeCategoryVO vo = new AssistTreeCategoryVO();
            vo.setId(row.getLong("treeid"));
            long parentId = row.getLong("treeparent");
            vo.setParent(parentId);
            if (parentId > 0L) {
                parentIds.add(parentId);
            }
            vo.setName(row.getString("treename"));
            vo.setNumber(row.getString("treenumber"));
            vo.setLongNumber(row.getString("longnumber"));
            vo.setLevel(row.getInteger("treelevel"));
            vo.setIsLeaf(row.getBoolean("isleaf"));
            assistGroupVOs.add(vo);
        }
        return Tuple.create(assistGroupVOs, parentIds);
    }

    private BiTreeNode<Long, AssistTreeCategoryVO> buildAssistTree(Collection<AssistTreeCategoryVO> assistGroupVOs) {
        List treeRelations = assistGroupVOs.stream().map(x -> TreeNodeRelationFactory.get().getTreeNodeRelation(x.getId(), x.getParent())).collect(Collectors.toList());
        if (treeRelations.stream().anyMatch(x -> 0L == (Long)x.getParent())) {
            treeRelations.add(TreeNodeRelationFactory.get().getTreeNodeRelation(Long.valueOf(0L), null));
        }
        Object assistTree = null;
        try {
            return BiTreeNode.quickBuildTree(treeRelations, AssistTreeCategoryVO.class);
        }
        catch (Exception e) {
            LOG.error("failed to build assist tree category info:" + e.getMessage(), (Throwable)e);
            LOG.error("treeRelations as below:" + treeRelations);
            throw new KDBizException("there is possible that there is dirty data on assist category, please check monitor log.");
        }
    }

    private AccountDistinctKey getAccountDistinctKeyFromCache(long orgId, long accId) {
        AccountDistinctKey accDistinctKey = (AccountDistinctKey)this.accountTopAccCache.get((Object)accId, (Object)orgId);
        if (null == accDistinctKey) {
            AccountIndex accountIndex = AssistBalanceContext.get().getAccountIndex();
            long topAccId = accountIndex.getTopAccountId(orgId, accId);
            accDistinctKey = accountIndex.getAccountVO(topAccId).convertTo();
            this.accountTopAccCache.put((Object)accId, (Object)orgId, (Object)accDistinctKey);
        }
        return accDistinctKey;
    }

    private AssistSubtotalKey buildAssistSubtotalKey(RawBalanceRow rawBalanceRow, AccountDistinctKey accDistinctKey) {
        if (AssistBalanceContext.get().getIsEnableCurrencyGroup().booleanValue()) {
            return AssistSubtotalKey.retrievalFromCacheOrBuild(rawBalanceRow.assistValues, accDistinctKey, rawBalanceRow.currencyId);
        }
        return AssistSubtotalKey.retrievalFromCacheOrBuild(rawBalanceRow.assistValues, accDistinctKey, null);
    }

    private AssistSubtotalKey buildAssistSubtotalKey(RawPLVoucherRow rawPLVoucherRow, AccountDistinctKey accDistinctKey) {
        if (AssistBalanceContext.get().getIsEnableCurrencyGroup().booleanValue()) {
            return AssistSubtotalKey.retrievalFromCacheOrBuild(rawPLVoucherRow.assistValues, accDistinctKey, rawPLVoucherRow.currencyId);
        }
        return AssistSubtotalKey.retrievalFromCacheOrBuild(rawPLVoucherRow.assistValues, accDistinctKey, null);
    }

    public int getCurrentShowPageComposeCount() {
        return this.limitedSubtotalKeys.size();
    }

    public void setExportAll(boolean exportAll) {
        this.exportAll = exportAll;
    }

    public void setFinalDataSetBatch(boolean finalDataSetBatch) {
        this.finalDataSetBatch = finalDataSetBatch;
    }
}

