/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.assistbalance.export;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.export.ExportProgress;
import kd.bos.mvc.report.ReportView;
import kd.bos.report.ReportList;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.model.Context;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.report.accbalance.export.AccBalReportExporter;
import kd.fi.gl.report.assistbalance.export.AssistBalExportProgressImpl;
import kd.fi.gl.report.assistbalance.export.AssistBalReportExporter;
import kd.fi.gl.report.export.ExportOption;

public class AssistBalReportExportAllTask
extends AbstractTask {
    protected static final String REPORT_LIST_AP = "reportlistap";
    private ExportProgress exportProgress;
    private static final Log logger = LogFactory.getLog(AssistBalReportExportAllTask.class);

    public ExportProgress getExportProgress() {
        if (this.exportProgress == null) {
            this.exportProgress = new AssistBalExportProgressImpl(this.taskId);
        }
        return this.exportProgress;
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String queyrparam = (String)map.get("queryparam");
        String pageId = (String)map.get("parentpageid");
        String entityNumber = (String)map.get("entitynumber");
        ReportQueryParam queryParam = (ReportQueryParam)SerializationUtils.deSerializeFromBase64((String)queyrparam);
        ReportView view = (ReportView)SessionManager.getCurrent().getView(pageId);
        ReportList list = (ReportList)view.getControl(REPORT_LIST_AP);
        view.setExportProgress(this.getExportProgress());
        try {
            Context context;
            ExportOption exportOption = new ExportOption();
            exportOption.setExportProgress(this.exportProgress);
            if (Objects.equals(entityNumber, "gl_rpt_assistbalance")) {
                context = AssistBalReportExporter.exportAssistBal(queryParam, list, exportOption);
            } else {
                Boolean exportAssist = (Boolean)map.get("exportAssist");
                AccBalReportExporter accountBalReportExporter = new AccBalReportExporter(queryParam, list, exportOption, exportAssist);
                context = accountBalReportExporter.exportAccountBal();
            }
            List urls = (List)context.query("downloadUrl");
            if (CollectionUtils.isNotEmpty((Collection)urls)) {
                int total = context.query("totalCount") == null ? 0 : (Integer)context.query("totalCount");
                this.exportProgress.feedbackProgress(total, total);
                HashMap<String, List> data = new HashMap<String, List>();
                data.put("downloadurl", urls);
                this.exportProgress.feedbackCustData(data);
            } else {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("complete", 0);
                data.put("total", 0);
                data.put("failReason", ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u5bfc\u51fa\u3002", (String)"ReportExportAllTask_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                this.exportProgress.feedbackCustData(data);
            }
        }
        catch (Exception e) {
            logger.error("assistbalreport exportall task failed:" + e.getMessage(), (Throwable)e);
            throw new KDBizException((Throwable)e, GLErrorCode.SYS_ERR, new Object[0]);
        }
        finally {
            this.getExportProgress().complete();
        }
    }
}

