/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.assistbalance.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.report.assistbalance.model.BalanceRow;
import kd.fi.gl.report.assistbalance.model.TreeGroupKey;

public class AccTreeData
implements Serializable {
    private static final Log LOG = LogFactory.getLog(AccTreeData.class);
    private Map<TreeGroupKey, Map<Long, BalanceRow>> _data = new HashMap<TreeGroupKey, Map<Long, BalanceRow>>(8);

    public void feed(TreeGroupKey key, Long nodeId, BalanceRow balanceRow) {
        if (null == key || null == nodeId || null == balanceRow) {
            LOG.error("parameter key or nodeId or balanceRow is null, key= {}, ndoeId: {}, balanceRow: {}", new Object[]{key, nodeId, balanceRow});
            throw new KDBizException(GLErrorCode.BIZ_ERR, new Object[0]);
        }
        Map treeGroupData = this._data.computeIfAbsent(key, x -> new HashMap(2));
        if (!treeGroupData.containsKey(nodeId)) {
            treeGroupData.put(nodeId, balanceRow);
        } else {
            ((BalanceRow)treeGroupData.get(nodeId)).merge(balanceRow, false);
        }
    }

    public Collection<TreeGroupKey> listKeys() {
        return new HashSet<TreeGroupKey>(this._data.keySet());
    }

    public BalanceRow get(TreeGroupKey key, Long nodeId) {
        if (null == key || null == nodeId) {
            LOG.error("parameter key or nodeId is null");
            throw new KDBizException(GLErrorCode.BIZ_ERR, new Object[0]);
        }
        Map<Long, BalanceRow> treeGroupData = this._data.get(key);
        if (null == treeGroupData) {
            return null;
        }
        return treeGroupData.get(nodeId);
    }

    public boolean contains(TreeGroupKey key) {
        return this._data.containsKey(key);
    }

    public boolean isNotNull(TreeGroupKey key, Long nodeId) {
        if (null == key || null == nodeId) {
            LOG.error("parameter key or nodeId is null");
            throw new KDBizException(GLErrorCode.BIZ_ERR, new Object[0]);
        }
        Map<Long, BalanceRow> treeGroupData = this._data.get(key);
        if (null == treeGroupData) {
            return false;
        }
        BalanceRow balance = treeGroupData.get(nodeId);
        return null != balance;
    }

    public List<BalanceRow> batchGet(TreeGroupKey key, List<Long> nodeIds) {
        if (null == nodeIds || nodeIds.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Map<Long, BalanceRow> treeGroupData = this._data.get(key);
        if (null == treeGroupData) {
            return Collections.EMPTY_LIST;
        }
        return nodeIds.stream().map(x -> (BalanceRow)treeGroupData.get(x)).filter(x -> null != x).collect(Collectors.toList());
    }

    public Map<Long, BalanceRow> listAvailableNodes(TreeGroupKey groupKey) {
        if (!this._data.containsKey(groupKey)) {
            return Collections.EMPTY_MAP;
        }
        return new HashMap<Long, BalanceRow>(this._data.get(groupKey));
    }

    public Collection<BalanceRow> collect(TreeGroupKey key) {
        if (!this._data.containsKey(key)) {
            return Collections.EMPTY_LIST;
        }
        return this._data.get(key).values();
    }

    public void clearKeyData(TreeGroupKey key) {
        this._data.remove(key);
    }

    public void clearAllKeyData() {
        this._data.clear();
    }
}

