/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.assistbalance.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.Tuple;
import kd.fi.gl.report.assistbalance.AssistBalanceContext;
import kd.fi.gl.report.assistbalance.model.TreeGroupKey;
import kd.fi.gl.util.MultiIndexTreeCache;

public class AssistBalanceKey
implements Serializable,
Cloneable {
    private static final String _CACHE_KEY = "fi.gl.assistbalance.assistbalancekey.cache";
    public static int INIT_COUNT = 0;
    protected final Long orgId;
    protected final long accountId;
    protected final Long measureUnitId;
    protected String measureUnitName;
    protected final Long currencyId;
    protected final List<Long> comAssistVals;
    protected final List<Object> assistValues;
    private TreeGroupKey treeGroupKey;
    public static volatile Function<List<Tuple<String, Object>>, String> concatKeyFacts = _list -> {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < _list.size(); ++i) {
            Tuple y = (Tuple)_list.get(i);
            if (i > 0) {
                sb.append("_");
            }
            sb.append((String)y.item1).append(":").append(y.item2);
        }
        return sb.toString();
    };

    public AssistBalanceKey(long orgId, long accountId, Long measureUnitId, Long currencyId, List<Object> assistValues, List<Long> comAssistVals) {
        ++INIT_COUNT;
        this.orgId = orgId;
        this.accountId = accountId;
        this.assistValues = assistValues;
        this.measureUnitId = measureUnitId;
        this.currencyId = currencyId;
        this.comAssistVals = comAssistVals;
    }

    public static AssistBalanceKey retrievalFromCacheOrBuild(long orgId, long accountId, Long measureUnitId, Long currencyId, List<Long> comAssistVals, List<Object> assistValues) {
        AssistBalanceKey value;
        MultiIndexTreeCache _keyCache = (MultiIndexTreeCache)ThreadCache.get((Object)_CACHE_KEY, () -> new MultiIndexTreeCache("AssistBalanceKey", 200000));
        ArrayList<Object> _factors = new ArrayList<Object>(6);
        _factors.addAll(assistValues);
        _factors.addAll(comAssistVals);
        _factors.add(accountId);
        _factors.add(orgId);
        if (null != currencyId) {
            _factors.add(currencyId);
        }
        if (null != measureUnitId) {
            _factors.add(measureUnitId);
        }
        if (null != (value = (AssistBalanceKey)_keyCache.retrieval(_factors.toArray()))) {
            return value;
        }
        AssistBalanceKey balanceKey = new AssistBalanceKey(orgId, accountId, measureUnitId, currencyId, assistValues, comAssistVals);
        balanceKey.treeGroupKey = TreeGroupKey.retrievalFromCacheOrBuild(assistValues, comAssistVals, currencyId, measureUnitId);
        ((MultiIndexTreeCache)ThreadCache.get((Object)_CACHE_KEY)).addData((Object)balanceKey, _factors.toArray());
        return balanceKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssistBalanceKey that = (AssistBalanceKey)o;
        return this.assistValues.equals(that.assistValues) && this.accountId == that.accountId && this.orgId.equals(that.orgId) && Objects.equals(this.measureUnitId, that.measureUnitId) && Objects.equals(this.comAssistVals, that.comAssistVals) && Objects.equals(this.currencyId, that.currencyId);
    }

    public int hashCode() {
        return Objects.hash(this.orgId, this.accountId, this.measureUnitId, this.currencyId, this.comAssistVals, this.assistValues);
    }

    public String toString() {
        return "AssistBalanceKey{orgId=" + this.orgId + ", accountId=" + this.accountId + ", measureUnitId=" + this.measureUnitId + ", currencyId=" + this.currencyId + ", comAssistVals=" + this.comAssistVals + ", assistValues=" + this.assistValues + '}';
    }

    protected String buildObjectKey() {
        ArrayList<Tuple> keyFactors = new ArrayList<Tuple>(6);
        keyFactors.add(Tuple.create((Object)"accnum", (Object)AssistBalanceContext.get().getAccountIndex().getAccountVO(this.accountId)));
        if (null != this.measureUnitId) {
            keyFactors.add(Tuple.create((Object)"measureunit", (Object)this.measureUnitId));
        }
        if (null != this.currencyId) {
            keyFactors.add(Tuple.create((Object)"currency", (Object)this.currencyId));
        }
        keyFactors.add(Tuple.create((Object)"assist", this.assistValues));
        return concatKeyFacts.apply(keyFactors);
    }

    public TreeGroupKey getTreeGroupKey() {
        return this.treeGroupKey;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public String getMeasureUnitName() {
        return this.measureUnitName;
    }

    public void setMeasureUnitName(String measureUnitName) {
        this.measureUnitName = measureUnitName;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public Long getMeasureUnitId() {
        return this.measureUnitId;
    }

    public Long getCurrencyId() {
        return this.currencyId;
    }

    public List<Long> getComAssistVals() {
        return this.comAssistVals;
    }

    public List<Object> getAssistValues() {
        return this.assistValues;
    }

    public static void clearAll() {
        ((MultiIndexTreeCache)ThreadCache.get((Object)_CACHE_KEY)).clearAll();
    }
}

