/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.assistbalance.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.report.ReportHelper;
import kd.fi.gl.util.DataSetHelper;

public class RawBalanceRow {
    private static final Log LOG = LogFactory.getLog(DataSetHelper.class);
    private static final Long YEAR_PERIOD_L = 10000L;
    public long orgId;
    public long accMid;
    public Long currencyId;
    public Long measureUnitId;
    public long period;
    public List<Long> comAssistVals = new ArrayList<Long>(64);
    public Long endPeriod;
    public final List<Object> assistValues;
    public BigDecimal debitfor;
    public BigDecimal creditfor;
    public BigDecimal beginfor = BigDecimal.ZERO;
    public BigDecimal endfor = BigDecimal.ZERO;
    public BigDecimal yeardebitfor = BigDecimal.ZERO;
    public BigDecimal yearcreditfor = BigDecimal.ZERO;
    public BigDecimal debitlocal;
    public BigDecimal creditlocal;
    public BigDecimal beginlocal = BigDecimal.ZERO;
    public BigDecimal endlocal;
    public BigDecimal yeardebitlocal = BigDecimal.ZERO;
    public BigDecimal yearcreditlocal = BigDecimal.ZERO;
    public BigDecimal debitqty;
    public BigDecimal creditqty;
    public BigDecimal beginqty = BigDecimal.ZERO;
    public BigDecimal endqty = BigDecimal.ZERO;
    public BigDecimal yeardebitqty = BigDecimal.ZERO;
    public BigDecimal yearcreditqty = BigDecimal.ZERO;
    public int ventryCount = 0;

    public RawBalanceRow(Row dsRow, List<String> fieldIndexes, List<Tuple<String, Integer>> assistFields, List<Tuple<String, Integer>> comAssistFields) {
        int fieldSize = fieldIndexes.size();
        block54: for (int i = 0; i < fieldSize; ++i) {
            String fieldName = fieldIndexes.get(i);
            Object fieldValue = dsRow.get(i);
            switch (fieldName) {
                case "orgid": {
                    this.orgId = (Long)fieldValue;
                    continue block54;
                }
                case "account": {
                    this.accMid = (Long)fieldValue;
                    continue block54;
                }
                case "currencyid": {
                    this.currencyId = (Long)fieldValue;
                    continue block54;
                }
                case "measureunit": {
                    this.measureUnitId = (Long)fieldValue;
                    continue block54;
                }
                case "period": {
                    this.period = (Long)fieldValue;
                    continue block54;
                }
                case "endperiod": {
                    this.endPeriod = (Long)fieldValue;
                    continue block54;
                }
                case "debitfor": {
                    this.debitfor = (BigDecimal)fieldValue;
                    continue block54;
                }
                case "creditfor": {
                    this.creditfor = (BigDecimal)fieldValue;
                    continue block54;
                }
                case "beginfor": {
                    this.beginfor = (BigDecimal)fieldValue;
                    continue block54;
                }
                case "endfor": {
                    this.endfor = (BigDecimal)fieldValue;
                    continue block54;
                }
                case "yeardebitfor": {
                    this.yeardebitfor = (BigDecimal)fieldValue;
                    continue block54;
                }
                case "yearcreditfor": {
                    this.yearcreditfor = (BigDecimal)fieldValue;
                    continue block54;
                }
                case "debitlocal": {
                    this.debitlocal = ReportHelper.adapterNonBigDecimal(fieldValue);
                    continue block54;
                }
                case "creditlocal": {
                    this.creditlocal = ReportHelper.adapterNonBigDecimal(fieldValue);
                    continue block54;
                }
                case "beginlocal": {
                    this.beginlocal = ReportHelper.adapterNonBigDecimal(fieldValue);
                    continue block54;
                }
                case "endlocal": {
                    this.endlocal = ReportHelper.adapterNonBigDecimal(fieldValue);
                    continue block54;
                }
                case "yeardebitlocal": {
                    this.yeardebitlocal = ReportHelper.adapterNonBigDecimal(fieldValue);
                    continue block54;
                }
                case "yearcreditlocal": {
                    this.yearcreditlocal = ReportHelper.adapterNonBigDecimal(fieldValue);
                    continue block54;
                }
                case "debitqty": {
                    this.debitqty = (BigDecimal)fieldValue;
                    continue block54;
                }
                case "creditqty": {
                    this.creditqty = (BigDecimal)fieldValue;
                    continue block54;
                }
                case "beginqty": {
                    this.beginqty = (BigDecimal)fieldValue;
                    continue block54;
                }
                case "endqty": {
                    this.endqty = (BigDecimal)fieldValue;
                    continue block54;
                }
                case "yeardebitqty": {
                    this.yeardebitqty = (BigDecimal)fieldValue;
                    continue block54;
                }
                case "yearcreditqty": {
                    this.yearcreditqty = (BigDecimal)fieldValue;
                    continue block54;
                }
                case "count": {
                    this.ventryCount = (Integer)fieldValue;
                    continue block54;
                }
            }
        }
        this.comAssistVals = new ArrayList<Long>(comAssistFields.size());
        for (Tuple<String, Integer> comAssistInfo : comAssistFields) {
            this.comAssistVals.add(dsRow.getLong(((Integer)comAssistInfo.item2).intValue()));
        }
        this.assistValues = new ArrayList<Object>(assistFields.size());
        for (Tuple<String, Integer> assistInfo : assistFields) {
            this.assistValues.add(dsRow.get(((Integer)assistInfo.item2).intValue()));
        }
    }

    public void preprocess(long startPeriodId, long endPeriodId, boolean isShowOrigin, boolean isShowQty) {
        if (this.period != startPeriodId) {
            if (this.period < startPeriodId && this.endPeriod > startPeriodId) {
                if (isShowOrigin) {
                    this.beginfor = this.endfor;
                }
                this.beginlocal = this.endlocal;
                if (isShowQty) {
                    this.beginqty = this.endqty;
                }
            } else {
                if (isShowOrigin) {
                    this.beginfor = BigDecimal.ZERO;
                }
                this.beginlocal = BigDecimal.ZERO;
                if (isShowQty) {
                    this.beginqty = BigDecimal.ZERO;
                }
            }
        }
        if (this.period < startPeriodId) {
            if (isShowOrigin) {
                this.debitfor = BigDecimal.ZERO;
                this.creditfor = BigDecimal.ZERO;
            }
            this.debitlocal = BigDecimal.ZERO;
            this.creditlocal = BigDecimal.ZERO;
            if (isShowQty) {
                this.debitqty = BigDecimal.ZERO;
                this.creditqty = BigDecimal.ZERO;
            }
        }
        if (this.endPeriod != 0L && (this.endPeriod <= endPeriodId || this.period > endPeriodId || this.period <= endPeriodId / YEAR_PERIOD_L * YEAR_PERIOD_L)) {
            if (isShowOrigin) {
                this.yeardebitfor = BigDecimal.ZERO;
                this.yearcreditfor = BigDecimal.ZERO;
            }
            this.yeardebitlocal = BigDecimal.ZERO;
            this.yearcreditlocal = BigDecimal.ZERO;
            if (isShowQty) {
                this.yeardebitqty = BigDecimal.ZERO;
                this.yearcreditqty = BigDecimal.ZERO;
            }
        }
        if (this.period > endPeriodId || this.endPeriod <= endPeriodId) {
            if (isShowOrigin) {
                this.endfor = BigDecimal.ZERO;
            }
            this.endlocal = BigDecimal.ZERO;
            if (isShowQty) {
                this.endqty = BigDecimal.ZERO;
            }
        }
        if (this.ventryCount > 0 && (this.period < startPeriodId || this.period > endPeriodId)) {
            this.ventryCount = 0;
        }
    }

    public void merge(RawBalanceRow other) {
        if (null == other) {
            throw new KDBizException(GLErrorCode.BIZ_ERR, new Object[0]);
        }
        if (null != this.debitfor) {
            this.debitfor = this.debitfor.add(other.debitfor);
            this.creditfor = this.creditfor.add(other.creditfor);
            this.beginfor = this.beginfor.add(other.beginfor);
            this.endfor = this.endfor.add(other.endfor);
            this.yeardebitfor = this.yeardebitfor.add(other.yeardebitfor);
            this.yearcreditfor = this.yearcreditfor.add(other.yearcreditfor);
        }
        this.debitlocal = this.debitlocal.add(other.debitlocal);
        this.creditlocal = this.creditlocal.add(other.creditlocal);
        this.beginlocal = this.beginlocal.add(other.beginlocal);
        this.endlocal = this.endlocal.add(other.endlocal);
        this.yeardebitlocal = this.yeardebitlocal.add(other.yeardebitlocal);
        this.yearcreditlocal = this.yearcreditlocal.add(other.yearcreditlocal);
        if (null != this.debitqty) {
            this.debitqty = this.debitqty.add(other.debitqty);
            this.creditqty = this.creditqty.add(other.creditqty);
            this.beginqty = this.beginqty.add(other.beginqty);
            this.endqty = this.endqty.add(other.endqty);
            this.yeardebitqty = this.yeardebitqty.add(other.yeardebitqty);
            this.yearcreditqty = this.yearcreditqty.add(other.yearcreditqty);
        }
        this.ventryCount += other.ventryCount;
    }

    protected Object getValue(Row dsRow, Map<String, Integer> columnIndexes, String columnName, boolean isMustExist, Object defaultValue) {
        Integer colIndex = columnIndexes.get(columnName);
        if (null != colIndex) {
            return dsRow.get(colIndex.intValue());
        }
        if (isMustExist) {
            LOG.error("'" + columnName + "' not exists on row:" + dsRow.toString());
            throw new KDBizException(GLErrorCode.BIZ_ERR, new Object[0]);
        }
        return defaultValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawBalanceRow that = (RawBalanceRow)o;
        return this.assistValues.equals(that.assistValues) && this.orgId == that.orgId && this.accMid == that.accMid && this.period == that.period && this.currencyId.equals(that.currencyId) && this.comAssistVals.equals(that.comAssistVals) && this.measureUnitId.equals(that.measureUnitId) && Objects.equals(this.endPeriod, that.endPeriod);
    }

    public int hashCode() {
        return Objects.hash(this.orgId, this.accMid, this.currencyId, this.comAssistVals, this.measureUnitId, this.period, this.endPeriod, this.assistValues);
    }

    public String toString() {
        return "RawBalanceRow{orgId=" + this.orgId + ", accMid=" + this.accMid + ", currencyId=" + this.currencyId + ", comAssistVals=" + this.comAssistVals + ", measureUnitId=" + this.measureUnitId + ", period=" + this.period + ", endPeriod=" + this.endPeriod + ", assistValues=" + this.assistValues + ", debitfor=" + this.debitfor + ", creditfor=" + this.creditfor + ", beginfor=" + this.beginfor + ", endfor=" + this.endfor + ", yeardebitfor=" + this.yeardebitfor + ", yearcreditfor=" + this.yearcreditfor + ", debitlocal=" + this.debitlocal + ", creditlocal=" + this.creditlocal + ", beginlocal=" + this.beginlocal + ", endlocal=" + this.endlocal + ", yeardebitlocal=" + this.yeardebitlocal + ", yearcreditlocal=" + this.yearcreditlocal + ", debitqty=" + this.debitqty + ", creditqty=" + this.creditqty + ", beginqty=" + this.beginqty + ", endqty=" + this.endqty + ", yeardebitqty=" + this.yeardebitqty + ", yearcreditqty=" + this.yearcreditqty + ", ventryCount=" + this.ventryCount + '}';
    }
}

