/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.auxi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.service.balance.account.IAccountTreeModel;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.enums.AssistBalBatchQueryType;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.ReportBalanceUtil;
import kd.fi.gl.report.ReportDsExtProcessHelper;
import kd.fi.gl.report.ReportHelper;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.report.auxi.AuxSubLedgerHelper;
import kd.fi.gl.report.export.convert.AuxPeriodBeginConverter;
import kd.fi.gl.report.export.convert.AuxVoucherConverter;
import kd.fi.gl.report.export.convert.BalanceGroupConverter;
import kd.fi.gl.report.export.convert.IDatasetRowTypeConverter;
import kd.fi.gl.report.export.convert.VoucherGroupConverter;
import kd.fi.gl.report.subsidiary.BalanceGroupRow;
import kd.fi.gl.report.subsidiary.SubsidiaryColIndex;
import kd.fi.gl.report.subsidiary.SubsidiaryPeriod;
import kd.fi.gl.report.subsidiary.SubsidiaryReportDatasetBuilder;
import kd.fi.gl.report.subsidiary.SubsidiaryRow;
import kd.fi.gl.util.DataSetHelper;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.ReportFieldSettingUtil;
import kd.fi.gl.util.SubsiDiaryHelper;

public class AuxSubLedgerQueryRpt
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(AuxSubLedgerQueryRpt.class);

    private int getVoucherLimit() {
        return BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.report.newauxsubledger.voucherlimit", (int)100000);
    }

    private int getBatchLimit() {
        return BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.report.newauxsubledger.batchlimit", (int)10000);
    }

    private int getPerBatchLimit() {
        return BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.report.newauxsubledger.perbatchlimit", (int)1);
    }

    private int getCurPerBatchLimit() {
        return BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.report.newauxsubledger.curperbatchlimit", (int)10);
    }

    private int getBatchOrgCount() {
        return BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.report.newauxsubledger.batch.orgcount", (int)50);
    }

    public DataSet queryBatchBy(ReportQueryParam reportQueryParam) {
        DataSet balanceGroupDataSet;
        long tick = System.currentTimeMillis();
        this.init(reportQueryParam);
        int voucherLimit = this.getVoucherLimit();
        int batchLimit = this.getBatchLimit();
        reportQueryParam.getCustomParam().put("limit", voucherLimit);
        MulOrgQPRpt qpRpt = (MulOrgQPRpt)reportQueryParam.getCustomParam().get("queryParamRpt");
        QFilter commonFilter = reportQueryParam.getFilter().getCommFilter("gl_voucher");
        boolean queryByVoucher = qpRpt.isNoZeroAmount() || commonFilter != null;
        int perBatch = this.getPerBatchLimit();
        if (qpRpt.getStartPeriod() == qpRpt.getEndPeriod() && !queryByVoucher) {
            perBatch = this.getCurPerBatchLimit();
        }
        reportQueryParam.byBatchInfo().setCountPerBatch(perBatch);
        ArrayList<BalanceGroupRow> bgRows = new ArrayList<BalanceGroupRow>(1024);
        int sumCount = 0;
        logger.info("queryByVoucher: {}", (Object)queryByVoucher);
        if (qpRpt.getAllEntityOrgs().size() > this.getBatchOrgCount()) {
            List sortedOrgList = qpRpt.getAllEntityOrgs().stream().sorted().collect(Collectors.toList());
            sortedOrgList.stream().forEach(orgId -> {
                BalanceGroupRow bgRow = new BalanceGroupRow();
                bgRow.setOrgId(orgId);
                bgRows.add(bgRow);
            });
        } else if (queryByVoucher) {
            balanceGroupDataSet = SubsidiaryReportDatasetBuilder.queryVoucherGroupDataSet((ReportQueryParam)reportQueryParam, (int)(this.getVoucherLimit() + 1));
            try (DataSet copyDataSet = balanceGroupDataSet.copy();){
                sumCount = copyDataSet.count("org", false);
            }
            balanceGroupDataSet = balanceGroupDataSet.distinct();
            balanceGroupDataSet = AuxSubLedgerQueryRpt.orderByAssistId(reportQueryParam, balanceGroupDataSet, queryByVoucher);
            VoucherGroupConverter converter = new VoucherGroupConverter();
            while (balanceGroupDataSet.hasNext()) {
                if (bgRows.size() >= batchLimit) {
                    sumCount = voucherLimit + 1;
                    break;
                }
                Row row = balanceGroupDataSet.next();
                BalanceGroupRow bgRow = (BalanceGroupRow)converter.convertTo(reportQueryParam, row);
                bgRows.add(bgRow);
            }
            balanceGroupDataSet.close();
        } else {
            balanceGroupDataSet = SubsidiaryReportDatasetBuilder.queryBalanceGroupDataSet((ReportQueryParam)reportQueryParam, (int)-1);
            List<String> groupFields = Arrays.stream(balanceGroupDataSet.getRowMeta().getFields()).map(Field::getName).filter(x -> !Objects.equals(x, "count")).collect(Collectors.toList());
            balanceGroupDataSet = balanceGroupDataSet.groupBy(groupFields.toArray(new String[0])).sum("count").finish();
            balanceGroupDataSet = AuxSubLedgerQueryRpt.orderByAssistId(reportQueryParam, balanceGroupDataSet, false);
            HashSet<String> groupKeySet = new HashSet<String>(1024);
            BalanceGroupConverter converter = new BalanceGroupConverter();
            while (balanceGroupDataSet.hasNext()) {
                Row row = balanceGroupDataSet.next();
                int count = row.getInteger("count");
                BalanceGroupRow bgRow = (BalanceGroupRow)converter.convertTo(reportQueryParam, row);
                if (qpRpt.getStartPeriod() <= bgRow.getPeriodId() && bgRow.getPeriodId() <= qpRpt.getEndPeriod()) {
                    sumCount += count;
                }
                if (groupKeySet.size() >= batchLimit) {
                    sumCount = voucherLimit + 1;
                    logger.info("groupKeySet.size() >= {}: break", (Object)batchLimit);
                    break;
                }
                if (!groupKeySet.contains(bgRow.getGroupKey())) {
                    bgRows.add(bgRow);
                }
                groupKeySet.add(bgRow.getGroupKey());
                if (sumCount <= voucherLimit) continue;
                logger.info("sumCount > {}, break.", (Object)voucherLimit);
                break;
            }
            logger.info("balanceGroupDataSet compute result, sumCount: {}, groupKeySet.size: {}", (Object)sumCount, (Object)groupKeySet.size());
            balanceGroupDataSet.close();
        }
        DataSet dataSet = this.createBatchByDataSet(qpRpt, reportQueryParam, bgRows, sumCount);
        logger.info("queryBatchBy_cost:{}ms", (Object)(System.currentTimeMillis() - tick));
        return dataSet;
    }

    private DataSet createBatchByDataSet(MulOrgQPRpt qpRpt, ReportQueryParam reportQueryParam, List<BalanceGroupRow> bgRows, int sumCount) {
        RowMeta rowMeta = new RowMeta(new String[]{"batchtype", "filterrow"}, new DataType[]{DataType.StringType, DataType.StringType});
        DataSetBuilder batchByDSBuilder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(rowMeta);
        logger.info("createBatchByDataSet sumCount: {}, voucherLimit: {}", (Object)sumCount, (Object)this.getVoucherLimit());
        if (sumCount > this.getVoucherLimit()) {
            bgRows = bgRows.stream().limit(this.getBatchLimit()).collect(Collectors.toList());
            int size = bgRows.size();
            for (int i = 0; i < size; ++i) {
                batchByDSBuilder.append(new Object[]{AssistBalBatchQueryType.GROUP.name(), SerializationUtils.toJsonString((Object)bgRows.get(i))});
                if (!DebugTrace.enable()) continue;
                logger.info("queryBatchByGroup:" + ((BalanceGroupRow)bgRows.get(i)).getGroupKey());
            }
        } else {
            Long preOrgId = 0L;
            int size = bgRows.size();
            for (int i = 0; i < size; ++i) {
                BalanceGroupRow bgRow = (BalanceGroupRow)bgRows.get(i);
                if (Objects.equals(preOrgId, bgRow.getOrgId())) continue;
                batchByDSBuilder.append(new Object[]{AssistBalBatchQueryType.ORG.name(), SerializationUtils.toJsonString((Object)bgRow)});
                preOrgId = bgRow.getOrgId();
                if (!DebugTrace.enable()) continue;
                logger.info("queryBatchByOrg:" + bgRow.getOrgId());
            }
        }
        int perBatch = this.getPerBatchLimit();
        if (qpRpt.getStartPeriod() == qpRpt.getEndPeriod()) {
            perBatch = this.getCurPerBatchLimit();
        }
        reportQueryParam.byBatchInfo().setCountPerBatch(perBatch);
        logger.info("perBatch:{}", (Object)perBatch);
        DataSet dataSet = batchByDSBuilder.build();
        return dataSet;
    }

    private static DataSet orderByAssistId(ReportQueryParam reportQueryParam, DataSet balanceGroupDataSet, boolean queryByVoucher) {
        ArrayList<String> orderFields = new ArrayList<String>(16);
        orderFields.add("org");
        List flexFilterItems = reportQueryParam.getFilter().getFlexFilterItems();
        for (int i = 0; i < flexFilterItems.size(); ++i) {
            String assFieldName = i == 0 ? "assval" : "assval" + i;
            orderFields.add(assFieldName);
        }
        orderFields.add("account");
        orderFields.add("currency");
        if (!queryByVoucher) {
            orderFields.add("period");
        }
        balanceGroupDataSet = balanceGroupDataSet.orderBy(orderFields.toArray(new String[0]));
        return balanceGroupDataSet;
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object selectedObj) throws Throwable {
        List batchRows = reportQueryParam.byBatchInfo().getCurrentBatchRows();
        RowMeta rowMeta = (RowMeta)reportQueryParam.getCustomParam().get("rowMeta");
        if (batchRows.isEmpty()) {
            return GLUtil.getEmptyDS(((Object)((Object)this)).getClass(), (RowMeta)rowMeta);
        }
        try {
            DataSet dataSet;
            String batchType = ((Row)batchRows.get(0)).getString(0);
            if (Objects.equals(AssistBalBatchQueryType.GROUP.name(), batchType)) {
                int limit = (Integer)reportQueryParam.getCustomParam().get("limit");
                if (limit <= 0) {
                    return GLUtil.getEmptyDS(((Object)((Object)this)).getClass(), (RowMeta)rowMeta);
                }
                dataSet = this.queryByGroupBatch(reportQueryParam, rowMeta);
            } else {
                dataSet = this.queryByOrgBatch(reportQueryParam, rowMeta);
            }
            if (DebugTrace.enable()) {
                DataSetHelper.logDataSet((String)(AuxSubLedgerQueryRpt.class.getSimpleName() + "/AuxSubLedgerQueryRpt_beforeExt"), (DataSet)dataSet);
            }
            ReportDsExtProcessHelper.doExtProcess(reportQueryParam, dataSet, "t_rpt_aux_subledger");
            if (DebugTrace.enable()) {
                DataSetHelper.logDataSet((String)(AuxSubLedgerQueryRpt.class.getSimpleName() + "/AuxSubLedgerQueryRpt_afterExt"), (DataSet)dataSet);
            }
            return dataSet;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private DataSet queryByOrgBatch(ReportQueryParam reportQueryParam, RowMeta rowMeta) {
        List batchRows = reportQueryParam.byBatchInfo().getCurrentBatchRows();
        ArrayList subDatasets = new ArrayList(2);
        batchRows.forEach(batch -> {
            BalanceGroupRow balanceGroupRow = (BalanceGroupRow)SerializationUtils.fromJsonString((String)batch.getString(1), BalanceGroupRow.class);
            DataSet dataSet = this.queryByOrg(reportQueryParam, balanceGroupRow, rowMeta);
            if (!dataSet.isEmpty()) {
                subDatasets.add(dataSet);
            }
        });
        if (subDatasets.size() == 0) {
            return GLUtil.getEmptyDS(((Object)((Object)this)).getClass(), (RowMeta)rowMeta);
        }
        if (subDatasets.size() == 1) {
            return (DataSet)subDatasets.get(0);
        }
        return ((DataSet)subDatasets.get(0)).union(subDatasets.subList(1, subDatasets.size()).toArray(new DataSet[0]));
    }

    private DataSet queryByOrg(ReportQueryParam reportQueryParam, BalanceGroupRow balanceGroupRow, RowMeta rowMeta) {
        long tick = System.currentTimeMillis();
        Map<String, Set<Object>> initFlexValueMap = this.getInitFlexValueMap(reportQueryParam);
        DataSet beginDataSet = SubsidiaryReportDatasetBuilder.queryPeriodBeginByBatch((ReportQueryParam)reportQueryParam, (BalanceGroupRow)balanceGroupRow, (AssistBalBatchQueryType)AssistBalBatchQueryType.ORG, initFlexValueMap);
        logger.info("queryByOrg_cost queryPeriodBeginByBatch:{}ms", (Object)(System.currentTimeMillis() - tick));
        tick = System.currentTimeMillis();
        List<SubsidiaryRow> beginList = ReportBalanceUtil.convertAndSumDataSetToList((ReportQueryParam)reportQueryParam, (DataSet)beginDataSet, (IDatasetRowTypeConverter)new AuxPeriodBeginConverter());
        MulOrgQPRpt qpRpt = (MulOrgQPRpt)reportQueryParam.getCustomParam().get("queryParamRpt");
        if (qpRpt.isNoZeroAmount()) {
            beginList = beginList.stream().filter(x -> x.getCount() > 0L).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)beginList)) {
            return GLUtil.getEmptyDS(((Object)((Object)this)).getClass(), (RowMeta)rowMeta);
        }
        logger.info("queryByOrg_cost convertAndSumDataSetToList:{}ms", (Object)(System.currentTimeMillis() - tick));
        tick = System.currentTimeMillis();
        List<SubsidiaryRow> voucherDataSet = this.queryVoucher(reportQueryParam, balanceGroupRow, null, AssistBalBatchQueryType.ORG, initFlexValueMap);
        logger.info("queryByOrg_cost queryVoucher:{}ms", (Object)(System.currentTimeMillis() - tick));
        tick = System.currentTimeMillis();
        List resultDataList = ReportBalanceUtil.calculateWithPeriodBegin((ReportQueryParam)reportQueryParam, beginList, voucherDataSet);
        if (CollectionUtils.isEmpty((Collection)resultDataList)) {
            return GLUtil.getEmptyDS(((Object)((Object)this)).getClass(), (RowMeta)rowMeta);
        }
        logger.info("queryByOrg_cost calculateWithPeriodBeginByOnce:{}ms", (Object)(System.currentTimeMillis() - tick));
        tick = System.currentTimeMillis();
        DataSet dataSet = this.createDataSet(reportQueryParam, resultDataList, rowMeta);
        dataSet = this.orderByAssistNumber(reportQueryParam, dataSet, beginList);
        logger.info("queryByOrg_cost orderByAssistNumber:{}ms", (Object)(System.currentTimeMillis() - tick));
        return dataSet;
    }

    private DataSet orderByAssistNumber(ReportQueryParam reportQueryParam, DataSet dataSet, List<SubsidiaryRow> beginList) {
        List assTypenameList = (List)reportQueryParam.getCustomParam().get("assTypenameList");
        MulOrgQPRpt qpRpt = (MulOrgQPRpt)reportQueryParam.getCustomParam().get("queryParamRpt");
        LinkedList assistValues = new LinkedList();
        for (int i = 0; i < assTypenameList.size(); ++i) {
            assistValues.add(new HashSet(32));
        }
        beginList.stream().forEach(x -> {
            Tuple[] flexTuples = x.getFlexTuple();
            for (int i = 0; i < flexTuples.length; ++i) {
                ((Set)assistValues.get(i)).add(flexTuples[i].item2);
            }
        });
        List dsFields = GLUtil.getDataSetCols((DataSet)dataSet);
        ArrayList<String> orderField = new ArrayList<String>(16);
        for (int i = 0; i < assTypenameList.size(); ++i) {
            String entityId = (String)((Tuple)assTypenameList.get((int)i)).item2;
            String assprefix = i == 0 ? "assval" : "assval" + i;
            String[] splitArray = entityId.split(",");
            if (StringUtils.isNotEmpty((String)splitArray[0])) {
                String valueSource = splitArray[0];
                String numberProp = "number";
                if (!Objects.equals("bos_assistantdata_detail", valueSource)) {
                    BasedataEntityType entity = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)valueSource);
                    numberProp = entity.getNumberProperty();
                }
                DataSet assistNumberDataSet = QueryServiceHelper.queryDataSet((String)(AuxSubLedgerQueryRpt.class.getName() + "#orderByAssistNumber"), (String)valueSource, (String)String.format("id,%s number", numberProp), (QFilter[])new QFilter("id", "in", assistValues.get(i)).toArray(), null);
                dataSet = dataSet.join(assistNumberDataSet, JoinType.LEFT).on(assprefix, "id").select(dsFields.toArray(new String[0]), new String[]{"number " + assprefix + "num"}).finish();
                dsFields.add(assprefix + "num");
                orderField.add(assprefix + "num");
                continue;
            }
            orderField.add(assprefix);
        }
        orderField.add("accountnumber");
        if (qpRpt.isQueryCurrency()) {
            orderField.add("currency");
        }
        orderField.add("period");
        orderField.add("bookeddatestr");
        orderField.add("rowtype");
        orderField.add("vtnumber");
        orderField.add("billno");
        orderField.add("accountseq");
        return dataSet.orderBy(orderField.toArray(new String[0]));
    }

    private DataSet createDataSet(ReportQueryParam reportQueryParam, List<SubsidiaryRow> subsidiaryRowList, RowMeta rowMeta) {
        if (CollectionUtils.isEmpty(subsidiaryRowList)) {
            return GLUtil.getEmptyDS(((Object)((Object)this)).getClass(), (RowMeta)rowMeta);
        }
        List flexFieldNames = (List)reportQueryParam.getCustomParam().get("flexFieldNames");
        Map periodMap = (Map)reportQueryParam.getCustomParam().get("periodMap");
        QueryParamRpt qpRpt = (QueryParamRpt)reportQueryParam.getCustomParam().get("queryParamRpt");
        SubsidiaryColIndex subsidiaryColIndex = SubsidiaryColIndex.ofAux((RowMeta)rowMeta, (List)flexFieldNames);
        ArrayList detailDataList = new ArrayList(8);
        subsidiaryRowList.forEach(x -> {
            Object[] data = new Object[rowMeta.getFieldCount()];
            data[subsidiaryColIndex.getAccountId()] = x.getAccountId();
            data[subsidiaryColIndex.getAccountName()] = x.getAccountName();
            data[subsidiaryColIndex.getAccountDc()] = x.getAccountDc();
            data[subsidiaryColIndex.getAccountNumber()] = x.getAccountNumber();
            data[subsidiaryColIndex.getOrgId()] = x.getOrgId();
            data[subsidiaryColIndex.getBizDate()] = x.getBizDate();
            data[subsidiaryColIndex.getDateField()] = x.getBookedDate();
            data[subsidiaryColIndex.getBookedDateStr()] = x.getBookedDateStr();
            data[subsidiaryColIndex.getVoucherDesc()] = x.getVoucherDesc();
            data[subsidiaryColIndex.getVoucherId()] = x.getVoucherId();
            data[subsidiaryColIndex.getFentryId()] = x.getVoucherEntryId();
            data[subsidiaryColIndex.getVoucherNumber()] = x.getVoucherNum();
            data[subsidiaryColIndex.getVtNumber()] = x.getVtNum();
            data[subsidiaryColIndex.getBillNo()] = x.getVoucherNo();
            data[subsidiaryColIndex.getPeriod()] = x.getPeriodId();
            if (subsidiaryColIndex.getMeasureUnit() != -1) {
                data[subsidiaryColIndex.getMeasureUnit()] = x.getMeasureUnitId();
            }
            if (subsidiaryColIndex.getCurrencyColumn() != -1) {
                data[subsidiaryColIndex.getCurrencyColumn()] = x.getCurrencyId();
            }
            data[subsidiaryColIndex.getBaseCurrency()] = x.getBaseCurrency();
            data[subsidiaryColIndex.getDc()] = x.getEndDC();
            data[subsidiaryColIndex.getEndFor()] = x.getEndFor();
            data[subsidiaryColIndex.getEndLocal()] = x.getEndLocal();
            data[subsidiaryColIndex.getEndQty()] = x.getEndQty();
            if (subsidiaryColIndex.getCreditFor() != -1) {
                data[subsidiaryColIndex.getCreditFor()] = x.getCreditFor();
            }
            if (subsidiaryColIndex.getCreditQty() != -1) {
                data[subsidiaryColIndex.getCreditQty()] = x.getCreditQty();
            }
            if (subsidiaryColIndex.getDebitFor() != -1) {
                data[subsidiaryColIndex.getDebitFor()] = x.getDebitFor();
            }
            if (subsidiaryColIndex.getDebitQty() != -1) {
                data[subsidiaryColIndex.getDebitQty()] = x.getDebitQty();
            }
            data[subsidiaryColIndex.getCreditLocal()] = x.getCreditLocal();
            data[subsidiaryColIndex.getDebitLocal()] = x.getDebitLocal();
            String rowType = x.getRowtype();
            data[subsidiaryColIndex.getRowType()] = rowType;
            if ("1".equals(rowType)) {
                data[subsidiaryColIndex.getNameCtrlDate()] = ((SubsidiaryPeriod)periodMap.get(qpRpt.getStartPeriod())).getEnddate();
            } else if ("2".equals(rowType)) {
                data[subsidiaryColIndex.getNameCtrlDate()] = x.getBookedDate();
            } else if ("4".equals(rowType) || "5".equals(rowType)) {
                data[subsidiaryColIndex.getNameCtrlDate()] = ((SubsidiaryPeriod)periodMap.get(x.getPeriodId())).getEnddate();
            }
            List flexIndexes = subsidiaryColIndex.getFlexIndexes();
            for (int i = 0; i < flexIndexes.size(); ++i) {
                data[((Integer)flexIndexes.get((int)i)).intValue()] = x.getFlexTuple()[i].item2;
            }
            detailDataList.add(data);
        });
        DataSet detailDataSet = Algo.create((String)(AuxSubLedgerQueryRpt.class.getName() + "#createDataSet")).createDataSet(detailDataList.iterator(), rowMeta);
        return detailDataSet;
    }

    private void init(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        MulOrgQPRpt qpRpt = new MulOrgQPRpt(filterInfo, "t_rpt_aux_subledger");
        qpRpt.setShowAssist(true);
        qpRpt.setShowOrg(true);
        CacheHelper.getDistributeCache((CacheModule)CacheModule.report).put("AuxSubLedgerQueryRpt-qpRpt", SerializationUtils.toJsonString((Object)qpRpt.getCurType()));
        List<Tuple<String, String>> assTypenameList = ReportHelper.buildAssTypenameList(reportQueryParam);
        Map orgAccountbookMap = SubsidiaryReportDatasetBuilder.initOrgAccountbookMap(new HashSet(qpRpt.getAllEntityOrgs()), (FilterInfo)filterInfo);
        Map orgCurLocalMap = (Map)orgAccountbookMap.get("orgCurLocal");
        Tuple vouchertypeMap = SubsidiaryReportDatasetBuilder.initVoucherTypeMap();
        QueryParam queryParam = new QueryParam();
        queryParam.setAccountFilter(new QFilter("id", "in", (Object)ReportUtils.getAccIdSetByFlexFields((MulOrgQPRpt)qpRpt, (ReportQueryParam)reportQueryParam)));
        queryParam.setSpecialAccount(false);
        queryParam.setOnlyLeafAcctBal(qpRpt.isShowLeafAccount());
        IAccountTreeModel accTreeModel = IAccountTreeModel.getInstance((Long[])qpRpt.getChildOrg().toArray(new Long[0]), (long)qpRpt.getAccountTable(), (long)qpRpt.getEndPeriod(), (QueryParam)queryParam);
        qpRpt.setMasterIdSet(accTreeModel.getFilterAccountIds());
        Map acctMID2IDMap = SubsidiaryReportDatasetBuilder.initAcctMID2IDMap((QueryParamRpt)qpRpt);
        Map acctID2MIDMap = SubsidiaryReportDatasetBuilder.initAcctID2MIDMap((QueryParamRpt)qpRpt);
        Map periodMap = SubsidiaryReportDatasetBuilder.initPeriodMap((FilterInfo)filterInfo);
        List flexFilterItems = filterInfo.getFlexFilterItems();
        ArrayList<String> flexFieldNames = new ArrayList<String>(flexFilterItems.size());
        for (int i = 0; i < flexFilterItems.size(); ++i) {
            String aliasVal = "assval" + (i == 0 ? "" : Integer.valueOf(i));
            flexFieldNames.add(aliasVal);
        }
        reportQueryParam.getCustomParam().put("queryParamRpt", qpRpt);
        reportQueryParam.getCustomParam().put("orgCurLocalMap", orgCurLocalMap);
        reportQueryParam.getCustomParam().put("vouchertypeMap", vouchertypeMap);
        reportQueryParam.getCustomParam().put("acctMID2IDMap", acctMID2IDMap);
        reportQueryParam.getCustomParam().put("acctID2MIDMap", acctID2MIDMap);
        reportQueryParam.getCustomParam().put("periodMap", periodMap);
        reportQueryParam.getCustomParam().put("flexFieldNames", flexFieldNames);
        reportQueryParam.getCustomParam().put("assTypenameList", assTypenameList);
        Map<String, Set<Object>> initFlexValueMap = this.getInitFlexValueMap(reportQueryParam);
        QFilter emptyQFilter = QFilter.of((String)"1!=1", (Object[])new Object[0]);
        DataSet dataSet = SubsidiaryReportDatasetBuilder.queryOrmVoucher((ReportQueryParam)reportQueryParam, Collections.singletonList(emptyQFilter), (int)0, initFlexValueMap);
        RowMeta rowMeta = dataSet.getRowMeta();
        ArrayList<Field> fieldList = new ArrayList<Field>(rowMeta.getFieldCount() + 1);
        Arrays.stream(rowMeta.getFields()).forEach(x -> fieldList.add((Field)x));
        fieldList.add(new Field("namectrldate", (DataType)DataType.DateType));
        RowMeta newRowMeta = new RowMeta(fieldList.toArray(new Field[0]));
        reportQueryParam.getCustomParam().put("rowMeta", newRowMeta);
        reportQueryParam.getCustomParam().put("beginVoucherDesc", ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"GeneralLedgerQueryRpt_0", (String)"fi-gl-report", (Object[])new Object[0]));
        reportQueryParam.getCustomParam().put("periodVoucherDesc", ResManager.loadKDString((String)"\u672c\u671f\u5408\u8ba1", (String)"GeneralLedgerQueryRpt_1", (String)"fi-gl-report", (Object[])new Object[0]));
        reportQueryParam.getCustomParam().put("yearVoucherDesc", ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1", (String)"GeneralLedgerQueryRpt_2", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private Map<String, Set<Object>> getInitFlexValueMap(ReportQueryParam reportQueryParam) {
        List filterItemInfos = reportQueryParam.getFilter().getFlexFilterItems();
        LinkedHashMap<String, Set<Object>> initFlexValueMap = new LinkedHashMap<String, Set<Object>>(filterItemInfos.size());
        filterItemInfos.stream().forEach(x -> initFlexValueMap.put(x.getPropName(), (Set)x.getValue()));
        return initFlexValueMap;
    }

    private DataSet queryByGroupBatch(ReportQueryParam reportQueryParam, RowMeta rowMeta) {
        List batchRows = reportQueryParam.byBatchInfo().getCurrentBatchRows();
        ArrayList subDatasets = new ArrayList(2);
        batchRows.forEach(batch -> {
            BalanceGroupRow balanceGroupRow = (BalanceGroupRow)SerializationUtils.fromJsonString((String)batch.getString(1), BalanceGroupRow.class);
            DataSet dataSet = this.queryByGroup(reportQueryParam, balanceGroupRow, rowMeta);
            if (!dataSet.isEmpty()) {
                subDatasets.add(dataSet);
            }
        });
        if (subDatasets.size() == 0) {
            return GLUtil.getEmptyDS(((Object)((Object)this)).getClass(), (RowMeta)rowMeta);
        }
        if (subDatasets.size() == 1) {
            return (DataSet)subDatasets.get(0);
        }
        return ((DataSet)subDatasets.get(0)).union(subDatasets.subList(1, subDatasets.size()).toArray(new DataSet[0]));
    }

    private DataSet queryByGroup(ReportQueryParam reportQueryParam, BalanceGroupRow balanceGroupRow, RowMeta rowMeta) {
        long tick = System.currentTimeMillis();
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List flexFilterItems = filterInfo.getFlexFilterItems();
        HashMap<Integer, Boolean> assEmptyMap = new HashMap<Integer, Boolean>(8);
        List assTypenameList = (List)reportQueryParam.getCustomParam().get("assTypenameList");
        HashMap<String, Set<Object>> flexValueMap = new HashMap<String, Set<Object>>(flexFilterItems.size());
        for (int i = 0; i < flexFilterItems.size(); ++i) {
            FilterItemInfo flexFilter = (FilterItemInfo)flexFilterItems.get(i);
            String entityId = (String)((Tuple)assTypenameList.get((int)i)).item2;
            if (entityId != null && Objects.equals(balanceGroupRow.getFlexTuple()[i].item2, 0)) {
                flexValueMap.put(flexFilter.getPropName(), Collections.emptySet());
                assEmptyMap.put(i, entityId != null);
                continue;
            }
            if (Objects.isNull(balanceGroupRow.getFlexTuple()[i].item2)) {
                flexValueMap.put(flexFilter.getPropName(), Collections.emptySet());
                assEmptyMap.put(i, entityId != null);
                continue;
            }
            flexValueMap.put(flexFilter.getPropName(), Collections.singleton(balanceGroupRow.getFlexTuple()[i].item2));
        }
        DataSet beginDataSet = SubsidiaryReportDatasetBuilder.queryPeriodBeginByBatch((ReportQueryParam)reportQueryParam, (BalanceGroupRow)balanceGroupRow, (AssistBalBatchQueryType)AssistBalBatchQueryType.GROUP, flexValueMap);
        beginDataSet = this.filterEmpty(assEmptyMap, beginDataSet);
        logger.info("queryByGroup_cost queryPeriodBeginByBatch:{}ms", (Object)(System.currentTimeMillis() - tick));
        tick = System.currentTimeMillis();
        List beginList = ReportBalanceUtil.convertAndSumDataSetToList((ReportQueryParam)reportQueryParam, (DataSet)beginDataSet, (IDatasetRowTypeConverter)new AuxPeriodBeginConverter());
        logger.info("queryByGroup_cost convertAndSumDataSetToList:{}ms", (Object)(System.currentTimeMillis() - tick));
        tick = System.currentTimeMillis();
        List<SubsidiaryRow> voucherDataSet = this.queryVoucher(reportQueryParam, balanceGroupRow, assEmptyMap, AssistBalBatchQueryType.GROUP, flexValueMap);
        logger.info("queryByGroup_cost queryVoucher:{}ms", (Object)(System.currentTimeMillis() - tick));
        tick = System.currentTimeMillis();
        List resultDataList = ReportBalanceUtil.calculateWithPeriodBegin((ReportQueryParam)reportQueryParam, (List)beginList, voucherDataSet);
        if (CollectionUtils.isEmpty((Collection)resultDataList)) {
            return GLUtil.getEmptyDS(((Object)((Object)this)).getClass(), (RowMeta)rowMeta);
        }
        logger.info("queryByGroup_cost calculateWithPeriodBegin:{}ms", (Object)(System.currentTimeMillis() - tick));
        DataSet dataSet = this.createDataSet(reportQueryParam, resultDataList, rowMeta);
        return dataSet;
    }

    private DataSet filterEmpty(final Map<Integer, Boolean> assEmptyMap, DataSet dataSet) {
        if (null == assEmptyMap || assEmptyMap.isEmpty()) {
            return dataSet;
        }
        dataSet = dataSet.filter(new FilterFunction(){

            public boolean test(Row row) {
                for (Map.Entry assEmptyObj : assEmptyMap.entrySet()) {
                    String assFieldName;
                    Integer index = (Integer)assEmptyObj.getKey();
                    String string = assFieldName = index == 0 ? "assval" : "assval" + index;
                    if (((Boolean)assEmptyObj.getValue()).booleanValue() && !Objects.equals(row.get(assFieldName), 0L)) {
                        return false;
                    }
                    if (((Boolean)assEmptyObj.getValue()).booleanValue() || Objects.isNull(row.get(assFieldName))) continue;
                    return false;
                }
                return true;
            }
        });
        return dataSet;
    }

    private List<SubsidiaryRow> queryVoucher(ReportQueryParam reportQueryParam, BalanceGroupRow balanceGroupRow, Map<Integer, Boolean> assEmptyMap, AssistBalBatchQueryType batchType, Map<String, Set<Object>> flexValueMap) {
        QFilter accountQF;
        int limit = (Integer)reportQueryParam.getCustomParam().get("limit");
        QueryParamRpt qpRpt = (QueryParamRpt)reportQueryParam.getCustomParam().get("queryParamRpt");
        if (batchType == AssistBalBatchQueryType.GROUP) {
            String idCacheKey = String.format("accountCache_%s", balanceGroupRow.getAccountMasterId());
            Object[] accountIds = (Object[])reportQueryParam.getCustomParam().get(idCacheKey);
            if (Objects.isNull(accountIds)) {
                accountIds = SubsiDiaryHelper.getAcctIdByMasterId(Collections.singleton(balanceGroupRow.getAccountMasterId()));
                reportQueryParam.getCustomParam().put(idCacheKey, accountIds);
            }
            accountQF = new QFilter("entries.account", "in", (Object)accountIds);
        } else {
            accountQF = new QFilter("entries.account", "in", (Object)SubsiDiaryHelper.getAcctIDs((FilterInfo)qpRpt.getFilterInfo(), (Long)balanceGroupRow.getOrgId()));
        }
        DataSet voucherDataSet = SubsidiaryReportDatasetBuilder.queryVoucherByBatch((ReportQueryParam)reportQueryParam, (BalanceGroupRow)balanceGroupRow, (int)limit, (AssistBalBatchQueryType)batchType, flexValueMap, (QFilter)accountQF);
        voucherDataSet = this.filterEmpty(assEmptyMap, voucherDataSet);
        List voucherList = ReportBalanceUtil.convertDataSetToList((ReportQueryParam)reportQueryParam, (DataSet)voucherDataSet, (IDatasetRowTypeConverter)new AuxVoucherConverter());
        reportQueryParam.getCustomParam().put("limit", limit - voucherList.size());
        return voucherList;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        MulOrgQPRpt qpRpt = new MulOrgQPRpt(filterInfo, "t_rpt_aux_subledger");
        qpRpt.setShowAssist(true);
        qpRpt.setShowOrg(true);
        List<Tuple<String, String>> assTypenameList = ReportHelper.buildAssTypenameList(this.getQueryParam());
        List<AbstractReportColumn> reportColumn = new AuxSubLedgerHelper(qpRpt, assTypenameList).getReportColumn(columns);
        List<ReportColumn> list = this.getAllReportColumns(reportColumn);
        for (ReportColumn column : list) {
            String fieldKey;
            switch (fieldKey = column.getFieldKey()) {
                case "debitrpt": 
                case "creditrpt": 
                case "endrpt": {
                    column.setHide(!qpRpt.isShowRpt());
                    break;
                }
                case "measureunit": {
                    column.setHide(!qpRpt.isShowQty());
                }
            }
        }
        ReportColumn ventryColumn = new ReportColumn();
        ventryColumn.setHide(true);
        ventryColumn.setFieldKey("fentryid");
        ventryColumn.setFieldType("text");
        reportColumn.add((AbstractReportColumn)ventryColumn);
        reportColumn.addAll(ReportFieldSettingUtil.createCustomColumns((String)"t_rpt_aux_subledger"));
        return reportColumn;
    }

    private List<ReportColumn> getAllReportColumns(List<AbstractReportColumn> columns) {
        ArrayList<ReportColumn> list = new ArrayList<ReportColumn>();
        for (AbstractReportColumn column : columns) {
            if (column instanceof ReportColumn) {
                list.add((ReportColumn)column);
                continue;
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            ReportColumnGroup group = (ReportColumnGroup)column;
            list.addAll(this.getAllReportColumns(group.getChildren()));
        }
        return list;
    }
}

