/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.cashflow;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.fi.gl.dataset.TreeNode;
import kd.fi.gl.report.CashFlowQueryParam;
import kd.fi.gl.report.cashflow.CashFlowCollector;
import kd.fi.gl.report.common.CollectorParam;
import kd.fi.gl.report.common.ICollector;
import kd.fi.gl.report.common.OutPutFunction;
import kd.fi.gl.report.common.SumSchema;
import kd.fi.gl.util.GLUtil;

public class CashFlowBalanceFunction
implements OutPutFunction {
    private int fieldCount;
    private Map<Object, TreeNode> accMasterIdMap;
    private int accountIndex;
    private int beginlocalIndex;
    private int endlocalIndex;
    private int yeardebitlocalIndex;
    private int yearcreditlocalIndex;
    private int periodIndex;
    private int endPeriodIndex;
    private int opBeginlocalIndex;
    private int opEndlocalIndex;
    private int opYearlocalIndex;
    private int opIscashIndex;
    private int opIsbankIndex;
    private int opIscasheqIndex;
    private long queryBeginPeriod;
    private long queryEndPeriod;
    private Map<Integer, Integer> comassistIndex = new HashMap<Integer, Integer>(2);

    public CashFlowBalanceFunction(RowMeta inputRowMeta, CollectorParam param, Map<Object, TreeNode> accMasterIdMap, RowMeta outPutAccountRowMeta) {
        CashFlowQueryParam qpRpt = (CashFlowQueryParam)param.getParam();
        this.queryBeginPeriod = qpRpt.getPeriodIdByQueryType();
        this.queryEndPeriod = qpRpt.getPeriodEndIdByQueryType();
        this.fieldCount = outPutAccountRowMeta.getFieldCount();
        this.accMasterIdMap = accMasterIdMap;
        this.accountIndex = inputRowMeta.getFieldIndex("account");
        this.beginlocalIndex = inputRowMeta.getFieldIndex("beginlocal");
        this.endlocalIndex = inputRowMeta.getFieldIndex("endlocal");
        this.yeardebitlocalIndex = inputRowMeta.getFieldIndex("yeardebitlocal");
        this.yearcreditlocalIndex = inputRowMeta.getFieldIndex("yearcreditlocal");
        this.periodIndex = inputRowMeta.getFieldIndex("period");
        this.endPeriodIndex = inputRowMeta.getFieldIndex("endperiod");
        this.opBeginlocalIndex = outPutAccountRowMeta.getFieldIndex("beginlocal");
        this.opEndlocalIndex = outPutAccountRowMeta.getFieldIndex("endlocal");
        this.opYearlocalIndex = outPutAccountRowMeta.getFieldIndex("yearlocal");
        this.opIscashIndex = outPutAccountRowMeta.getFieldIndex("iscash");
        this.opIsbankIndex = outPutAccountRowMeta.getFieldIndex("isbank");
        this.opIscasheqIndex = outPutAccountRowMeta.getFieldIndex("iscasheq");
        List commonAssists = ((CashFlowQueryParam)param.getParam()).getCommonAssistKeys();
        for (String comassist : commonAssists) {
            this.comassistIndex.put(inputRowMeta.getFieldIndex(comassist, false), outPutAccountRowMeta.getFieldIndex(comassist, false));
        }
    }

    @Override
    public void output(Row row, ICollector collector) {
        Long acc = row.getLong(this.accountIndex);
        TreeNode node = this.accMasterIdMap.get(acc);
        if (node == null) {
            return;
        }
        boolean isCash = (Boolean)node.getPropValue("iscash");
        boolean isBank = (Boolean)node.getPropValue("isbank");
        boolean isCashEq = (Boolean)node.getPropValue("iscasheq");
        if (isCash || isBank || isCashEq) {
            CashFlowCollector cashFlowCollector = (CashFlowCollector)collector;
            SumSchema accountSumSchema = cashFlowCollector.getAccountSumSchema();
            Object[] result = new Object[this.fieldCount];
            result[this.opBeginlocalIndex] = BigDecimal.ZERO;
            result[this.opEndlocalIndex] = BigDecimal.ZERO;
            result[this.opYearlocalIndex] = BigDecimal.ZERO;
            BigDecimal beginLocal = row.getBigDecimal(this.beginlocalIndex);
            BigDecimal endLocal = row.getBigDecimal(this.endlocalIndex);
            BigDecimal yearLocal = row.getBigDecimal(this.yeardebitlocalIndex).subtract(row.getBigDecimal(this.yearcreditlocalIndex));
            Long period = row.getLong(this.periodIndex);
            Long endPeriod = row.getLong(this.endPeriodIndex);
            if (period == this.queryBeginPeriod) {
                result[this.opBeginlocalIndex] = beginLocal;
            } else if (period < this.queryBeginPeriod && endPeriod > this.queryBeginPeriod) {
                result[this.opBeginlocalIndex] = endLocal;
            }
            if (period <= this.queryEndPeriod && endPeriod > this.queryEndPeriod) {
                result[this.opEndlocalIndex] = endLocal;
            }
            if (endPeriod > this.queryEndPeriod && period <= this.queryEndPeriod && period > this.queryEndPeriod / GLUtil.YEAR_PERIOD_L * GLUtil.YEAR_PERIOD_L) {
                result[this.opYearlocalIndex] = yearLocal;
            }
            result[this.opIscashIndex] = isCash;
            result[this.opIsbankIndex] = isBank;
            result[this.opIscasheqIndex] = isCashEq;
            for (Map.Entry<Integer, Integer> entry : this.comassistIndex.entrySet()) {
                int inIndex = entry.getKey();
                if (inIndex == -1) continue;
                result[entry.getValue().intValue()] = row.get(inIndex);
            }
            accountSumSchema.getLeafDataSchema().outPutData(result);
        }
    }
}

