/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.cashflow;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.fi.gl.dataset.TreeNode;
import kd.fi.gl.report.CashFlowQueryParam;
import kd.fi.gl.report.common.CollectorParam;
import kd.fi.gl.report.common.ICollector;
import kd.fi.gl.report.common.OutPutFunction;
import kd.fi.gl.util.GLUtil;

public class CashFlowItemFunction
implements OutPutFunction {
    private int fieldCount;
    private int amountIndex;
    private int yearAmountIndex;
    private int cfitemIndex;
    private int orgIndex;
    private int assgrpIndex;
    private int periodIndex;
    private int endPeriodIndex;
    private int opAmountIndex;
    private int opYearAmountIndex;
    private int opCfitemIndex;
    private int opOrgIndex;
    private int opAssgrpIndex;
    private Map<Object, TreeNode> cfItemIdMap;
    private boolean queryFromInit;
    private long queryBeginPeriod;
    private long queryEndPeriod;
    private Map<Integer, Integer> comassistIndex = new HashMap<Integer, Integer>(8);

    public CashFlowItemFunction(RowMeta inputRowMeta, CollectorParam param, Map<Object, TreeNode> cfItemIdMap) {
        this.cfItemIdMap = cfItemIdMap;
        CashFlowQueryParam qpRpt = (CashFlowQueryParam)param.getParam();
        this.queryBeginPeriod = qpRpt.getPeriodIdByQueryType();
        this.queryEndPeriod = qpRpt.getPeriodEndIdByQueryType();
        this.queryFromInit = qpRpt.isQueryFromInit();
        RowMeta outputRowMeta = param.getRowMeta();
        this.fieldCount = outputRowMeta.getFieldCount();
        this.amountIndex = inputRowMeta.getFieldIndex("amount", false);
        this.yearAmountIndex = inputRowMeta.getFieldIndex("yearamount", false);
        this.cfitemIndex = inputRowMeta.getFieldIndex("cfitem", false);
        this.orgIndex = inputRowMeta.getFieldIndex("orgid", false);
        this.assgrpIndex = inputRowMeta.getFieldIndex("assgrp", false);
        this.periodIndex = inputRowMeta.getFieldIndex("period", false);
        this.endPeriodIndex = inputRowMeta.getFieldIndex("endperiod", false);
        this.opAmountIndex = outputRowMeta.getFieldIndex("amount", false);
        this.opYearAmountIndex = outputRowMeta.getFieldIndex("yearamount", false);
        this.opCfitemIndex = outputRowMeta.getFieldIndex("cfitem", false);
        this.opOrgIndex = outputRowMeta.getFieldIndex("orgid", false);
        this.opAssgrpIndex = outputRowMeta.getFieldIndex("assgrp", false);
        List commonAssists = ((CashFlowQueryParam)param.getParam()).getCommonAssistKeys();
        for (String comassist : commonAssists) {
            this.comassistIndex.put(inputRowMeta.getFieldIndex(comassist, false), outputRowMeta.getFieldIndex(comassist, false));
        }
    }

    @Override
    public void output(Row row, ICollector collector) {
        if (row.getLong(this.cfitemIndex) == 0L) {
            return;
        }
        Object[] result = new Object[this.fieldCount];
        result[this.opAmountIndex] = BigDecimal.ZERO;
        result[this.opYearAmountIndex] = BigDecimal.ZERO;
        if (this.queryFromInit) {
            result[this.opYearAmountIndex] = row.get(this.yearAmountIndex);
            result[this.opCfitemIndex] = this.cfItemIdMap.get(row.get(this.cfitemIndex)).getMasterId();
        } else {
            Long period = row.getLong(this.periodIndex);
            Long endPeriod = row.getLong(this.endPeriodIndex);
            if (period >= this.queryBeginPeriod) {
                result[this.opAmountIndex] = row.get(this.amountIndex);
            }
            if (endPeriod > this.queryEndPeriod && period <= this.queryEndPeriod && period > this.queryEndPeriod / GLUtil.YEAR_PERIOD_L * GLUtil.YEAR_PERIOD_L) {
                result[this.opYearAmountIndex] = row.get(this.yearAmountIndex);
            }
            result[this.opCfitemIndex] = row.get(this.cfitemIndex);
        }
        if (this.orgIndex != -1) {
            result[this.opOrgIndex] = row.get(this.orgIndex);
        }
        if (this.assgrpIndex != -1) {
            result[this.opAssgrpIndex] = row.get(this.assgrpIndex);
        }
        for (Map.Entry<Integer, Integer> entry : this.comassistIndex.entrySet()) {
            int inIndex = entry.getKey();
            if (inIndex == -1) continue;
            result[entry.getValue().intValue()] = row.get(inIndex);
        }
        collector.collect(result);
    }
}

