/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.closeperiod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.log.utils.LogOperactionListutils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.JSONUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.constant.closeperiod.ClosePeriodInfo;
import kd.fi.gl.constant.closeperiod.ClosePeriodResultInfo;
import kd.fi.gl.report.ReportUtils;

public class ClosePeriodQueryRpt
extends AbstractReportListDataPlugin {
    private static final String CLOSE_SUCC = "b";
    private static final String CLOSE_FAIL = "c";
    private static final String CHECK_SUCC = "d";
    private static final String CHECK_FAIL = "e";
    private static final Map<String, kd.bos.dataentity.Tuple<String, Class<?>>> cloumMap = new HashMap();
    private String queryType;
    private DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.periodClose);

    public DataSet query(ReportQueryParam param, Object obj) throws Throwable {
        Long bookstype;
        Long org;
        QFilter orgQfilter = null;
        QFilter booksTypesQfilter = null;
        QFilter periodQfilter = null;
        FilterInfo filterInfo = param.getFilter();
        if (filterInfo.getDynamicObjectCollection("periodcloseorg") != null) {
            DynamicObjectCollection dyns = filterInfo.getDynamicObjectCollection("periodcloseorg");
            List orgs = dyns.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
            orgQfilter = new QFilter("org", "in", orgs);
        } else {
            List hasViewPermOrgList = param.getCustomParam().getOrDefault("hasViewPermOrgs", Collections.EMPTY_LIST);
            orgQfilter = new QFilter("org", "in", (Object)hasViewPermOrgList);
        }
        if (filterInfo.getLong("bookscombo") != 0L) {
            Long booksTypes = filterInfo.getLong("bookscombo");
            booksTypesQfilter = new QFilter("bookstype", "in", (Object)booksTypes);
        }
        if (filterInfo.getLong("period") != 0L) {
            periodQfilter = new QFilter("curperiod", "=", filterInfo.getDynamicObject("period").getPkValue());
        }
        QFilter periodTypeQfilter = new QFilter("periodtype", "=", filterInfo.getDynamicObject("periodtype").getPkValue());
        DataSet booksTypesDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_accountbook", (String)"id booktype,bookstype,org,curperiod", (QFilter[])new QFilter[]{orgQfilter, booksTypesQfilter, periodTypeQfilter, periodQfilter}, null);
        String pageId = param.getCustomParam().get("pageid").toString();
        HashMap<String, String> dealInfo = new HashMap<String, String>();
        List closeRsult = null;
        Map checkPeriod = null;
        String closeResultCache = this.cache.get(pageId + "closeresult");
        String checkPeriodCache = this.cache.get(pageId + "checkperiod");
        if (StringUtils.isNotEmpty((CharSequence)closeResultCache)) {
            closeRsult = (List)JSONUtils.cast((String)closeResultCache, List.class);
            if (!CollectionUtils.isEmpty((Collection)closeRsult)) {
                for (String string : closeRsult) {
                    ClosePeriodResultInfo info = (ClosePeriodResultInfo)SerializationUtils.deSerializeFromBase64((String)string);
                    String key = info.getOrg() + "_" + info.getBooksType();
                    dealInfo.put(key, info.isSuccess() ? CLOSE_SUCC : CLOSE_FAIL);
                }
            }
        } else if (StringUtils.isNotEmpty((CharSequence)checkPeriodCache)) {
            checkPeriod = (Map)SerializationUtils.deSerializeFromBase64((String)checkPeriodCache);
            for (Map.Entry entry : checkPeriod.entrySet()) {
                Tuple value = (Tuple)entry.getValue();
                dealInfo.put((String)entry.getKey(), (Boolean)value.item1 != false ? CHECK_SUCC : CHECK_FAIL);
            }
            this.queryType = "checkperiod";
        }
        AtomicLong rowId = new AtomicLong(1111L);
        RowMeta rowMeta9 = LogOperactionListutils.rowMetaAddField((RowMeta)booksTypesDataSet.getRowMeta(), (String)"pid", (DataType)DataType.LongType);
        rowMeta9 = LogOperactionListutils.rowMetaAddField((RowMeta)rowMeta9, (String)"rowid", (DataType)DataType.LongType);
        rowMeta9 = LogOperactionListutils.rowMetaAddField((RowMeta)rowMeta9, (String)"isgroupnode", (DataType)DataType.LongType);
        rowMeta9 = LogOperactionListutils.rowMetaAddField((RowMeta)rowMeta9, (String)"status", (DataType)DataType.StringType);
        rowMeta9 = LogOperactionListutils.rowMetaAddField((RowMeta)rowMeta9, (String)"checkitem", (DataType)DataType.StringType);
        rowMeta9 = LogOperactionListutils.rowMetaAddField((RowMeta)rowMeta9, (String)"dealfail", (DataType)DataType.StringType);
        rowMeta9 = LogOperactionListutils.rowMetaAddField((RowMeta)rowMeta9, (String)"formquery", (DataType)DataType.StringType);
        rowMeta9 = LogOperactionListutils.rowMetaAddField((RowMeta)rowMeta9, (String)"formnumber", (DataType)DataType.StringType);
        rowMeta9 = LogOperactionListutils.rowMetaAddField((RowMeta)rowMeta9, (String)"message", (DataType)DataType.StringType);
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        for (Object row : booksTypesDataSet.copy()) {
            Row row2 = RowUtil.persist((Row)row);
            Long org2 = row.getLong("org");
            Long bookstype2 = row.getLong("bookstype");
            String status = (String)dealInfo.get(org2 + "_" + bookstype2);
            boolean isSucc = StringUtils.isEmpty((CharSequence)status) || CLOSE_SUCC.equals(status) || CHECK_SUCC.equals(status);
            Object[] rowValues = RowUtil.toArray((Row)row2);
            int len = rowValues.length;
            Object[] newValues = new Object[len + 9];
            System.arraycopy(rowValues, 0, newValues, 0, len);
            newValues[len] = 0L;
            newValues[len + 1] = rowId.getAndAdd(1L);
            newValues[len + 2] = isSucc ? 0L : 1L;
            newValues[len + 3] = status;
            if (!isSucc && StringUtils.isEmpty((CharSequence)this.cache.get(pageId + "viewall"))) {
                newValues[len + 4] = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"ClosePeriodQueryRpt_3", (String)"fi-gl-report", (Object[])new Object[0]);
            }
            rows.add(newValues);
        }
        booksTypesDataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(rows.iterator(), rowMeta9);
        DataSet result = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(Collections.emptyIterator(), booksTypesDataSet.getRowMeta());
        if (!CollectionUtils.isEmpty((Collection)closeRsult)) {
            for (String string : closeRsult) {
                DynamicObject sd;
                DynamicObjectCollection checkItemColl;
                QFilter periodQf;
                DynamicObjectCollection doc;
                AccountBookInfo accountBookInfo;
                ClosePeriodResultInfo info = (ClosePeriodResultInfo)SerializationUtils.deSerializeFromBase64((String)string);
                org = info.getOrg();
                bookstype = info.getBooksType();
                String orgAndBook = org + "_" + bookstype;
                String requestId = info.getRequestId();
                Long period = info.getPeriod();
                ClosePeriodInfo closePeriodInfo = info.getClosePeriodInfo();
                String formId = closePeriodInfo.getFormId();
                if (info.isSuccess()) continue;
                QFilter qf = new QFilter("company", "=", (Object)org);
                if ("gl_accountbook".equals(formId) && (accountBookInfo = AccSysUtil.getBookFromAccSys((long)org, (long)bookstype)) != null) {
                    qf.and(new QFilter("accountbooks", "=", (Object)(accountBookInfo.getId() + "")));
                }
                QFilter stateQf = new QFilter("closestate", "=", (Object)"2");
                QFilter formIdQf = new QFilter("subsysformnum", "=", (Object)formId);
                if (info.getReachPeriodId() == null || info.getReachPeriodId() == 0L) {
                    DynamicObject collection;
                    QFilter qfilter = new QFilter("org", "=", (Object)org);
                    if (bookstype != null) {
                        qfilter.and(new QFilter(closePeriodInfo.getTypeFieldName(), "=", (Object)bookstype));
                    }
                    boolean havePeriod = (collection = QueryServiceHelper.queryOne((String)formId, (String)"curperiod", (QFilter[])qfilter.toArray())) == null || collection != null && collection.getLong("curperiod") == 0L;
                    period = havePeriod ? period.longValue() : collection.getLong("curperiod");
                }
                if ((doc = QueryServiceHelper.query((String)"gl_closestate", (String)"id", (QFilter[])new QFilter[]{qf, stateQf, periodQf = new QFilter("period", "=", (Object)period), formIdQf}, (String)"closedate asc")).size() == 0) continue;
                String closeKey = "CLOSE_PERIOD." + requestId + "_" + orgAndBook;
                QFilter filter = new QFilter("id", "=", (Object)((DynamicObject)doc.get(0)).getLong("id"));
                QFilter[] filters = new QFilter[]{filter};
                DynamicObjectCollection closestateColl = QueryServiceHelper.query((String)"gl_closestate", (String)"id, company, subsysformnum, accountbooks, period, thisclosetime,closedetails", (QFilter[])filters);
                if (closestateColl.size() == 0) {
                    return null;
                }
                DataSet filterDs = booksTypesDataSet.copy().filter("org=" + org).filter("bookstype = " + bookstype);
                String s = this.cache.get(closeKey);
                if (!StringUtils.isNotBlank((CharSequence)s) || (checkItemColl = (sd = (DynamicObject)DataEntitySerializer.deSerializerFromString((String)s, (IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_closecheckitem"))).getDynamicObjectCollection("entryentity")).size() == 0) continue;
                result = result.union(this.getResultDs(filterDs, checkItemColl, rowId));
            }
        } else if (!CollectionUtils.isEmpty((Map)checkPeriod)) {
            for (Map.Entry entry : checkPeriod.entrySet()) {
                String org2bookstype = (String)entry.getKey();
                org = Long.parseLong(org2bookstype.split("_")[0]);
                bookstype = Long.parseLong(org2bookstype.split("_")[1]);
                if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)((Tuple)entry.getValue()).item2))) continue;
                DynamicObjectCollection entryEntity = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)((String)((Tuple)entry.getValue()).item2));
                DataSet filterDs = booksTypesDataSet.copy().filter("org=" + org).filter("bookstype = " + bookstype);
                result = result.union(this.getResultDs(filterDs, entryEntity, rowId));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)this.cache.get(pageId + "viewall"))) {
            List qFilters = ReportUtils.tableHeadFilter2QFilters((List)filterInfo.getTableHeadFilterItems(), cloumMap);
            for (QFilter qFilter : qFilters) {
                result = result.filter(qFilter.toString());
            }
        }
        booksTypesDataSet = booksTypesDataSet.union(result).orderBy(new String[]{"booktype", "rowid"});
        return booksTypesDataSet;
    }

    private String getFailUrl(String menuid) {
        String rootUrl = UrlService.getDomainContextUrl();
        if (rootUrl.endsWith("/")) {
            rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
        }
        menuid = menuid.startsWith("/") ? rootUrl + menuid : rootUrl + "/" + menuid;
        return menuid;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        if ("checkperiod".equals(this.queryType)) {
            for (ReportColumn reportColumn : columns) {
                if (!"status".equals(reportColumn.getFieldKey())) continue;
                reportColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u68c0\u67e5\u7ed3\u679c", (String)"ClosePeriodQueryRpt_0", (String)"fi-gl-report", (Object[])new Object[0])));
            }
        }
        return columns;
    }

    private Map<String, Integer> getAllColumnIndex(RowMeta rowMeta) {
        Field[] fields = rowMeta.getFields();
        HashMap<String, Integer> indexs = new HashMap<String, Integer>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            indexs.put(fields[i].getAlias(), i);
        }
        return indexs;
    }

    private DataSet getResultDs(DataSet filterDs, DynamicObjectCollection entryentity, AtomicLong rowid) {
        ArrayList<Object[]> seqRows = new ArrayList<Object[]>();
        int length = filterDs.getRowMeta().getFields().length;
        List entityList = entryentity.stream().sorted(Comparator.comparing(entity -> {
            if ("1".equals(entity.getString("checkstate"))) {
                return 1;
            }
            return 0;
        })).collect(Collectors.toList());
        Map<String, Integer> allIndex = this.getAllColumnIndex(filterDs.getRowMeta());
        for (DynamicObject dyn : entityList) {
            Object[] newValues = new Object[length];
            for (Row row : filterDs.copy()) {
                Object[] rowValues = RowUtil.toArray((Row)row);
                int len = rowValues.length;
                System.arraycopy(rowValues, 0, newValues, 0, len);
                newValues[allIndex.get((Object)"checkitem").intValue()] = dyn.getString("checkitem");
                newValues[allIndex.get((Object)"dealfail").intValue()] = this.getFailUrl(dyn.getString("menuid"));
                newValues[allIndex.get((Object)"pid").intValue()] = row.getLong("rowid");
                newValues[allIndex.get((Object)"isgroupnode").intValue()] = 0;
                newValues[allIndex.get((Object)"rowid").intValue()] = rowid.getAndAdd(1L);
                newValues[allIndex.get((Object)"formquery").intValue()] = dyn.getString("formquery");
                newValues[allIndex.get((Object)"formnumber").intValue()] = dyn.getString("formnumber");
                newValues[allIndex.get((Object)"message").intValue()] = dyn.getString("message");
                newValues[allIndex.get((Object)"dealfail").intValue()] = "1".equals(dyn.getString("checkstate")) ? ResManager.loadKDString((String)"\u68c0\u67e5\u901a\u8fc7", (String)"ClosePeriodQueryRpt_1", (String)"fi-gl-report", (Object[])new Object[0]) : (StringUtils.isEmpty((CharSequence)dyn.getString("message")) ? ResManager.loadKDString((String)"\u5904\u7406", (String)"ClosePeriodQueryRpt_2", (String)"fi-gl-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"ClosePeriodQueryRpt_3", (String)"fi-gl-report", (Object[])new Object[0]));
                newValues[allIndex.get((Object)"status").intValue()] = "";
                newValues[allIndex.get((Object)"org").intValue()] = 0L;
                newValues[allIndex.get((Object)"bookstype").intValue()] = 0L;
                newValues[allIndex.get((Object)"curperiod").intValue()] = 0L;
                seqRows.add(newValues);
            }
        }
        DataSet ds = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(seqRows.iterator(), filterDs.getRowMeta());
        return ds;
    }

    static {
        cloumMap.put("status", kd.bos.dataentity.Tuple.create((Object)"status", String.class));
        cloumMap.put("checkitem", kd.bos.dataentity.Tuple.create((Object)"checkitem", String.class));
        cloumMap.put("dealfail", kd.bos.dataentity.Tuple.create((Object)"dealfail", String.class));
    }
}

