/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.closeperiod;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.constant.closeperiod.ClosePeriodInfo;
import kd.fi.gl.constant.closeperiod.ClosePeriodResultInfo;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.lock.Lock;
import kd.fi.gl.lock.LockKey;
import kd.fi.gl.util.GLUtil;

public class ClosePeriodTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(ClosePeriodTask.class);
    private final String closestate = "gl_closestate";
    private DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.periodClose);

    public MessageHandler getMessageHandle() {
        return null;
    }

    private void resetRequestContext(ClosePeriodInfo closeInfo) {
        try {
            String rc = closeInfo.getRequestContextStr();
            if (StringUtils.isNotBlank((CharSequence)rc)) {
                RequestContext currentRC = RequestContext.get();
                RequestContext originRC = (RequestContext)SerializationUtils.deSerializeFromBase64((String)rc);
                currentRC.setClient(originRC.getClient());
                currentRC.setLoginIP(originRC.getLoginIP());
            }
        }
        catch (Exception e) {
            log.error("resetRC error", (Throwable)e);
        }
    }

    public void execute(RequestContext requestContext, Map<String, Object> param) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u6b63\u5728\u7ed3\u8d26", (String)"ClosePeriodTask_0", (String)"fi-gl-report", (Object[])new Object[0]), null);
        String str = (String)param.get("closeInfo");
        ClosePeriodInfo closeInfo = null;
        try {
            closeInfo = (ClosePeriodInfo)JSONUtils.cast((String)str, ClosePeriodInfo.class);
        }
        catch (IOException e) {
            log.error((Throwable)e);
            throw new KDException(GLErrorCode.common, e.getMessage(), (Throwable)e);
        }
        if (closeInfo == null) {
            return;
        }
        this.resetRequestContext(closeInfo);
        List orgAndBookType = closeInfo.getOrgAndBookType();
        ArrayList<String> closeResult = new ArrayList<String>(orgAndBookType.size());
        for (int i = 0; i < orgAndBookType.size(); ++i) {
            DynamicObject bookDyn;
            if (this.isStop()) {
                this.stop();
            }
            String org2book = (String)orgAndBookType.get(i);
            String[] sp = org2book.split("_");
            Long orgId = Long.parseLong(sp[0]);
            Long bookTypeId = Long.parseLong(sp[1]);
            closeInfo.setOrgs(Collections.singletonList(orgId));
            closeInfo.setBooktype((Object)bookTypeId);
            QFilter filter = new QFilter("org", "=", (Object)orgId);
            if (kd.bos.util.StringUtils.isNotEmpty((String)closeInfo.getTypeFieldName())) {
                filter.and(closeInfo.getTypeFieldName(), "=", (Object)bookTypeId);
            }
            if ("gl_accountbook".equals(closeInfo.getFormId())) {
                filter.and("isbizunit", "=", (Object)"1").and("isendinit", "=", (Object)"1");
            }
            if ((bookDyn = QueryServiceHelper.queryOne((String)closeInfo.getFormId(), (String)"id, curperiod", (QFilter[])filter.toArray())) == null) {
                String[] errStr = new String[]{org2book, ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u6570\u636e\u3002", (String)"ClosePeriodTask_3", (String)"fi-gl-report", (Object[])new Object[0]), "0", ResManager.loadKDString((String)"\u8be5\u516c\u53f8\u5728\u6b64\u8d26\u7c3f\u7c7b\u578b\u4e0b\u65e0\u6570\u636e\u3002", (String)"ClosePeriodTask_4", (String)"fi-gl-report", (Object[])new Object[0])};
                ClosePeriodResultInfo closePeriodResultInfo = new ClosePeriodResultInfo(orgId, bookTypeId, Long.valueOf(Long.parseLong(closeInfo.getAwaitPeriodId().toString())), closeInfo.getRequestId(), closeInfo);
                this.createFailInfo(closeInfo, closePeriodResultInfo, errStr);
                closeResult.add(SerializationUtils.serializeToBase64((Object)closePeriodResultInfo));
                continue;
            }
            closeInfo.setCurPeriodId((Object)bookDyn.getLong("curperiod"));
            ClosePeriodInfo finalCloseInfo = closeInfo;
            int finalI = i;
            Lock.tryLock((long)orgId, (long)bookTypeId, (LockKey)LockKey.ClosePeriod, () -> {
                OperationResult result = null;
                OperateOption opt = OperateOption.create();
                opt.setVariableValue("reachperiod", finalCloseInfo.getAwaitPeriodId().toString());
                opt.setVariableValue("closeCacheKey", "CLOSE_PERIOD." + finalCloseInfo.getRequestId() + "_" + org2book);
                opt.setVariableValue("bizapp", finalCloseInfo.getBizapp());
                opt.setVariableValue("booktype", finalCloseInfo.getTypeFieldName());
                opt.setVariableValue("manual", "true");
                opt.setVariableValue("clientType", (String)param.get("clientType"));
                opt.setVariableValue("clientIP", (String)param.get("clientIP"));
                ClosePeriodResultInfo info = new ClosePeriodResultInfo(orgId, bookTypeId, Long.valueOf(Long.parseLong(finalCloseInfo.getAwaitPeriodId().toString())), finalCloseInfo.getRequestId(), finalCloseInfo);
                boolean isContinue = true;
                int j = 0;
                while (isContinue && j < 50) {
                    ++j;
                    long startTime = System.currentTimeMillis();
                    String closeEntity = "gl_accountbook".equalsIgnoreCase(finalCloseInfo.getFormId()) ? "gl_autocloseperiod" : finalCloseInfo.getFormId();
                    result = OperationServiceHelper.executeOperate((String)"closeperiod", (String)closeEntity, (Object[])new Object[]{bookDyn.getLong("id")}, (OperateOption)opt);
                    String reachPeriod = opt.getVariableValue("openedperiod", "0");
                    Long reachPeriodId = Long.valueOf(reachPeriod);
                    long endTime = System.currentTimeMillis();
                    log.info("ClosePeriodTask end......");
                    if (result.isSuccess()) {
                        this.getCloseInfoId(finalCloseInfo, result.getSuccessPkIds().get(0), orgId, bookTypeId, true);
                        if (this.isLessSlePeriod(orgId, bookTypeId, finalCloseInfo)) {
                            info.setSuccess(true);
                            isContinue = false;
                        } else if (j == 50) {
                            j = 0;
                        }
                        if (reachPeriodId > 0L) {
                            finalCloseInfo.setCurPeriodId((Object)reachPeriodId);
                            info.setReachPeriodId(reachPeriodId);
                        } else {
                            DynamicObject dyn = QueryServiceHelper.queryOne((String)finalCloseInfo.getFormId(), (String)"curperiod", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId).and(finalCloseInfo.getTypeFieldName(), "=", (Object)bookTypeId)});
                            finalCloseInfo.setCurPeriodId((Object)dyn.getLong("curperiod"));
                        }
                        this.getAndSaveDynamicObject(orgId, finalCloseInfo, "1", endTime - startTime, isContinue);
                        continue;
                    }
                    if (result.getSuccessPkIds().isEmpty() && result.getMessage() != null) {
                        this.createFailInfo(finalCloseInfo, info, null);
                        this.getAndSaveDynamicObject(orgId, finalCloseInfo, "2", endTime - startTime, isContinue);
                        break;
                    }
                    this.getCloseInfoId(finalCloseInfo, 0L, orgId, bookTypeId, false);
                    info.setSuccess(false);
                    isContinue = false;
                    if (reachPeriodId > 0L) {
                        finalCloseInfo.setCurPeriodId((Object)reachPeriodId);
                        info.setReachPeriodId(reachPeriodId);
                    }
                    this.getAndSaveDynamicObject(orgId, finalCloseInfo, "2", endTime - startTime, isContinue);
                }
                this.feedbackProgress((finalI + 1) * 100 / orgAndBookType.size(), ResManager.loadKDString((String)"\u6b63\u5728\u7ed3\u8d26", (String)"ClosePeriodTask_0", (String)"fi-gl-report", (Object[])new Object[0]), null);
                closeResult.add(SerializationUtils.serializeToBase64((Object)info));
            });
        }
        this.feedbackProgress(100, ResManager.loadKDString((String)"\u7ed3\u8d26\u5b8c\u6210", (String)"ClosePeriodTask_2", (String)"fi-gl-report", (Object[])new Object[0]), null);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String comst = JSONUtils.toString(closeResult);
            map.put("closeresult", comst);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        this.feedbackCustomdata(map);
    }

    private void getCloseInfoId(ClosePeriodInfo closeInfo, Object resultid, Long orgid, Long bookTypeId, boolean isSuccess) {
        DynamicObject previousPeriod;
        Object id = resultid;
        Long period = this.isHaveBook(orgid, bookTypeId, closeInfo, "curperiod");
        if (isSuccess && (previousPeriod = GLUtil.getPreviousPeriod((Object)period)) != null) {
            period = previousPeriod.getLong("id");
        }
        closeInfo.setCurPeriodId((Object)period);
        closeInfo.setCloseitemPK(id);
    }

    private Long isHaveBook(long org, Long bookTypeId, ClosePeriodInfo closeInfo, String select) {
        DynamicObjectCollection collection;
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("org", "=", (Object)org));
        if (bookTypeId != null) {
            list.add(new QFilter(closeInfo.getTypeFieldName(), "=", (Object)bookTypeId));
        }
        if ((collection = QueryServiceHelper.query((String)closeInfo.getFormId(), (String)select, (QFilter[])list.toArray(new QFilter[0]))).isEmpty()) {
            return 0L;
        }
        return ((DynamicObject)collection.get(0)).getLong(select);
    }

    public boolean isLessSlePeriod(long orgid, Long bookTypeId, ClosePeriodInfo closeInfo) {
        String currentPer = this.isHaveBook(orgid, bookTypeId, closeInfo, "curperiod") + "";
        currentPer = currentPer.substring(currentPer.length() - 8, currentPer.length() - 1);
        String selectPer = closeInfo.getAwaitPeriodId() + "";
        selectPer = selectPer.substring(selectPer.length() - 8, selectPer.length() - 1);
        return Integer.parseInt(currentPer) >= Integer.parseInt(selectPer);
    }

    private void createFailInfo(ClosePeriodInfo closeInfo, ClosePeriodResultInfo info, String[] str) {
        if (str != null) {
            long bookType;
            String org2book = str[0];
            long org = Long.parseLong(org2book.split("_")[0]);
            Long periodId = this.isHaveBook(org, bookType = Long.parseLong(org2book.split("_")[1]), closeInfo, "curperiod");
            if (periodId != 0L) {
                closeInfo.setCurPeriodId((Object)periodId);
            } else {
                closeInfo.setCurPeriodId(closeInfo.getAwaitPeriodId());
            }
            DynamicObject closecheck = BusinessDataServiceHelper.newDynamicObject((String)"bd_closecheckitem");
            closecheck.set("company", (Object)org);
            closecheck.set("period", closeInfo.getCurPeriodId());
            closecheck.set("subsysformnum", (Object)closeInfo.getFormId());
            closecheck.set("accountbooks", (Object)this.isHaveBook(org, bookType, closeInfo, "id"));
            DynamicObjectCollection entitys = closecheck.getDynamicObjectCollection("entryentity");
            DynamicObject entity = new DynamicObject(entitys.getDynamicObjectType());
            entity.set("checkitem", (Object)str[1]);
            entity.set("checkstate", (Object)str[2]);
            entity.set("formquery", null);
            entity.set("formnumber", null);
            entity.set("message", (Object)str[3]);
            entitys.add((Object)entity);
            this.cache.put("CLOSE_PERIOD." + closeInfo.getRequestId() + "_" + org2book, DataEntitySerializer.serializerToString((Object)closecheck));
            this.getAndSaveDynamicObject(org, closeInfo, "2", 0L, false);
        }
        closeInfo.setCloseitemPK((Object)0L);
        info.setSuccess(false);
    }

    private void getAndSaveDynamicObject(long companyid, ClosePeriodInfo closeInfo, String closestate, long time, boolean isContinue) {
        Long bookid = this.isHaveBook(companyid, closeInfo, "id");
        DynamicObject state = this.getParams(companyid, closeInfo, bookid);
        state.set("company", (Object)companyid);
        state.set("period", closeInfo.getCurPeriodId());
        state.set("subsysformnum", (Object)closeInfo.getFormId());
        state.set("accountbooks", (Object)bookid);
        state.set("thisclosetime", (Object)time);
        state.set("linestate", (Object)"0");
        state.set("closedate", (Object)new Date());
        state.set("closestate", (Object)closestate);
        if ("gl".equals(closeInfo.getBizapp())) {
            String closeUserId = RequestContext.getOrCreate().getUserId();
            state.set("closeuser", (Object)closeUserId);
        }
        try (TXHandle h = TX.requiresNew((String)"gl_subsystem_save");){
            try {
                DynamicObject[] save = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{state});
                log.info("\u6570\u636e\u4fdd\u5b58\u6210\u529f........");
                if (!isContinue) {
                    this.cache.put("genId" + closeInfo.getPageId(), save[0].getString("id"));
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private DynamicObject getParams(long companyid, ClosePeriodInfo closeInfo, long bookid) {
        QFilter org = new QFilter("company", "=", (Object)companyid);
        QFilter period = new QFilter("period", "=", closeInfo.getCurPeriodId());
        QFilter system = new QFilter("subsysformnum", "=", (Object)closeInfo.getFormId());
        QFilter accountbook = new QFilter("accountbooks", "=", (Object)String.valueOf(bookid));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"gl_closestate", (String)"id", (QFilter[])new QFilter[]{org, period, accountbook, system});
        if (!collection.isEmpty()) {
            if (collection.size() > 1) {
                Object[] o = new Object[collection.size()];
                for (int i = 1; i < collection.size(); ++i) {
                    o[i] = ((DynamicObject)collection.get(i)).getPkValue();
                }
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"gl_closestate"), (Object[])o);
            }
            return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)collection.get(0)).getLong("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_closestate"));
        }
        return BusinessDataServiceHelper.newDynamicObject((String)"gl_closestate");
    }

    private Long isHaveBook(long org, ClosePeriodInfo closeInfo, String select) {
        DynamicObjectCollection collection;
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("org", "=", (Object)org));
        if (closeInfo.getBooktype() != null) {
            list.add(new QFilter(closeInfo.getTypeFieldName(), "=", (Object)Long.valueOf(closeInfo.getBooktype().toString())));
        }
        if ((collection = QueryServiceHelper.query((String)closeInfo.getFormId(), (String)select, (QFilter[])list.toArray(new QFilter[0]))).isEmpty()) {
            return 0L;
        }
        return ((DynamicObject)collection.get(0)).getLong(select);
    }
}

