/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bd.util.AccountUtils;
import kd.fi.gl.dataset.TreeNode;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.common.IReportQuery;

public abstract class AbstractAccReportQuery
implements IReportQuery {
    private Map<Object, TreeNode> accMasterIdMap;
    private Map<Object, TreeNode> accIdMap;
    protected QueryParamRpt qpRpt;
    private Map<Object, TreeNode> allMasterIdMap = new HashMap<Object, TreeNode>(16);
    private Map<String, TreeNode> accNumIdMap;

    public AbstractAccReportQuery(QueryParamRpt qpRpt) {
        this.qpRpt = qpRpt;
        this.initAccount();
    }

    protected boolean isQueryAccount() {
        return true;
    }

    private void initAccount() {
        block39: {
            if (this.hasAccIdFilter()) {
                try (DataSet accDS = this.getAccountSet(AccountUtils.getBaseAcctFilter((Long)this.qpRpt.getEndPeriod(), (Long)this.qpRpt.getPorg(), (Long)this.qpRpt.getAccountTable(), (Set)this.qpRpt.getMasterIdSet(), (List)this.qpRpt.getAccountList()));){
                    HashSet<String> selAcctSet = new HashSet<String>(10);
                    for (Row row : accDS.copy()) {
                        selAcctSet.add(row.getString("number"));
                    }
                    try (DataSet childrenDS = AccountUtils.getAllLeafAcct(selAcctSet, (Long)this.qpRpt.getEndPeriod(), (Long)this.qpRpt.getPorg(), (Long)this.qpRpt.getAccountTable());){
                        this.setAccountMap(childrenDS);
                        break block39;
                    }
                }
            }
            QFilter atFilter = AccountUtils.getBaseAcctFilter((Long)this.qpRpt.getEndPeriod(), (Long)this.qpRpt.getPorg(), (Long)this.qpRpt.getAccountTable(), (Set)this.qpRpt.getMasterIdSet(), (List)this.qpRpt.getAccountList());
            try (DataSet accDS = this.getAccountSet(atFilter);){
                this.setAccountMap(accDS);
            }
        }
        if (this.qpRpt.getChildOrg().size() != 1 || this.qpRpt.getPorg() != ((Long)this.qpRpt.getChildOrg().iterator().next()).longValue()) {
            this.setSubAcctMap();
        }
    }

    private void setSubAcctMap() {
        HashSet<String> nums = new HashSet<String>(10);
        Set<Object> ids = this.accMasterIdMap.keySet();
        QFilter fmasterid = new QFilter("masterid", "in", ids);
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"enddate", (QFilter[])new QFilter("id", "=", (Object)this.qpRpt.getEndPeriod()).toArray());
        QFilter dateRangeF = new QFilter("startdate", "<=", (Object)period.getDate("enddate"));
        dateRangeF.and(new QFilter("enddate", ">=", (Object)period.getDate("enddate")));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"allnumber", (String)"bd_accountview", (String)"number", (QFilter[])new QFilter[]{fmasterid, dateRangeF}, (String)"number");){
            String str = "";
            for (Object row : ds) {
                String number = row.getString("number");
                if (StringUtils.isEmpty((String)str)) {
                    nums.add(number);
                    str = number;
                    continue;
                }
                if (number.equalsIgnoreCase(str) || number.startsWith(str)) continue;
                nums.add(number);
                str = number;
            }
        }
        HashMap<String, TreeNode> numTreeNode = new HashMap<String, TreeNode>(100);
        QFilter facctable = new QFilter("accounttable", "=", (Object)this.qpRpt.getAccountTable());
        DataSet ds = this.getAccountSet(facctable);
        Object object = null;
        try {
            for (Row row : ds) {
                long masterId;
                long id = row.getLong("id");
                if (id != (masterId = row.getLong("masterid").longValue())) continue;
                String number = row.getString("number");
                for (String num : nums) {
                    if (!number.startsWith(num)) continue;
                    TreeNode node = this.buildNode(row);
                    this.allMasterIdMap.put(id, node);
                    numTreeNode.put(number, node);
                }
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    ds.close();
                }
            }
        }
        for (Map.Entry<Object, TreeNode> entry : this.allMasterIdMap.entrySet()) {
            if (entry.getValue().getParentId() == 0L) continue;
            TreeNode node = null;
            String pnum = (String)entry.getValue().getPropValue("pnum");
            node = this.accNumIdMap.get(pnum) != null ? this.accNumIdMap.get(pnum) : (TreeNode)numTreeNode.get(pnum);
            entry.getValue().setParent(node);
        }
    }

    private TreeNode buildNode(Row row) {
        Long id = row.getLong("id");
        TreeNode node = new TreeNode(id.longValue());
        node.setMasterId(row.getLong("masterid").longValue());
        node.setParentId(row.getLong("parent").longValue());
        node.setPropValue("pnum", (Object)row.getString("pnum"));
        node.setPropValue("number", (Object)row.getString("number"));
        node.setPropValue("level", (Object)row.getInteger("level"));
        node.setPropValue("isleaf", (Object)row.getBoolean("isleaf"));
        node.setPropValue("dc", (Object)row.getString("dc"));
        node.setPropValue("isassist", (Object)row.getBoolean("isassist"));
        node.setPropValue("isqty", (Object)row.getBoolean("isqty"));
        return node;
    }

    private void setAccountMap(DataSet accDS) {
        this.accIdMap = new HashMap<Object, TreeNode>(10);
        this.accMasterIdMap = new HashMap<Object, TreeNode>(10);
        HashMap<String, TreeNode> numMap = new HashMap<String, TreeNode>(10);
        for (Row row : accDS) {
            Long id = row.getLong("id");
            TreeNode treeNode = this.buildNode(row);
            this.accIdMap.put(id, treeNode);
        }
        HashMap<Long, Boolean> hasAssistMap = new HashMap<Long, Boolean>(10);
        HashMap<Long, Boolean> hasQtyMap = new HashMap<Long, Boolean>(10);
        for (TreeNode treeNode : this.accIdMap.values()) {
            hasAssistMap.put(treeNode.getId(), (Boolean)treeNode.getPropValue("isassist"));
            hasQtyMap.put(treeNode.getId(), (Boolean)treeNode.getPropValue("isqty"));
            numMap.put((String)treeNode.getPropValue("number"), treeNode);
            this.accMasterIdMap.put(treeNode.getMasterId(), treeNode);
        }
        this.accNumIdMap = numMap;
        for (TreeNode treeNode : this.accIdMap.values()) {
            TreeNode parentNode = (TreeNode)numMap.get(treeNode.getPropValue("pnum"));
            treeNode.setParent(parentNode);
        }
        for (Map.Entry entry : this.accIdMap.entrySet()) {
            ((TreeNode)entry.getValue()).setPropValue("isLeafHasAssist", hasAssistMap.get(entry.getKey()));
            ((TreeNode)entry.getValue()).setPropValue("isLeafHasQty", hasQtyMap.get(entry.getKey()));
        }
    }

    private DataSet getAccountSet(QFilter filter) {
        return QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".account"), (String)"bd_accountview", (String)"id,masterid,parent.id parent,parent.number pnum,number,longnumber,level,isleaf,dc,isassist,isqty", (QFilter[])filter.toArray(), null);
    }

    private boolean hasAccIdFilter() {
        return this.qpRpt.getMasterIdSet() != null;
    }

    @Override
    public Map<Object, TreeNode> getMasterIdMap() {
        return this.accMasterIdMap;
    }

    @Override
    public Map<Object, TreeNode> getAllMasterIdMap() {
        return this.allMasterIdMap;
    }

    @Override
    public Map<String, TreeNode> getAccNumIdMap() {
        return this.accNumIdMap;
    }

    @Override
    public Map<Object, TreeNode> getIdMap() {
        return this.accIdMap;
    }

    @Override
    public QueryParamRpt getQueryParam() {
        return this.qpRpt;
    }
}

