/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.fi.gl.report.CurType;
import kd.fi.gl.report.OrgType;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.common.AbstractAccReportQuery;
import kd.fi.gl.report.common.DataSchema;
import kd.fi.gl.report.common.SumSchema;

public abstract class AbstractReportQuery
extends AbstractAccReportQuery {
    private SumSchema sumSchema;
    private RowMeta rowMeta;
    private String[] accGrp = new String[]{"account", "period"};
    private String[] curGrp = new String[]{"account", "currency"};
    private String[] curPeriodGrp = new String[]{"account", "currency", "period"};
    private String[] orgGrp = new String[]{"account", "currency", "org", "period"};
    private String[] leafGrp = new String[]{"account", "currency", "org", "assgrp", "measureunit", "period"};
    private String[] parentGrp = new String[]{"account", "currency", "org", "measureunit", "period"};

    public AbstractReportQuery(QueryParamRpt qpRpt) {
        super(qpRpt);
        this.initRowMeta();
        this.initSumSchema();
    }

    private DataSchema getTotalSchema() {
        String[] stringArray;
        boolean includeFor = this.isSumForAmt();
        if (includeFor) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "currency";
        } else {
            stringArray = new String[]{};
        }
        String[] groupBy = stringArray;
        String[] sumBy = this.getSumBy(includeFor, this.isSumLocalAmt(), false);
        return this.getDataSchema(groupBy, sumBy);
    }

    private void initSumSchema() {
        DataSchema leafSchema = this.getDataSchema(false);
        DataSchema parentSchema = this.getDataSchema(true);
        DataSchema totalSchema = this.getTotalSchema();
        this.sumSchema = new SumSchema(leafSchema, parentSchema, totalSchema);
    }

    private DataSchema getDataSchema(boolean isParent) {
        DataSchema leafSchema = this.put(null, isParent ? this.getParentLeafSchema() : this.getLeafSchema());
        leafSchema = this.put(leafSchema, this.getOrgSchema());
        leafSchema = this.put(leafSchema, this.getCurSchema());
        leafSchema = this.put(leafSchema, this.getAccountSchema());
        return leafSchema;
    }

    private DataSchema put(DataSchema result, DataSchema input) {
        if (result == null) {
            result = input;
        } else {
            result.setParent(input);
        }
        return result;
    }

    private DataSchema getAccountSchema() {
        boolean includeFor = this.isSumForAmt();
        String[] groupBy = !includeFor ? this.accGrp : (this.qpRpt.isShowPeriod() ? this.curPeriodGrp : this.curGrp);
        String[] sumBy = this.getSumBy(includeFor, this.isSumLocalAmt(), false);
        return this.getDataSchema(groupBy, sumBy);
    }

    private DataSchema getCurSchema() {
        if (!this.sumUpCur()) {
            return null;
        }
        String[] sumBy = this.getSumBy(true, this.isSumLocalAmt(), false);
        String[] groupList = this.qpRpt.isShowPeriod() ? this.curPeriodGrp : this.curGrp;
        return this.getDataSchema(groupList, sumBy);
    }

    private DataSchema getOrgSchema() {
        if (!this.sumUpOrg()) {
            return null;
        }
        String[] sumBy = this.getSumBy(true, true, false);
        String[] groupList = this.orgGrp;
        return this.getDataSchema(groupList, sumBy);
    }

    private DataSchema getLeafSchema() {
        if (!this.sumUpLeaf()) {
            return null;
        }
        String[] sumBy = this.getSumBy(true, this.qpRpt.isShowOrg() || this.isSumLocalAmt() || this.qpRpt.isShowOrgTree(), true);
        String[] groupList = this.addComAssistList(this.leafGrp);
        return this.getDataSchema(groupList, sumBy);
    }

    private DataSchema getParentLeafSchema() {
        if (!this.qpRpt.isShowQty()) {
            return null;
        }
        String[] sumBy = this.getSumBy(true, this.qpRpt.isShowOrg() || this.isSumLocalAmt() || this.qpRpt.isShowOrgTree(), true);
        String[] groupList = this.parentGrp;
        return this.getDataSchema(groupList, sumBy);
    }

    private String[] getSumBy(boolean includeFor, boolean includeLocal, boolean includeQty) {
        String str = this.getCountField();
        if (includeFor) {
            str = str + "," + this.getAmountField().replace("#", "for");
        }
        if (includeLocal) {
            str = str + "," + this.getAmountField().replace("#", "local");
        }
        if (includeQty) {
            str = str + "," + this.getAmountField().replace("#", "qty");
        }
        if (this.qpRpt.isShowRpt()) {
            str = str + "," + this.getAmountField().replace("#", "rpt");
        }
        return str.split(",");
    }

    private boolean isSumLocalAmt() {
        return this.qpRpt.getOrgType() != OrgType.VIRTUAL_M;
    }

    private boolean isSumForAmt() {
        return this.qpRpt.getCurType() == CurType.FOREIGN || this.qpRpt.getCurType() == CurType.BASE;
    }

    private DataSchema getDataSchema(String[] groupBy, String[] sumBy) {
        return DataSchema.getDataSchema(groupBy, sumBy, this.getRowMeta());
    }

    private String[] addComAssistList(String[] groupBy) {
        if (this.qpRpt.getFilterInfo().getBoolean("showcomassist")) {
            List<String> comAssistList = Arrays.stream(groupBy).collect(Collectors.toList());
            this.qpRpt.getComAssistValsList().stream().forEach(x -> comAssistList.add((String)x.t1));
            groupBy = comAssistList.toArray(new String[comAssistList.size()]);
        }
        return groupBy;
    }

    private boolean sumUpLeaf() {
        return this.qpRpt.isShowAssist() || this.qpRpt.isShowQty() || this.qpRpt.isShowPeriod() || this.qpRpt.isShowComassist();
    }

    private boolean sumUpOrg() {
        return this.qpRpt.isShowOrg() || this.qpRpt.isShowOrgTree();
    }

    private boolean sumUpCur() {
        return this.qpRpt.isShowCurrency();
    }

    private void initRowMeta() {
        List<Field> fieldList = this.getGroupFields();
        for (String ct : this.getCountField().split(",")) {
            fieldList.add(new Field(ct, (DataType)DataType.IntegerType));
        }
        ArrayList amountField = new ArrayList();
        String[] amountLocals = this.getAmountField().replace("#", "local").split(",");
        Collections.addAll(amountField, amountLocals);
        if (this.qpRpt.isQueryCurrency()) {
            String[] amountFors = this.getAmountField().replace("#", "for").split(",");
            Collections.addAll(amountField, amountFors);
        }
        if (this.qpRpt.isShowQty()) {
            String[] amountQtys = this.getAmountField().replace("#", "qty").split(",");
            Collections.addAll(amountField, amountQtys);
        }
        if (this.qpRpt.isShowRpt()) {
            String[] amountQtys = this.getAmountField().replace("#", "rpt").split(",");
            Collections.addAll(amountField, amountQtys);
        }
        for (String amount : amountField) {
            fieldList.add(new Field(amount, (DataType)DataType.BigDecimalType));
        }
        this.rowMeta = new RowMeta(fieldList.toArray(new Field[0]));
    }

    private List<Field> getGroupFields() {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        fieldList.add(new Field("account", (DataType)DataType.LongType));
        if (this.qpRpt.isQueryCurrency()) {
            fieldList.add(new Field("currency", (DataType)DataType.LongType));
        }
        if (!this.qpRpt.getComAssistValsList().isEmpty()) {
            this.qpRpt.getComAssistValsList().stream().forEach(x -> fieldList.add(new Field((String)x.t1, (DataType)DataType.LongType)));
        }
        if (this.qpRpt.isShowOrg() || this.qpRpt.isShowOrgTree()) {
            fieldList.add(new Field("org", (DataType)DataType.LongType));
        }
        if (this.qpRpt.isShowAssist()) {
            fieldList.add(new Field("assgrp", (DataType)DataType.LongType));
        }
        if (this.qpRpt.isShowQty()) {
            fieldList.add(new Field("measureunit", (DataType)DataType.LongType));
        }
        if (this.qpRpt.isShowPeriod()) {
            fieldList.add(new Field("period", (DataType)DataType.LongType));
        }
        return fieldList;
    }

    @Override
    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    @Override
    public String[] getGroupByFields() {
        return (String[])this.getGroupFields().stream().map(Field::getName).toArray(String[]::new);
    }

    @Override
    public SumSchema getSumSchema() {
        return this.sumSchema;
    }

    protected abstract String getAmountField();

    protected abstract String getCountField();

    protected abstract boolean isQueryCount();
}

