/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.common;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.fi.gl.dataset.TreeNode;
import kd.fi.gl.report.DailyRptQueryParam;
import kd.fi.gl.report.common.CollectorParam;
import kd.fi.gl.report.common.DataFetchFunction;
import kd.fi.gl.vo.RateBean;

public class BalanceFetchFunction
implements DataFetchFunction {
    private final int resultSize;
    private final int grpSize;
    private final long periodId;
    private final int inputOrgIndex;
    private final Map<Object, TreeNode> accMasterIdMap;
    private Map<Long, RateBean> orgRateMap;
    private final DailyRptQueryParam qpRpt;
    private final int preDebitLocalIndex;
    private final int preDebitForIndex;
    private final int preDebitQtyIndex;
    private final int preDebitRptIndex;
    private final int preCreditLocalIndex;
    private final int preCreditForIndex;
    private final int preCreditQtyIndex;
    private final int preCreditRptIndex;
    private final int toDebitLocalIndex;
    private final int toDebitForIndex;
    private final int toDebitQtyIndex;
    private final int toDebitRptIndex;
    private final int toCreditLocalIndex;
    private final int toCreditForIndex;
    private final int toCreditQtyIndex;
    private final int toCreditRptIndex;
    private final int periodIndex;
    private final int beginLocalIndex;
    private final int beginForIndex;
    private final int beginQtyIndex;
    private final int endLocalIndex;
    private final int endForIndex;
    private final int endQtyIndex;
    private RateBean rate;
    private long rowPeriod;
    private Object[] result;
    private TreeNode node;
    private String accDc;
    private BigDecimal temp;

    public BalanceFetchFunction(CollectorParam param, Map<Object, TreeNode> accMasterIdMap, RowMeta inputRowMeta) {
        this.resultSize = param.getRowMeta().getFieldCount();
        this.accMasterIdMap = accMasterIdMap;
        this.qpRpt = (DailyRptQueryParam)param.getParam();
        String[] grpFields = (String[])this.qpRpt.getCustomParam("groupByFields");
        this.periodId = this.qpRpt.getPeriodId();
        this.grpSize = grpFields.length;
        if (this.qpRpt.isShowRpt()) {
            this.orgRateMap = this.qpRpt.getOrgRateMap();
        }
        RowMeta outPutRowMeta = param.getRowMeta();
        this.preDebitLocalIndex = outPutRowMeta.getFieldIndex("predebitlocal", false);
        this.preDebitForIndex = outPutRowMeta.getFieldIndex("predebitfor", false);
        this.preDebitQtyIndex = outPutRowMeta.getFieldIndex("predebitqty", false);
        this.preDebitRptIndex = outPutRowMeta.getFieldIndex("predebitrpt", false);
        this.preCreditLocalIndex = outPutRowMeta.getFieldIndex("precreditlocal", false);
        this.preCreditForIndex = outPutRowMeta.getFieldIndex("precreditfor", false);
        this.preCreditQtyIndex = outPutRowMeta.getFieldIndex("precreditqty", false);
        this.preCreditRptIndex = outPutRowMeta.getFieldIndex("precreditrpt", false);
        this.toDebitLocalIndex = outPutRowMeta.getFieldIndex("todebitlocal", false);
        this.toDebitForIndex = outPutRowMeta.getFieldIndex("todebitfor", false);
        this.toDebitQtyIndex = outPutRowMeta.getFieldIndex("todebitqty", false);
        this.toDebitRptIndex = outPutRowMeta.getFieldIndex("todebitrpt", false);
        this.toCreditLocalIndex = outPutRowMeta.getFieldIndex("tocreditlocal", false);
        this.toCreditForIndex = outPutRowMeta.getFieldIndex("tocreditfor", false);
        this.toCreditQtyIndex = outPutRowMeta.getFieldIndex("tocreditqty", false);
        this.toCreditRptIndex = outPutRowMeta.getFieldIndex("tocreditrpt", false);
        this.periodIndex = inputRowMeta.getFieldIndex("period", false);
        this.beginLocalIndex = inputRowMeta.getFieldIndex("beginlocal", false);
        this.beginForIndex = inputRowMeta.getFieldIndex("beginfor", false);
        this.beginQtyIndex = inputRowMeta.getFieldIndex("beginqty", false);
        this.endLocalIndex = inputRowMeta.getFieldIndex("endlocal", false);
        this.endForIndex = inputRowMeta.getFieldIndex("endfor", false);
        this.endQtyIndex = inputRowMeta.getFieldIndex("endqty", false);
        this.inputOrgIndex = inputRowMeta.getFieldIndex("orgid", false);
    }

    @Override
    public Object[] fetch(Row row) {
        this.result = new Object[this.resultSize];
        this.rowPeriod = row.getLong(this.periodIndex);
        for (int i = 0; i < this.grpSize; ++i) {
            this.result[i] = row.get(i);
        }
        this.node = this.accMasterIdMap.get(row.get(0));
        if (this.node == null) {
            return null;
        }
        this.accDc = (String)this.node.getPropValue("dc");
        this.temp = this.periodId == this.rowPeriod ? row.getBigDecimal(this.beginLocalIndex) : row.getBigDecimal(this.endLocalIndex);
        this.result[this.preDebitLocalIndex] = "1".equals(this.accDc) ? this.temp : BigDecimal.ZERO;
        this.result[this.preCreditLocalIndex] = "1".equals(this.accDc) ? BigDecimal.ZERO : this.temp.negate();
        this.result[this.toDebitLocalIndex] = this.result[this.preDebitLocalIndex];
        this.result[this.toCreditLocalIndex] = this.result[this.preCreditLocalIndex];
        if (this.qpRpt.isQueryCurrency()) {
            this.temp = this.periodId == this.rowPeriod ? row.getBigDecimal(this.beginForIndex) : row.getBigDecimal(this.endForIndex);
            this.result[this.preDebitForIndex] = "1".equals(this.accDc) ? this.temp : BigDecimal.ZERO;
            this.result[this.preCreditForIndex] = "1".equals(this.accDc) ? BigDecimal.ZERO : this.temp.negate();
            this.result[this.toDebitForIndex] = this.result[this.preDebitForIndex];
            this.result[this.toCreditForIndex] = this.result[this.preCreditForIndex];
        }
        if (this.qpRpt.isShowQty()) {
            this.temp = this.periodId == this.rowPeriod ? row.getBigDecimal(this.beginQtyIndex) : row.getBigDecimal(this.endQtyIndex);
            this.result[this.preDebitQtyIndex] = "1".equals(this.accDc) ? this.temp : BigDecimal.ZERO;
            this.result[this.preCreditQtyIndex] = "1".equals(this.accDc) ? BigDecimal.ZERO : this.temp.negate();
            this.result[this.toDebitQtyIndex] = this.result[this.preDebitQtyIndex];
            this.result[this.toCreditQtyIndex] = this.result[this.preCreditQtyIndex];
        }
        if (this.qpRpt.isShowRpt()) {
            this.rate = this.orgRateMap.get(row.getLong(this.inputOrgIndex));
            this.result[this.preDebitRptIndex] = this.rate.isDirect() ? ((BigDecimal)this.result[this.preDebitLocalIndex]).multiply(this.rate.getRateVal()) : ((BigDecimal)this.result[this.preDebitLocalIndex]).divide(this.rate.getRateVal(), this.rate.getPrecision(), RoundingMode.HALF_UP);
            this.result[this.preCreditRptIndex] = this.rate.isDirect() ? ((BigDecimal)this.result[this.preCreditLocalIndex]).multiply(this.rate.getRateVal()) : ((BigDecimal)this.result[this.preCreditLocalIndex]).divide(this.rate.getRateVal(), this.rate.getPrecision(), RoundingMode.HALF_UP);
            this.result[this.toDebitRptIndex] = this.result[this.preDebitRptIndex];
            this.result[this.toCreditRptIndex] = this.result[this.preCreditRptIndex];
        }
        return this.result;
    }
}

