/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.fiilter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.fi.gl.dataset.GroupKey;

public class ReportGroupFilter {
    private final List<String> groupFields;
    private final Set<IGroupFilterFunction> filters = new HashSet<IGroupFilterFunction>();
    private List<Integer> grpIndexes;

    public ReportGroupFilter(List<String> groupFields) {
        this.groupFields = new ArrayList<String>(groupFields);
    }

    public void addFilterFunction(IGroupFilterFunction f) {
        this.filters.add(f);
    }

    public DataSet doFilter(DataSet ds) {
        if (!this.filters.isEmpty()) {
            RowMeta rowMeta = ds.getRowMeta();
            this.grpIndexes = this.groupFields.stream().map(f -> rowMeta.getFieldIndex(f, false)).filter(i -> i != -1).collect(Collectors.toList());
            final HashSet remainedGKs = new HashSet();
            ds.copy().forEach(row -> {
                GroupKey groupKey = this.getGroupKey((Row)row);
                boolean needRemained = false;
                if (!remainedGKs.contains(groupKey)) {
                    needRemained = this.filters.stream().filter(filter -> filter.isCharacteristicRow((Row)row)).anyMatch(filter -> filter.needRemain((Row)row));
                }
                if (needRemained) {
                    remainedGKs.add(groupKey);
                }
            });
            FilterFunction f2 = new FilterFunction(){

                public boolean test(Row row) {
                    return remainedGKs.contains(ReportGroupFilter.this.getGroupKey(row));
                }
            };
            ds = ds.filter(f2);
        }
        return ds;
    }

    private GroupKey getGroupKey(Row row) {
        Object[] groupKeys = new Object[this.grpIndexes.size()];
        for (int i = 0; i < this.grpIndexes.size(); ++i) {
            groupKeys[i] = row.get(this.grpIndexes.get(i).intValue());
        }
        return new GroupKey(groupKeys);
    }

    public static interface IGroupFilterFunction {
        public boolean needRemain(Row var1);

        public boolean isCharacteristicRow(Row var1);
    }
}

