/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.qing.util;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.qing.QingLinkageInfo;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.report.ReportShowParameter;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.DebugTraceHelper;
import kd.fi.gl.report.NavToAssRpt;
import kd.fi.gl.report.NavToSubLedgerRpt;

public class QingBalanceLinkUtils {
    public static final String UNIQUE_ID = "AccBalQingDataProvider_id";
    private static final List<String> UNIQUE_KEYS = ImmutableList.of((Object)"org", (Object)"account", (Object)"assgrp", (Object)"currency", (Object)"measureunit");

    public static List<QingLinkageInfo> getLinkageInfo(String pageId, String ctrKey) {
        String[] linkReport;
        ArrayList<QingLinkageInfo> result = new ArrayList<QingLinkageInfo>(2);
        for (String reportId : linkReport = new String[]{"gl_rpt_subledger", "gl_rpt_subsidiaryledger"}) {
            QingLinkageInfo info = new QingLinkageInfo();
            LinkedHashMap<String, String> formKey = new LinkedHashMap<String, String>(4);
            formKey.put("AppId", AppMetadataCache.getAppInfo((String)"gl").getId());
            formKey.put("FormId", reportId);
            formKey.put("System", "IERP");
            formKey.put("CtrKey", ctrKey);
            info.setFormKey(JSONObject.toJSONString(formKey));
            info.setFormDisplayName(EntityMetadataCache.getDataEntityType((String)reportId).getDisplayName().toString());
            info.setFormPrimaryKey(UNIQUE_ID);
            result.add(info);
        }
        return result;
    }

    public static void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId, ReportQueryParam queryParam, IFormView view) {
        DebugTraceHelper.logInfo((String)"AccBalQingDataProvider#fireLinkageInfo is invoked, linkids:{}", (Object[])new Object[]{ids});
        String isMethodInvoke = view.getPageCache().get("fireQingLinkageByMethodInvoke");
        FilterInfo filterInfo = queryParam.getFilter();
        Multimap<String, Long> multimap = QingBalanceLinkUtils.convertToMap(ids);
        boolean isSingleLeafQuery = CollectionUtils.isEmpty((Collection)multimap.get((Object)"org"));
        ArrayList linkageOrgs = isSingleLeafQuery ? filterInfo.getDynamicObjectCollection("orgs").stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList()) : new ArrayList(multimap.get((Object)"org"));
        Collection accountIds = multimap.get((Object)"account");
        Collection assgrpIds = multimap.get((Object)"assgrp");
        Long currencyId = multimap.get((Object)"currency").size() == 1 ? (Long)multimap.get((Object)"currency").iterator().next() : Long.valueOf(0L);
        ReportShowParameter param = null;
        switch (formId) {
            case "gl_rpt_subledger": {
                param = new NavToSubLedgerRpt.SLBuilder(queryParam, view).orgIds(linkageOrgs).accountIds(accountIds).currencyId(currencyId).build().initShowParameter();
                if (Boolean.parseBoolean(isMethodInvoke)) {
                    view.showForm((FormShowParameter)param);
                    break;
                }
                view.setClientReturnData((Object)ReportShowParameter.toJsonString((FormShowParameter)param));
                break;
            }
            case "gl_rpt_subsidiaryledger": {
                if (CollectionUtils.isEmpty((Collection)assgrpIds) || assgrpIds.stream().allMatch(assgrpId -> assgrpId == 0L)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u884c\u4e0d\u5b58\u5728\u6838\u7b97\u7ef4\u5ea6\uff0c\u65e0\u6cd5\u8054\u67e5\u8f85\u52a9\u660e\u7ec6\u8d26\u3002", (String)"QingBalanceLinkUtils_0", (String)"fi-gl-report", (Object[])new Object[0]));
                    return;
                }
                String mulcur = filterInfo.getString("mulcur");
                if (!Objects.isNull(mulcur) && !Objects.equals(mulcur, "LocalCurrency") && linkageOrgs.size() > 1) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u591a\u672c\u4f4d\u5e01\u8054\u67e5\u591a\u7ec4\u7ec7\u8f85\u52a9\u660e\u7ec6\u8d26\u3002", (String)"QingBalanceLinkUtils_1", (String)"fi-gl-report", (Object[])new Object[0]));
                    return;
                }
                param = new NavToAssRpt.Builder(queryParam, view).orgIds(linkageOrgs).accountIds(accountIds).currencyId(currencyId).assgrpIds(assgrpIds).navKey(linkageOrgs.size() == 1 ? "gl_rpt_subsidiaryledger" : "t_rpt_aux_subledger").build().initShowParameter();
                if (Boolean.parseBoolean(isMethodInvoke)) {
                    view.showForm((FormShowParameter)param);
                    break;
                }
                view.setClientReturnData((Object)ReportShowParameter.toJsonString((FormShowParameter)param));
                break;
            }
        }
    }

    public static DataSet addIdField(DataSet dataSet) {
        ImmutableSet fieldNames = ImmutableSet.copyOf((Object[])dataSet.getRowMeta().getFieldNames());
        String expr = QingBalanceLinkUtils.buildIdExpr((Set<String>)fieldNames);
        return dataSet.addField(expr, UNIQUE_ID);
    }

    private static String buildIdExpr(Set<String> fieldNames) {
        StringJoiner joiner = new StringJoiner(" + '-' + ");
        for (String uniqueKey : UNIQUE_KEYS) {
            joiner.add(QingBalanceLinkUtils.castToStringExprOrEmpty(uniqueKey, fieldNames));
        }
        return joiner.toString();
    }

    private static String castToStringExprOrEmpty(String field, Set<String> fieldNames) {
        return fieldNames.contains(field) ? String.format("CAST(%s AS STRING)", field) : "''";
    }

    private static Multimap<String, Long> convertToMap(List<String> ids) {
        return (Multimap)ids.stream().collect(Collector.of(HashMultimap::create, (map, id) -> {
            String[] idArray = id.split("-", Integer.MAX_VALUE);
            for (int i = 0; i < UNIQUE_KEYS.size(); ++i) {
                if (!StringUtils.isNotEmpty((CharSequence)idArray[i])) continue;
                map.put((Object)UNIQUE_KEYS.get(i), (Object)Long.parseLong(idArray[i]));
            }
        }, (m1, m2) -> {
            m1.putAll((Multimap)m2);
            return m1;
        }, new Collector.Characteristics[0]));
    }
}

