/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.FlexUtils;
import kd.fi.gl.business.service.PeriodService;
import kd.fi.gl.report.service.IReportAccountService;
import kd.fi.gl.util.GLUtil;

public class ReportAccountServiceImpl
implements IReportAccountService {
    private static final String ALIA_LONG_NUM = "lnum";

    @Override
    public DataSet queryAccountData(List<Long> org, long acctTable, long endPeriod, String selectFields, Set<String> acctLongNumRange, QFilter extFilter) {
        boolean largeNumSelected;
        if (CollectionUtils.isEmpty(org)) {
            return GLUtil.getEmptyDS(ReportAccountServiceImpl.class);
        }
        Date useDate = PeriodService.getEndDate((long)endPeriod);
        QFilter dateF = new QFilter("startdate", "<=", (Object)useDate).and(new QFilter("enddate", ">=", (Object)useDate));
        boolean bl = largeNumSelected = acctLongNumRange != null && acctLongNumRange.size() > 30;
        if (acctLongNumRange != null && acctLongNumRange.size() > 0 && !largeNumSelected) {
            QFilter numF = QFilter.of((String)acctLongNumRange.stream().map(num -> "longnumber like '" + num + "%' ").collect(Collectors.joining(" or ")), (Object[])new Object[0]);
            dateF.and(numF);
        }
        dateF.and(extFilter);
        DataSet acctDs = AccountUtils.queryAccountDataSet(new HashSet<Long>(org), (long)acctTable, (String)String.format("longnumber %s, %s", ALIA_LONG_NUM, selectFields), (List)Lists.newArrayList((Object[])new QFilter[]{dateF}), null);
        if (largeNumSelected) {
            acctDs = this.filterChildAccount(acctDs, acctLongNumRange);
        }
        return acctDs;
    }

    @Override
    public DataSet queryAccountByAssistItems(List<Long> org, long acctTable, long endPeriod, String selectFields, Set<String> acctLongNumRange, List<String> flexFields, QFilter extFilter) {
        int filterIndex = 0;
        for (Long flexItemId : this.flexField2AssistItemId(flexFields)) {
            String alias = "assist_x" + filterIndex++;
            QFilter filter = QFilter.joinSQL((String)"bd_accountview", (String)String.format("inner join T_BD_AccountAsstActItem %1$s on %1$s.fid = bd_accountview.fid and %1$s.fasstactitemid=?", alias), (Object[])new Object[]{flexItemId});
            if (extFilter == null) {
                extFilter = filter;
                continue;
            }
            extFilter.and(filter);
        }
        return this.queryAccountData(org, acctTable, endPeriod, selectFields, acctLongNumRange, extFilter);
    }

    List<Long> flexField2AssistItemId(List<String> flexFields) {
        Map propMap = FlexUtils.batchGetFlexProperty((String[])flexFields.toArray(new String[0]));
        return flexFields.stream().map(propMap::get).map(FlexProperty::getId).collect(Collectors.toList());
    }

    DataSet filterChildAccount(DataSet acctDs, final Set<String> longNums) {
        return acctDs.filter(new FilterFunction(){
            private static final long serialVersionUID = 2500000498865491271L;

            public boolean test(Row row) {
                String longNum = row.getString(ReportAccountServiceImpl.ALIA_LONG_NUM);
                return ReportAccountServiceImpl.getAllSuperLongNum(longNum, '_').stream().anyMatch(longNums::contains);
            }
        });
    }

    public static List<String> getAllSuperLongNum(String fullNum, char splitChar) {
        char[] chars = fullNum.toCharArray();
        ArrayList<String> fullNums = new ArrayList<String>(4);
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != splitChar) continue;
            fullNums.add(fullNum.substring(0, i));
        }
        fullNums.add(fullNum);
        return fullNums;
    }

    public static Set<Long> getLongs(DataSet ds, String aliaId) {
        HashSet<Long> ids = new HashSet<Long>(128);
        ds.forEach(r -> ids.add(r.getLong(aliaId)));
        return ids;
    }
}

