/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.common.ISelector;
import kd.fi.gl.report.common.OutPutFunction;
import kd.fi.gl.report.subledger.SubLedgerPLVouFunction;
import kd.fi.gl.report.subledger.SubLedgerReportQuery;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.MulCurReportUtil;

public class SubLedgerPLVouSelector
implements ISelector {
    private QueryParamRpt qpRpt;
    private String selField;
    private List<String> queryField;
    private QFilter[] qFilters;
    private SubLedgerReportQuery reportQuery;
    private SubLedgerPLVouFunction outPutFunction;
    private int orgIndex;
    private List<Integer> comAssistIndexer;
    private int accountIndex;
    private int bookDateIndex;
    private int bizDateIndex;
    private int vouNoIndex;
    private int vouTypeIndex;
    private int descIndex;
    private int vouIdIndex;
    private int vouEntryIdIndex;
    private static final String FENTRY_ID = "fentryid";
    private int currencyIndex;
    private int assgrpIndex;
    private int measureunitIndex;
    private int entryDcIndex;
    private int[] debitIndexes;
    private int[] creditIndexes;
    private int periodIndex;
    private int seqIndex;
    private QFilter voucherFilter;

    public SubLedgerPLVouSelector(SubLedgerReportQuery reportQuery, QFilter voucherFilter) {
        this.voucherFilter = voucherFilter;
        this.reportQuery = reportQuery;
        this.qpRpt = reportQuery.getQueryParam();
        this.selField = this.initSel();
        this.qFilters = this.initQFilters();
        this.outPutFunction = new SubLedgerPLVouFunction(this);
        this.initIndexes();
    }

    private void initIndexes() {
        this.orgIndex = this.queryField.indexOf("org");
        this.comAssistIndexer = this.qpRpt.getCommonAssists().stream().map(comAssist -> this.queryField.indexOf(comAssist.key)).collect(Collectors.toList());
        this.accountIndex = this.queryField.indexOf("account");
        this.bookDateIndex = this.queryField.indexOf("bookeddate");
        this.bizDateIndex = this.queryField.indexOf("bizdate");
        this.vouNoIndex = this.queryField.indexOf("billno");
        this.vouTypeIndex = this.queryField.indexOf("vouchertype");
        this.descIndex = this.queryField.indexOf("edescription");
        this.vouIdIndex = this.queryField.indexOf("id");
        this.vouEntryIdIndex = this.queryField.indexOf(FENTRY_ID);
        this.currencyIndex = this.queryField.indexOf("currency");
        this.assgrpIndex = this.queryField.indexOf("assgrp");
        this.measureunitIndex = this.queryField.indexOf("measureunit");
        this.entryDcIndex = this.queryField.indexOf("entrydc");
        this.debitIndexes = this.setIndexes("debit");
        this.creditIndexes = this.setIndexes("credit");
        this.periodIndex = this.queryField.indexOf("period");
        this.seqIndex = this.queryField.indexOf("seq");
    }

    private int[] setIndexes(String flag) {
        ArrayList<Integer> list = new ArrayList<Integer>(8);
        for (String field : this.merge(flag)) {
            list.add(this.queryField.indexOf(field));
        }
        return list.stream().mapToInt(x -> x).toArray();
    }

    private String[] merge(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        for (String pre : prefix.split(",")) {
            for (String suf : this.reportQuery.getOutPutIndex().getTypes().split(",")) {
                list.add(pre + suf);
            }
        }
        return list.toArray(new String[0]);
    }

    private String initSel() {
        ArrayList<String> sel = new ArrayList<String>(16);
        sel.add("id");
        sel.add("billno");
        sel.add("vouchertype");
        sel.add("bookeddate");
        sel.add("bizdate");
        sel.add("period");
        sel.add(String.join((CharSequence)"", "entries", ".", "id", " ", FENTRY_ID));
        sel.add(String.join((CharSequence)"", "entries", ".", "edescription", " ", "edescription"));
        sel.add(String.join((CharSequence)"", "entries", ".", "account", " ", "account"));
        sel.add("org");
        this.qpRpt.getCommonAssists().forEach(commonAssist -> sel.add("entries." + commonAssist.key + " " + commonAssist.key));
        if (this.qpRpt.isQueryCurrency()) {
            sel.add(String.join((CharSequence)"", "entries", ".", "currency", " ", "currency"));
        }
        if (this.qpRpt.isShowAssist()) {
            sel.add(String.join((CharSequence)"", "entries", ".", "assgrp", " ", "assgrp"));
        }
        if (this.qpRpt.isShowQty()) {
            sel.add(String.join((CharSequence)"", "entries", ".", "measureunit", " ", "measureunit"));
        }
        sel.addAll(MulCurReportUtil.getVoucherLocalAmountFields3((String)this.qpRpt.getLocaleCurType()));
        if (this.qpRpt.isQueryCurrency()) {
            sel.add(String.join((CharSequence)"", "entries", ".", "debitori", " ", "debitfor"));
            sel.add(String.join((CharSequence)"", "entries", ".", "creditori", " ", "creditfor"));
        }
        sel.add(String.join((CharSequence)"", "entries", ".", "entrydc", " ", "entrydc"));
        if (this.qpRpt.isShowQty()) {
            sel.add(String.join((CharSequence)"", "entries", ".", "quantity", " ", "debitqty"));
            sel.add(String.join((CharSequence)"", "entries", ".", "quantity", " ", "creditqty"));
        }
        if (this.qpRpt.isShowPrice()) {
            sel.add(String.join((CharSequence)"", "entries", ".", "price", " ", "debitprice"));
            sel.add(String.join((CharSequence)"", "entries", ".", "price", " ", "creditprice"));
        }
        sel.add(String.join((CharSequence)"", "entries", ".", "seq", " ", "seq"));
        this.queryField = new ArrayList<String>();
        for (String s : sel) {
            String[] split = s.split(" ");
            if (split.length == 1) {
                this.queryField.add(split[0]);
                continue;
            }
            this.queryField.add(split[1]);
        }
        return ((Object)sel).toString().replace("[", "").replace("]", "");
    }

    private QFilter[] initQFilters() {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("org", "in", (Object)this.qpRpt.getAllEntityOrgs()));
        list.add(new QFilter("booktype", "=", (Object)this.qpRpt.getBookType()));
        list.addAll(this.qpRpt.getComAssistFiltersForBill(key -> "entries." + key));
        list.add(new QFilter("period", ">=", GLUtil.getCurYearMinPeriod((Object)this.qpRpt.getStartPeriod()).getPkValue()));
        list.add(new QFilter("period", "<", (Object)this.qpRpt.getStartPeriod()));
        list.add(new QFilter("billstatus", "in", (Object)new String[]{"B", "C"}));
        list.add(new QFilter("sourcetype", "=", (Object)"1"));
        list.add(new QFilter("entries.account", "in", this.reportQuery.getAllQueryIds()));
        if (!this.qpRpt.isSynCurrency() && !this.qpRpt.isAllCurrency()) {
            list.add(new QFilter("entries.currency", "=", (Object)this.qpRpt.getCurrency()));
        }
        if (this.voucherFilter != null) {
            list.add(this.voucherFilter);
        }
        return list.toArray(new QFilter[0]);
    }

    @Override
    public List<String> getQueryFields() {
        return this.queryField;
    }

    @Override
    public QFilter[] getQFilters() {
        return this.qFilters;
    }

    @Override
    public SubLedgerReportQuery getReportQuery() {
        return this.reportQuery;
    }

    @Override
    public DataSet getDataSet(QFilter[] filter) {
        return VoucherQueryUtils.queryDataSet((String)this.selField, (QFilter[])(filter == null ? this.qFilters : filter), null, (int)-1);
    }

    public int getComAssistIndex(int num) {
        return this.comAssistIndexer.get(num);
    }

    @Override
    public OutPutFunction getOutPutFunction() {
        return this.outPutFunction;
    }

    public int getAccountIndex() {
        return this.accountIndex;
    }

    public int getBookDateIndex() {
        return this.bookDateIndex;
    }

    public int getBizDateIndex() {
        return this.bizDateIndex;
    }

    public int getVouNoIndex() {
        return this.vouNoIndex;
    }

    public int getDescIndex() {
        return this.descIndex;
    }

    public int getVouIdIndex() {
        return this.vouIdIndex;
    }

    public int getVouEntryIdIndex() {
        return this.vouEntryIdIndex;
    }

    public int getCurrencyIndex() {
        return this.currencyIndex;
    }

    public int getAssgrpIndex() {
        return this.assgrpIndex;
    }

    public int getMeasureunitIndex() {
        return this.measureunitIndex;
    }

    public int getEntryDCIndex() {
        return this.entryDcIndex;
    }

    public int[] getDebitIndexes() {
        return this.debitIndexes;
    }

    public int[] getCreditIndexes() {
        return this.creditIndexes;
    }

    public int getPeriodIndex() {
        return this.periodIndex;
    }

    public int getSeqIndex() {
        return this.seqIndex;
    }

    public int getVouTypeIndex() {
        return this.vouTypeIndex;
    }

    public int getOrgIndex() {
        return this.orgIndex;
    }

    public void setOutPutFunction(SubLedgerPLVouFunction outPutFunction) {
        this.outPutFunction = outPutFunction;
    }
}

