/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger.export.cms;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.entity.report.FilterInfo;
import kd.fi.gl.report.subledger.export.SubLedgerQueryContext;
import kd.fi.gl.report.subledger.export.SubLedgerRow;
import kd.fi.gl.report.subledger.export.cms.SubLedgerColumnManager;

public class ForeignCurrencyColumn
extends SubLedgerColumnManager {
    @Override
    public List<Field> getFields() {
        LinkedList<Field> res = new LinkedList<Field>();
        res.add(new Field("currency", (DataType)DataType.LongType));
        res.add(new Field("creditfor", (DataType)DataType.BigDecimalType));
        res.add(new Field("debitfor", (DataType)DataType.BigDecimalType));
        res.add(new Field("localrate", (DataType)DataType.BigDecimalType));
        res.add(new Field("endfor", (DataType)DataType.BigDecimalType));
        return res;
    }

    @Override
    public Set<String> getVoucherSelectors() {
        Set<String> res = super.getVoucherSelectors();
        res.add(String.join((CharSequence)"", "entries", ".", "debitori", " ", "debitfor"));
        res.add(String.join((CharSequence)"", "entries", ".", "creditori", " ", "creditfor"));
        res.add(String.join((CharSequence)"", "entries", ".", "localrate", " ", "localrate"));
        res.add(String.join((CharSequence)"", "entries", ".", "currency", " ", "currency"));
        return res;
    }

    @Override
    protected void fillVoucherRow(Row sourceRow, SubLedgerRow newRowToFill) {
        super.fillVoucherRow(sourceRow, newRowToFill);
        RowMeta rowMeta = newRowToFill.getRowMeta();
        newRowToFill.setValue(rowMeta.getFieldIndex("currency"), sourceRow.getLong("currency"));
        newRowToFill.setValue(rowMeta.getFieldIndex("creditfor"), sourceRow.getBigDecimal("creditfor"));
        newRowToFill.setValue(rowMeta.getFieldIndex("debitfor"), sourceRow.getBigDecimal("debitfor"));
        newRowToFill.setValue(rowMeta.getFieldIndex("localrate"), sourceRow.getBigDecimal("localrate"));
    }

    @Override
    public Set<String> getBeginBalSelectors() {
        Set<String> res = super.getBeginBalSelectors();
        res.add(String.join((CharSequence)"", "creditlocal", " ", "creditlocal"));
        res.add(String.join((CharSequence)"", "debitlocal", " ", "debitlocal"));
        res.add(String.join((CharSequence)"", "currency", " ", "currency"));
        res.add(String.join((CharSequence)"", "beginfor", " ", "beginfor"));
        return res;
    }

    @Override
    protected void fillBeginBalanceRow(Row sourceRow, SubLedgerRow newRowToFill) {
        super.fillBeginBalanceRow(sourceRow, newRowToFill);
        RowMeta rowMeta = newRowToFill.getRowMeta();
        newRowToFill.setValue(rowMeta.getFieldIndex("currency"), sourceRow.getLong("currency"));
        newRowToFill.setValue(rowMeta.getFieldIndex("debitfor"), BigDecimal.ZERO);
        newRowToFill.setValue(rowMeta.getFieldIndex("creditfor"), BigDecimal.ZERO);
        BigDecimal endFor = ((AbstractRow)sourceRow).getRowMeta().getFieldIndex("voucherid", false) != -1 ? sourceRow.getBigDecimal("debitfor").subtract(sourceRow.getBigDecimal("creditfor")) : sourceRow.getBigDecimal("beginfor");
        newRowToFill.setValue(rowMeta.getFieldIndex("endfor"), endFor);
    }

    @Override
    public Set<String> getYearBalSelectors() {
        Set<String> res = super.getYearBalSelectors();
        res.add(String.join((CharSequence)"", "yearcreditfor"));
        res.add(String.join((CharSequence)"", "yeardebitfor"));
        res.add(String.join((CharSequence)"", "creditfor"));
        res.add(String.join((CharSequence)"", "debitfor"));
        res.add(String.join((CharSequence)"", "currency"));
        return res;
    }

    @Override
    protected void fillYearBalanceRow(Row sourceRow, SubLedgerRow newRowToFill) {
        RowMeta rowMeta = newRowToFill.getRowMeta();
        newRowToFill.setValue(rowMeta.getFieldIndex("currency"), sourceRow.getLong("currency"));
        newRowToFill.setValue(rowMeta.getFieldIndex("debitfor"), sourceRow.getBigDecimal("yeardebitfor").subtract(sourceRow.getBigDecimal("debitfor")));
        newRowToFill.setValue(rowMeta.getFieldIndex("creditfor"), sourceRow.getBigDecimal("yearcreditfor").subtract(sourceRow.getBigDecimal("creditfor")));
    }

    @Override
    public void addDimensionFields(List<String> theirs) {
        theirs.add("currency");
    }

    @Override
    public boolean enable(FilterInfo filterInfo) {
        return SubLedgerQueryContext.getCurrent().getStateChart().queryForeignCurrency();
    }
}

