/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger.export.source;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.gl.report.subledger.export.SubLedgerQueryContext;
import kd.fi.gl.report.subledger.export.cms.SubLedgerColumnManager;
import kd.fi.gl.report.subledger.export.source.ExportDimVchQuery;
import kd.fi.gl.report.subledger.export.source.VoucherSourceBuilder;
import kd.fi.gl.util.GLUtil;

public class BeginVoucherBuilder
extends VoucherSourceBuilder {
    public BeginVoucherBuilder(Long[] orgs) {
        super(orgs);
    }

    @Override
    public DataSet build() {
        FilterInfo filterInfo = this.context.getFilterInfo();
        if ("2".equals(filterInfo.getString("searchtype"))) {
            SubLedgerQueryContext.getCurrent().timer.time("begin voucher begin.");
            String selectField = this.getSelectField(SubLedgerColumnManager::getVoucherSelectors);
            String voucherOrder = this.getVoucherOrder(filterInfo);
            selectField = selectField + ", entries.account.masterid accountmid";
            List<QFilter> filters = Arrays.stream(this.buildVoucherFilter(this.filterInfo, this.orgs)).filter(filter -> {
                String property = filter.getProperty();
                return !property.equals("period") && !property.equals("bookeddate");
            }).collect(Collectors.toList());
            filters.add(new QFilter("period", "=", (Object)this.context.getStartPeriod(this.orgs[0])));
            filters.add(new QFilter("bookeddate", "<", (Object)this.context.getStartDate()));
            DataSet set = VoucherQueryUtils.queryDataSet((String)selectField, (QFilter[])filters.toArray(new QFilter[0]), (String)voucherOrder, (int)-1);
            SubLedgerQueryContext.getCurrent().timer.time("voucher done.");
            set = set.map((MapFunction)new ExportDimVchQuery.AccountNumOnLevelMapper(set.getRowMeta(), "accountmid", "entries.account.number")).updateField("accountnumber", "entries.account.number");
            return set.addField("1", "rowtype");
        }
        return GLUtil.getEmptyDS(this.getClass());
    }

    private String getVoucherOrder(FilterInfo filter) {
        return this.context.getOrderDimensions().stream().map(key -> orderFieldsMap.getOrDefault(key, "entries." + key)).collect(Collectors.joining(", "));
    }
}

