/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger.export.worker;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.report.subledger.export.SubLedgerRow;
import kd.fi.gl.report.subledger.export.worker.SubLedgerSummaryWorker;
import kd.fi.gl.util.GLApp;

public class PeriodSummaryWorker
extends SubLedgerSummaryWorker {
    private Iterator<Long> periodIDItr;
    private final Map<Long, List<Long>> workPeriodCache = new HashMap<Long, List<Long>>();

    @Override
    public boolean needConsumeNext(SubLedgerRow currentProduct, SubLedgerRow nextDetailRow) {
        String rowType = nextDetailRow.getString("rowtype");
        return super.needConsumeNext(currentProduct, nextDetailRow) && ("1".equals(rowType) || "2".equals(rowType));
    }

    @Override
    public void consumeGoods(SubLedgerRow current, SubLedgerRow nextDetailRow) {
        super.consumeGoods(current, nextDetailRow);
        if ("1".equals(nextDetailRow.getString("rowtype"))) {
            current.setValue(this.detailCountIndex, current.getInteger(this.detailCountIndex) - 1);
        }
    }

    @Override
    public boolean needOutputCurrent(SubLedgerRow currentProduct, SubLedgerRow nextGoods) {
        if (currentProduct == null) {
            return false;
        }
        if (!"1".equals(nextGoods.getString("rowtype")) && !"2".equals(nextGoods.getString("rowtype"))) {
            return false;
        }
        boolean baseDimensionMatched = this.isBaseDimensionMatched(currentProduct, nextGoods);
        boolean isPeriodMatched = Objects.equals(currentProduct.get("period").toString(), nextGoods.get("period").toString());
        return !baseDimensionMatched || !isPeriodMatched;
    }

    @Override
    protected List<SubLedgerRow> outputWhenFinished() {
        LinkedList<SubLedgerRow> res = new LinkedList<SubLedgerRow>(super.outputWhenFinished());
        SubLedgerRow current = (SubLedgerRow)((Object)super.getCurrent());
        if (current != null) {
            while (this.hasNextPeriodToWork()) {
                res.add(this.doCreateProduct(current));
            }
        }
        return res;
    }

    @Override
    public SubLedgerRow createNextProduct(SubLedgerRow preSumProduct, SubLedgerRow nextDetailRow) {
        String rowType = nextDetailRow.getString("rowtype");
        if (!"1".equals(rowType) && !"2".equals(rowType)) {
            return null;
        }
        if (preSumProduct == null) {
            return this.doCreateProduct(nextDetailRow);
        }
        boolean baseDimensionMatch = super.isBaseDimensionMatched(preSumProduct, nextDetailRow);
        SubLedgerRow rowToCopy = !baseDimensionMatch && this.hasNextPeriodToWork() ? preSumProduct : nextDetailRow;
        return this.doCreateProduct(rowToCopy);
    }

    private SubLedgerRow doCreateProduct(SubLedgerRow rowToCopy) {
        if (!this.hasNextPeriodToWork()) {
            this.resetWorkPeriod(rowToCopy);
            if (!this.hasNextPeriodToWork()) {
                return null;
            }
        }
        SubLedgerRow newCurrent = new SubLedgerRow("4");
        this.getCopyFields().forEach(column -> newCurrent.setValue(this.rowMeta.getFieldIndex(column), rowToCopy.get((String)column)));
        Long nextWorkPeriod = this.getNextWorkPeriod();
        newCurrent.setValue(this.rowMeta.getFieldIndex("period"), nextWorkPeriod);
        Date periodEndDate = this.context.getPeriodFromCache(nextWorkPeriod).getDate("enddate");
        Date queryEndDate = this.context.getEndDate();
        newCurrent.setValue(this.rowMeta.getFieldIndex("bookeddate"), queryEndDate.compareTo(periodEndDate) < 0 ? queryEndDate : periodEndDate);
        newCurrent.setValue(this.rowMeta.getFieldIndex("desc"), ResManager.loadKDString((String)"\u672c\u671f\u5408\u8ba1", (String)"AbstractSummaryWorker_2", (String)GLApp.instance.reportModule(), (Object[])new Object[0]));
        return newCurrent;
    }

    private boolean hasNextPeriodToWork() {
        return this.periodIDItr != null && this.periodIDItr.hasNext();
    }

    private void resetWorkPeriod(SubLedgerRow rowToCopy) {
        Long org = rowToCopy.getLong("org");
        this.workPeriodCache.computeIfAbsent(org, org1 -> {
            QFilter beginF = new QFilter("id", ">=", (Object)this.context.getStartPeriod(org));
            QFilter endF = new QFilter("id", "<=", (Object)this.context.getEndPeriod());
            return QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])new QFilter[]{beginF, endF}, (String)"id asc", (int)-1).stream().map(Long.class::cast).collect(Collectors.toList());
        });
        this.periodIDItr = this.workPeriodCache.get(org).iterator();
    }

    private Long getNextWorkPeriod() {
        return this.periodIDItr.next();
    }
}

