/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.BooleanType;
import kd.bos.algo.datatype.IntegerType;
import kd.bos.algo.datatype.LongType;
import kd.bos.algo.datatype.StringType;
import kd.bos.algo.datatype.TimestampType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.model.Context;
import kd.fi.bd.model.schema.property.Prop;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.gl.model.schema.VoucherSchema;
import kd.fi.gl.model.schema.report.SubsidiarySchema;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.subsidiary.TotalCalculateReportPlugin;
import kd.fi.gl.report.subsidiary.TotalQuery;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;

public class SubsidiaryTotalQuery
implements TotalQuery<Map<String, HashSet<Object>>> {
    @Override
    public DataSet query(ReportQueryParam queryParam, Map<String, HashSet<Object>> selectedObj, Context context) {
        String beginBalanceCacheID;
        DataSet beginBalanceSum;
        if (selectedObj == null) {
            return GLUtil.getEmptyDS(this.getClass());
        }
        QFilter[] vchFilters = GLUtil.deserializeQFilter((String)((String)context.query(SubsidiarySchema.schema.Key_vchFilterStr)));
        VoucherSchema schema = VoucherSchema.instance;
        DataSet voucher = VoucherQueryUtils.queryDataSet((String)Prop.toSelectFieldStr((Prop[])new Prop[]{schema.creditLocal, schema.debitLocal, schema.assgrp}), (QFilter[])vchFilters, null, (int)-1);
        BigDecimal creditSum = BigDecimal.ZERO;
        BigDecimal debitSum = BigDecimal.ZERO;
        BigDecimal endSum = BigDecimal.ZERO;
        DataSet voucherSum = voucher.select(new String[]{schema.creditLocal.toFullName(), schema.debitLocal.toFullName()}).groupBy().sum(schema.creditLocal.toFullName()).sum(schema.debitLocal.toFullName()).finish();
        if (voucherSum.hasNext()) {
            Row row = voucherSum.next();
            creditSum = row.getBigDecimal(schema.creditLocal.toFullName());
            debitSum = row.getBigDecimal(schema.debitLocal.toFullName());
        }
        if ((beginBalanceSum = Algo.getCacheDataSet((String)(beginBalanceCacheID = (String)context.query(SubsidiarySchema.schema.Key_beginBalanceCacheID))).toDataSet(Algo.create((String)(this.getClass().getName() + "#beginBalance")), true).select("endlocal").groupBy().sum("endlocal").finish()).hasNext()) {
            endSum = beginBalanceSum.next().getBigDecimal("endlocal");
        }
        endSum = endSum.add(debitSum.subtract(creditSum));
        RowMeta rowMeta = (RowMeta)context.query(TotalCalculateReportPlugin.Key_detailRowMeta);
        Object[] totalRow = new Object[rowMeta.getFields().length];
        totalRow[rowMeta.getFieldIndex((String)"rowtype")] = "5";
        totalRow[rowMeta.getFieldIndex((String)"desc")] = ResManager.loadKDString((String)"\u672c\u671f\u603b\u5408\u8ba1", (String)"TotalCalculateReportPlugin_1", (String)GLApp.instance.reportModule(), (Object[])new Object[0]);
        totalRow[rowMeta.getFieldIndex((String)"dc")] = endSum.compareTo(BigDecimal.ZERO) + "";
        totalRow[rowMeta.getFieldIndex((String)"debitlocal")] = debitSum;
        totalRow[rowMeta.getFieldIndex((String)"creditlocal")] = creditSum;
        totalRow[rowMeta.getFieldIndex((String)"endlocal")] = endSum.abs();
        totalRow[rowMeta.getFieldIndex((String)"basecurrency")] = context.query(SubsidiarySchema.schema.Key_baseCurrencyID);
        DataSetBuilder totalDsBuilder = Algo.create((String)(this.getClass().getName() + "#totalRow")).createDataSetBuilder(rowMeta);
        totalDsBuilder.append(totalRow);
        return totalDsBuilder.build();
    }

    @Override
    public DataSet query(ReportQueryParam queryParam, Map<String, HashSet<Object>> selectedObj, DataSet detailDS, Context context) {
        if (selectedObj == null) {
            return GLUtil.getEmptyDS(this.getClass());
        }
        List assTypeSel = (List)context.query(SubsidiarySchema.schema.Key_assTypeSel);
        String[] SUMBY = (String[])context.query(SubsidiarySchema.schema.Key_sumBy);
        Long currLocal = (Long)context.query(SubsidiarySchema.schema.Key_baseCurrencyID);
        ArrayList<String> groupbys = new ArrayList<String>(assTypeSel);
        groupbys.add("accountnumber");
        groupbys.add("currencycolumn");
        if (queryParam.getFilter().getBoolean("showqty")) {
            groupbys.add("measureunit");
        }
        groupbys.add("dc");
        DataSet periodBalSet = detailDS.filter("rowtype=3").groupBy(groupbys.toArray(new String[0])).maxP("period", "endlocal").finish().select(new String[]{"endlocal", "dc"});
        periodBalSet = periodBalSet.groupBy().sum("case when dc=-1 then -1*endlocal else endlocal end", "endlocal").finish().addField("5", "rowtype");
        Field[] oldFields = detailDS.getRowMeta().getFields();
        String[] groupBy = new String[]{"rowtype"};
        DataSet sumSet = MulOrgQPRpt.gainSumSet((DataSet)detailDS, (String[])groupBy, (String[])SUMBY);
        sumSet = sumSet.filter("rowtype=3").removeFields(new String[]{"rowtype"}).addField("5", "rowtype").leftJoin(periodBalSet).on("rowtype", "rowtype").select(SUMBY, new String[]{"rowtype", "endlocal"}).finish().addField("case when endlocal>0 then '1' when endlocal=0 then '0' else '-1' end", "dc").addField(String.format(ResManager.loadKDString((String)"%1$s\u672c\u671f\u603b\u5408\u8ba1%2$s", (String)"SubsiDiaryRightQueryRpt_3", (String)"fi-gl-report", (Object[])new Object[0]), "'", "'"), "desc");
        periodBalSet.close();
        return this.gainSumSetHelper(sumSet, oldFields, currLocal);
    }

    private List<String> getComassistFields(ReportQueryParam queryParam) {
        ArrayList<String> comAssistList = new ArrayList<String>(8);
        String comAssistValsListStr = (String)queryParam.getCustomParam().get("ComAssistEntityListStr");
        if (comAssistValsListStr == null) {
            return comAssistList;
        }
        List comAssistEntityList = (List)SerializationUtils.fromJsonString((String)comAssistValsListStr, List.class);
        if (!comAssistEntityList.isEmpty()) {
            for (int i = 0; i < comAssistEntityList.size(); ++i) {
                List tuplMap = (List)comAssistEntityList.get(i);
                comAssistList.add((String)tuplMap.get(0));
            }
        }
        return comAssistList;
    }

    private DataSet gainSumSetHelper(DataSet ds, Field[] oldFields, long currLocal) {
        ArrayList<String> list = new ArrayList<String>();
        RowMeta rowMeta = ds.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<String> newCols = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            newCols.add(field.getName().toLowerCase());
        }
        for (Field field : oldFields) {
            String name = field.getName().toLowerCase();
            if (newCols.contains(name)) {
                if (name.equals("endlocal")) {
                    name = "case when endlocal<0 then -1*endlocal else endlocal end as endlocal";
                }
                list.add(name);
                continue;
            }
            DataType dataType = field.getDataType();
            if (dataType instanceof LongType) {
                if ("basecurrency".equals(name)) {
                    list.add(currLocal + " " + name);
                    continue;
                }
                list.add("0L " + name);
                continue;
            }
            if (dataType instanceof IntegerType) {
                if ("basecurrency".equals(name)) {
                    list.add(currLocal + " " + name);
                    continue;
                }
                list.add("0 " + name);
                continue;
            }
            if (dataType instanceof BigDecimalType) {
                list.add("0.0 " + name);
                continue;
            }
            if (dataType instanceof StringType) {
                list.add("'' " + name);
                continue;
            }
            if (dataType instanceof BooleanType) {
                list.add("false " + name);
                continue;
            }
            if (!(dataType instanceof TimestampType)) continue;
            list.add("null " + name);
        }
        ds = ds.select(list.toArray(new String[0]));
        return ds;
    }
}

