/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary.v2.batch;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.Transient;
import java.util.List;
import kd.fi.gl.report.batchquery.IBatchRow;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.GLUtil;

public class SubsiBatchRow
implements IBatchRow {
    private static final long serialVersionUID = -5808019280201974575L;
    private List<FlexUtils.AssistFilterEntry> assistEntryValues;
    private long acctMid;
    private int count;
    @JsonProperty
    private RowType rowType;

    private SubsiBatchRow(List<FlexUtils.AssistFilterEntry> assistEntryValues, long acctMid, int count, RowType rowType) {
        this.assistEntryValues = assistEntryValues;
        this.acctMid = acctMid;
        this.count = count;
        this.rowType = rowType;
    }

    public SubsiBatchRow() {
    }

    public static SubsiBatchRow createSingleBatchRow(List<FlexUtils.AssistFilterEntry> assistEntryValues) {
        return new SubsiBatchRow(assistEntryValues, -1L, -1, RowType.SINGLE_BATCH_ROW);
    }

    public static SubsiBatchRow createCommonBatchRow(List<FlexUtils.AssistFilterEntry> assistEntryValues, long acctMid, int count) {
        return new SubsiBatchRow(assistEntryValues, acctMid, count, RowType.COMMON_BATCH_ROW);
    }

    public static SubsiBatchRow createTotalBatchRow(List<FlexUtils.AssistFilterEntry> assistEntryValues) {
        return new SubsiBatchRow(assistEntryValues, -1L, -1, RowType.TOTAL_BATCH_ROW);
    }

    public List<FlexUtils.AssistFilterEntry> getAssistEntryValues() {
        return this.assistEntryValues;
    }

    public Long getAcctMid() {
        return this.acctMid;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    @Transient
    public boolean isSingleBatchRow() {
        return this.rowType == RowType.SINGLE_BATCH_ROW;
    }

    @Transient
    public boolean isTotalBatch() {
        return this.rowType == RowType.TOTAL_BATCH_ROW;
    }

    public String toString() {
        return GLUtil.toJsonStr((Object)this);
    }

    private static enum RowType {
        SINGLE_BATCH_ROW,
        COMMON_BATCH_ROW,
        TOTAL_BATCH_ROW;

    }
}

