/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary.v2.core;

import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;

public class ResultField<ROW> {
    private final Field field;
    private final BiFunction<ROW, Object[], Object> extractFunction;

    public ResultField(String name, DataType dataType, Function<ROW, Object> extractFunction) {
        this.field = new Field(name, dataType);
        this.extractFunction = (x, y) -> extractFunction.apply(x);
    }

    public ResultField(String name, DataType dataType, BiFunction<ROW, Object[], Object> extractFunction) {
        this.field = new Field(name, dataType);
        this.extractFunction = extractFunction;
    }

    public Field getField() {
        return this.field;
    }

    public BiFunction<ROW, Object[], Object> getExtractFunction() {
        return this.extractFunction;
    }

    public static <ROW> DataSet toDataSet(final List<ResultField<ROW>> fields, final Iterator<ROW> result, final Consumer<ROW> rowHandler, Algo algo) {
        final int size = fields.size();
        Iterator<Object[]> datas = new Iterator<Object[]>(){

            @Override
            public boolean hasNext() {
                return result.hasNext();
            }

            @Override
            public Object[] next() {
                Object[] data = null;
                if (this.hasNext()) {
                    Object balRow = result.next();
                    if (rowHandler != null) {
                        rowHandler.accept(balRow);
                    }
                    data = new Object[size];
                    for (int i = 0; i < size; ++i) {
                        data[i] = ((ResultField)fields.get(i)).getExtractFunction().apply(balRow, data);
                    }
                }
                return data;
            }
        };
        RowMeta rowMeta = new RowMeta((Field[])fields.stream().map(ResultField::getField).toArray(Field[]::new));
        DataSet dataSet = algo.createDataSet((Iterator)datas, rowMeta);
        return dataSet;
    }

    public static <ROW> DataSet toDataSet(List<ResultField<ROW>> fields, List<ROW> result, Algo algo) {
        return ResultField.toDataSet(fields, result.iterator(), null, algo);
    }

    public static <ROW> DataSet toDataSet(List<ResultField<ROW>> fields, List<ROW> result) {
        return ResultField.toDataSet(fields, result.iterator(), null, Algo.create((String)"ResultField"));
    }
}

