/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary.v2.core;

import java.math.BigDecimal;
import kd.fi.gl.report.subsidiary.v2.core.model.AssistValueGroup;
import kd.fi.gl.report.subsidiary.v2.core.model.RowType;
import kd.fi.gl.report.subsidiary.v2.core.model.SubsidiaryGroup;
import kd.fi.gl.report.subsidiary.v2.core.model.SubsidiaryPeriodGroup;
import kd.fi.gl.report.subsidiary.v2.core.model.SubsidiaryRow;

public class SubsidiaryRowFactory {
    public static SubsidiaryRow createYearRowWithZeroAmount(SubsidiaryRow sourceRow) {
        return SubsidiaryRowFactory.createRowWithZeroAmount(sourceRow, RowType.YEAR, sourceRow.getPeriodId());
    }

    public static SubsidiaryRow createBeginRowWithZeroAmount(SubsidiaryRow sourceRow) {
        return SubsidiaryRowFactory.createRowWithZeroAmount(sourceRow, RowType.BEGIN, 0L);
    }

    public static SubsidiaryRow createPeriodRowWithZeroAmount(SubsidiaryRow sourceRow, long period) {
        return SubsidiaryRowFactory.createRowWithZeroAmount(sourceRow, RowType.PERIOD, period);
    }

    public static SubsidiaryRow createPeriodRowWithZeroAmount(SubsidiaryGroup grp, long period, long acctId, long acctMid) {
        SubsidiaryRow row = new SubsidiaryRow(RowType.PERIOD);
        row.setPeriodGroup(new SubsidiaryPeriodGroup(grp, period));
        row.setAccountId(acctId);
        row.setAccountMasterId(acctMid);
        return row;
    }

    public static SubsidiaryRow createTotalRow(AssistValueGroup assistValueGroup, BigDecimal creditLocalTotal, BigDecimal debitLocalTotal) {
        SubsidiaryRow totalRow = new SubsidiaryRow(RowType.TOTAL);
        totalRow.setPeriodGroup(new SubsidiaryPeriodGroup(new SubsidiaryGroup(assistValueGroup, "", -1L, -1L), -1L));
        totalRow.setDebitLocal(debitLocalTotal);
        totalRow.setCreditLocal(creditLocalTotal);
        return totalRow;
    }

    static SubsidiaryRow createRowWithZeroAmount(SubsidiaryRow sourceRow, RowType rowType, Long period) {
        SubsidiaryRow row = new SubsidiaryRow(rowType);
        SubsidiaryRowFactory.copyGroup(sourceRow, row);
        row.setPeriodId(period);
        return row;
    }

    public static SubsidiaryRow createNewRow(RowType rowType, AssistValueGroup assistValueGroup, String acctNumber, Long currencyId, Long unitId, Long periodId, Long acctMid, Long acctId) {
        SubsidiaryRow row = new SubsidiaryRow(rowType);
        row.setPeriodGroup(new SubsidiaryPeriodGroup(new SubsidiaryGroup(assistValueGroup, acctNumber, currencyId, unitId), 0L));
        row.setPeriodId(periodId);
        row.setAccountMasterId(acctMid);
        row.setAccountId(acctId);
        return row;
    }

    private static void copyGroup(SubsidiaryRow from, SubsidiaryRow to) {
        to.setPeriodGroup(new SubsidiaryPeriodGroup(from.getGroup(), from.getPeriodId()));
        to.setAccountMasterId(from.getAccountMasterId());
        to.setAccountId(from.getAccountId());
    }
}

