/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary.v2.core.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.util.FlexUtils;

public class AssistValueGroup
implements Comparable<AssistValueGroup>,
Serializable {
    private static final long serialVersionUID = -8119274603225728245L;
    @JsonIgnore
    public static final AssistValueGroup EMPTY = new AssistValueGroup(Collections.emptyList());
    @JsonProperty
    private List<AssistValueItem> values;

    public AssistValueGroup() {
    }

    private AssistValueGroup(List<AssistValueItem> values) {
        this.values = values;
    }

    public static AssistValueGroup create(List<FlexUtils.AssistFilterEntry> assistFields, Row row, boolean isExport) {
        if (!isExport) {
            return EMPTY;
        }
        List<AssistValueItem> items = assistFields.stream().map(assist -> {
            String flexField = assist.getProperty();
            if (AssistValueType.isManualTxt((String)assist.getFlexProperty().getValueType())) {
                String txtVal = row.getString(flexField);
                return new AssistValueItem(flexField, Objects.isNull(txtVal) ? "" : txtVal);
            }
            Long longVal = row.getLong(flexField);
            return new AssistValueItem(flexField, Objects.isNull(longVal) ? Long.valueOf(0L) : longVal);
        }).collect(Collectors.toList());
        return new AssistValueGroup(items);
    }

    public Object getSingleBdValue(int index) {
        return this.values.get(index).value;
    }

    @Override
    public int compareTo(AssistValueGroup o) {
        if (this == o) {
            return 0;
        }
        if (o == null || o.values.size() != this.values.size()) {
            throw new IllegalArgumentException();
        }
        int res = 0;
        for (int i = 0; i < this.values.size() && res == 0; ++i) {
            Object o1 = this.values.get(i).getValue();
            Object o2 = o.values.get(i).getValue();
            if (o1 instanceof Long) {
                res = ((Long)o1).compareTo((Long)o2);
                if (!o1.equals(0L) && !o2.equals(0L)) continue;
                res = -res;
                continue;
            }
            res = ((String)o1).compareTo((String)o2);
        }
        return -res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssistValueGroup that = (AssistValueGroup)o;
        return Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public static class AssistValueItem
    implements Serializable {
        private static final long serialVersionUID = -212251360085047252L;
        private String flexField;
        private Object value;

        public AssistValueItem() {
        }

        public AssistValueItem(String flexField, Object value) {
            this.flexField = flexField;
            this.value = value;
        }

        public AssistValueItem(String flexField, String value) {
            this.flexField = flexField;
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public String getFlexField() {
            return this.flexField;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AssistValueItem that = (AssistValueItem)o;
            return Objects.equals(this.flexField, that.flexField) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.flexField, this.value);
        }

        public String toString() {
            return String.format("[%s:%s]", this.flexField, this.value);
        }
    }
}

