/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.bizrule;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.operate.bizrule.OpBizRule;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class VoucherBookJournalAction
extends AbstractOpBizRuleAction {
    private static final Log logger = LogFactory.getLog(VoucherBookJournalAction.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        OpBizRule bizRule = this.getBizRule();
        Map params = (Map)SerializationUtils.fromJsonString((String)bizRule.getParameter(), Map.class);
        final String action = (String)params.get("action");
        e.addValidator(new AbstractValidator(){

            public void validate() {
                Long[] voucherPks = new Long[this.dataEntities.length];
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    voucherPks[i] = (Long)this.dataEntities[i].getDataEntity().getPkValue();
                }
                Map result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"voucherbook", (String)"validate", (Object[])new Object[]{voucherPks, action, this.getOperateKey()});
                if (result != null) {
                    for (ExtendedDataEntity voucher : this.dataEntities) {
                        Object voucherPk = voucher.getDataEntity().getPkValue();
                        if (!result.containsKey(voucherPk)) continue;
                        this.addErrorMessage(voucher, (String)result.get(voucherPk));
                    }
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        this.sendMessageByEndConsistent(e);
    }

    private void sendMessageByEndConsistent(EndOperationTransactionArgs e) {
        Object[] vouchers = e.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])vouchers)) {
            return;
        }
        Long[] voucherPks = new Long[vouchers.length];
        ArrayList<String> voucherPkssList = new ArrayList<String>(vouchers.length);
        for (int i = 0; i < vouchers.length; ++i) {
            voucherPks[i] = (Long)vouchers[i].getPkValue();
            voucherPkssList.add(String.valueOf(voucherPks[i]));
        }
        OpBizRule bizRule = this.getBizRule();
        Map params = (Map)SerializationUtils.fromJsonString((String)bizRule.getParameter(), Map.class);
        String action = (String)params.get("action");
        CommonParam param = new CommonParam();
        param.put((Object)"action", (Object)action);
        param.put((Object)"voucherPks", (Object)voucherPks);
        Long recordPk = DB.genLongId((String)EntityMetadataCache.getDataEntityType((String)"cas_mq_record").getAlias());
        param.put((Object)"recordPk", (Object)recordPk);
        try {
            ECGlobalSession.begin((String)"voucher_book_journal", (DBRoute)DBRoute.of((String)"cas"), (boolean)true);
            ECGlobalSession.setAsync((boolean)true);
            ECGlobalSession.setBusinessType((String)"voucherPks");
            ECGlobalSession.setBusinessInfo(voucherPkssList);
            logger.info(String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u767b\u8d26\u6700\u7ec8\u4e00\u81f4\u6027\uff0c\u5411\u670d\u52a1\u7aef\u53d1\u9001\u6d88\u606f\uff1a%s\u3002", (String)"VoucherBookJournalAction_0", (String)"bos-ext-fi", (Object[])new Object[0]), JSONObject.toJSONString((Object)param)));
            ECGlobalSession.register((String)"fi", (String)"cas", (String)"VoucherBookEndConsistentService", (Param)param, null, (String)"");
        }
        catch (Exception ext) {
            logger.error("\u51ed\u8bc1\u767b\u8d26\u6700\u7ec8\u4e00\u81f4\u6027\u5411\u670d\u52a1\u7aef\u53d1\u9001\u6d88\u606f\u5f02\u5e38\uff1a", (Throwable)ext);
            throw ext;
        }
    }
}

