/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.checkstatus.unit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.checkstatus.checkinfo.ACNoticeEntity;
import kd.fi.gl.checkstatus.checkinfo.AbstractNotice;
import kd.fi.gl.checkstatus.checkinfo.CFNoticeEntity;
import kd.fi.gl.checkstatus.checkinfo.NoticeCheckContext;
import kd.fi.gl.checkstatus.unit.AbstractNoticeCheckLogicUnit;
import kd.fi.gl.util.QFBuilder;

public class VoucherAgainstCheckLogicUnit
extends AbstractNoticeCheckLogicUnit {
    @Override
    protected void excute(NoticeCheckContext checkContext) {
        List<AbstractNotice> readyCheckDatas = checkContext.getReadyCheckDatas();
        List voucherIds = readyCheckDatas.stream().map(AbstractNotice::getVoucherId).collect(Collectors.toList());
        QFilter srcFilter = new QFilter("srcentity", "in", voucherIds);
        QFilter tagFilter = new QFilter("targentity", "in", voucherIds);
        QFilter effectFilter = new QFilter("iseffective", "=", (Object)true);
        HashMap<Long, List> src2tag = new HashMap<Long, List>(voucherIds.size());
        ArrayList<Long> againstVoucherIds = new ArrayList<Long>(readyCheckDatas.size());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_reverserelation", (String)"srcentity,targentity", (QFilter[])new QFilter[]{srcFilter.or(tagFilter), effectFilter}, (String)"srcentity");){
            for (Row row : ds) {
                Long src = row.getLong("srcentity");
                Long tag = row.getLong("targentity");
                src2tag.compute(tag, (k, v) -> {
                    if (null == v) {
                        v = new ArrayList<Long>();
                    }
                    v.add(src);
                    return v;
                });
                if (!"checktype_semi_auto".equals(checkContext.getCheckType())) continue;
                againstVoucherIds.add(tag);
                againstVoucherIds.add(src);
            }
        }
        if ("checktype_semi_auto".equals(checkContext.getCheckType())) {
            againstVoucherIds.removeAll(voucherIds);
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("voucher", "in", againstVoucherIds);
            qfBuilder.add("checkstatus", "=", (Object)"0");
            List noticeIds = QueryServiceHelper.queryPrimaryKeys((String)checkContext.getEntityName(), (QFilter[])qfBuilder.toArray(), null, (int)-1);
            DynamicObject[] noticeDynObjs = BusinessDataServiceHelper.load((Object[])noticeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)checkContext.getEntityName()));
            List againstReadyCheckDatas = Stream.of(noticeDynObjs).map(x -> Objects.equals("gl_acnotice", checkContext.getEntityName()) ? new ACNoticeEntity((DynamicObject)x) : new CFNoticeEntity((DynamicObject)x)).collect(Collectors.toList());
            readyCheckDatas.addAll(againstReadyCheckDatas);
        }
        src2tag.forEach((k, v) -> {
            v.add(k);
            List<AbstractNotice> checkDatas = readyCheckDatas.stream().filter(x -> v.contains(x.getVoucherId())).collect(Collectors.toList());
            this.singleSelfCheck(checkDatas);
            this.mulSelfOriCheck(checkDatas);
            this.mulSelfLocCheck(checkDatas);
        });
    }
}

