/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.closeinit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Row;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.gl.closeinit.InitBalInfo;
import kd.fi.gl.closeinit.InitBalKey;

public class BatchInitInfo {
    int comsize;
    Set<Long> accounts = new HashSet<Long>(5000);
    Set<Long> assgrps = new HashSet<Long>(10000);
    Set<Long> currencys = new HashSet<Long>(10);
    Set<Long> measureunits = new HashSet<Long>(10);
    Map<Integer, Set<Long>> comassist = new HashMap<Integer, Set<Long>>(2);
    Map<InitBalKey, InitBalInfo> initBals = new HashMap<InitBalKey, InitBalInfo>(10000);
    Collection<LocalCurrencyConfigVO> localCurList = new ArrayList<LocalCurrencyConfigVO>(3);

    public BatchInitInfo() {
    }

    public BatchInitInfo(int comsize, Collection<LocalCurrencyConfigVO> localCurList) {
        this.comsize = comsize;
        this.localCurList = localCurList;
    }

    public void add(Row initBal, long startPeriodId) {
        this.accounts.add(initBal.getLong("account"));
        this.assgrps.add(initBal.getLong("assgrp"));
        this.currencys.add(initBal.getLong("currency"));
        this.measureunits.add(initBal.getLong("measureunit"));
        this.initBals.put(this.getKey(initBal), new InitBalInfo(initBal, startPeriodId, this.comsize, this.localCurList));
        for (int i = 1; i <= this.comsize; ++i) {
            Set set = this.comassist.computeIfAbsent(i, x -> new HashSet());
            set.add(initBal.getLong("comassist" + i));
        }
    }

    public void setAccounts(Set<Long> accounts) {
        this.accounts = accounts;
    }

    public void setAssgrps(Set<Long> assgrps) {
        this.assgrps = assgrps;
    }

    public void setCurrencys(Set<Long> currencys) {
        this.currencys = currencys;
    }

    public void setMeasureunits(Set<Long> measureunits) {
        this.measureunits = measureunits;
    }

    public void setComassist(Map<Integer, Set<Long>> comassist) {
        this.comassist = comassist;
    }

    public void setInitBals(Map<InitBalKey, InitBalInfo> initBals) {
        this.initBals = initBals;
    }

    public Set<Long> getAccounts() {
        return this.accounts;
    }

    public Set<Long> getAssgrps() {
        return this.assgrps;
    }

    public Set<Long> getCurrencys() {
        return this.currencys;
    }

    public Set<Long> getMeasureunits() {
        return this.measureunits;
    }

    public Map<InitBalKey, InitBalInfo> getInitBal() {
        return this.initBals;
    }

    public Map<Integer, Set<Long>> getComassist() {
        return this.comassist;
    }

    private InitBalKey getKey(Row initBal) {
        ArrayList<Long> comassist = new ArrayList<Long>(2);
        for (int i = 1; i <= this.comsize; ++i) {
            comassist.add(initBal.getLong("comassist" + i));
        }
        InitBalKey key = new InitBalKey(initBal.getLong("org"), initBal.getLong("booktype"), initBal.getLong("accounttable"), initBal.getLong("account"), initBal.getLong("assgrp"), initBal.getLong("currency"), initBal.getLong("measureunit"), comassist);
        return key;
    }

    public void clear() {
        this.accounts.clear();
        this.assgrps.clear();
        this.currencys.clear();
        this.measureunits.clear();
        this.initBals.clear();
        this.comassist.clear();
    }
}

