/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.closeinit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.consts.MCT;
import kd.fi.gl.closeinit.BalInfo;

public class InitBalInfo
implements Cloneable {
    private long org;
    private long bookType;
    private long accounttable;
    private long account;
    private long assgrp;
    private long currency;
    private long measureunit;
    private BigDecimal beginqty = BigDecimal.ZERO;
    private BigDecimal beginfor = BigDecimal.ZERO;
    private BigDecimal beginlocal = BigDecimal.ZERO;
    private BigDecimal endqty = BigDecimal.ZERO;
    private BigDecimal endfor = BigDecimal.ZERO;
    private BigDecimal endlocal = BigDecimal.ZERO;
    private BigDecimal yeardebitqty = BigDecimal.ZERO;
    private BigDecimal yeardebitfor = BigDecimal.ZERO;
    private BigDecimal yeardebitlocal = BigDecimal.ZERO;
    private BigDecimal yearcreditqty = BigDecimal.ZERO;
    private BigDecimal yearcreditfor = BigDecimal.ZERO;
    private BigDecimal yearcreditlocal = BigDecimal.ZERO;
    private long lastPeriodId;
    private boolean exist;
    private boolean first;
    private List<Long> comassist = new ArrayList<Long>(2);
    List<DynamicObject> inserts = new ArrayList<DynamicObject>();
    List<BalInfo> infoTemp = new ArrayList<BalInfo>();
    List<BalInfo> updateList = new ArrayList<BalInfo>();
    List<Object> rmvList = new ArrayList<Object>();
    Map<String, BigDecimal> mulCurBal = new HashMap<String, BigDecimal>();

    public InitBalInfo(Row row, long startPeriodId, int comsize, Collection<LocalCurrencyConfigVO> curList) {
        this.init(row, startPeriodId, comsize, curList);
    }

    public InitBalInfo() {
    }

    public final void init(Row row, long startPeriodId, int comsize, Collection<LocalCurrencyConfigVO> curList) {
        this.org = row.getLong("org");
        this.bookType = row.getLong("booktype");
        this.accounttable = row.getLong("accounttable");
        this.account = row.getLong("account");
        this.assgrp = row.getLong("assgrp");
        this.currency = row.getLong("currency");
        this.measureunit = row.getLong("measureunit");
        this.beginqty = row.getBigDecimal("begindebitqty").subtract(row.getBigDecimal("begincreditqty"));
        this.beginlocal = row.getBigDecimal("begindebitlocal").subtract(row.getBigDecimal("begincreditlocal"));
        this.beginfor = row.getBigDecimal("begindebitfor").subtract(row.getBigDecimal("begincreditfor"));
        this.endqty = row.getBigDecimal("begindebitqty").subtract(row.getBigDecimal("begincreditqty"));
        this.endfor = row.getBigDecimal("begindebitfor").subtract(row.getBigDecimal("begincreditfor"));
        this.endlocal = row.getBigDecimal("begindebitlocal").subtract(row.getBigDecimal("begincreditlocal"));
        this.yeardebitqty = row.getBigDecimal("yeardebitqty");
        this.yeardebitfor = row.getBigDecimal("yeardebitfor");
        this.yeardebitlocal = row.getBigDecimal("yeardebitlocal");
        this.yearcreditqty = row.getBigDecimal("yearcreditqty");
        this.yearcreditfor = row.getBigDecimal("yearcreditfor");
        this.yearcreditlocal = row.getBigDecimal("yearcreditlocal");
        this.exist = false;
        this.first = true;
        this.lastPeriodId = startPeriodId;
        for (int i = 1; i <= comsize; ++i) {
            this.comassist.add(row.getLong("comassist" + i));
        }
        for (LocalCurrencyConfigVO cur : curList) {
            BigDecimal beginDebit = row.getBigDecimal(cur.getInitBalanceField(MCT.BEGIN_DEBIT).getMetaId()) == null ? BigDecimal.ZERO : row.getBigDecimal(cur.getInitBalanceField(MCT.BEGIN_DEBIT).getMetaId());
            BigDecimal beginCredit = row.getBigDecimal(cur.getInitBalanceField(MCT.BEGIN_CREDIT).getMetaId()) == null ? BigDecimal.ZERO : row.getBigDecimal(cur.getInitBalanceField(MCT.BEGIN_CREDIT).getMetaId());
            this.mulCurBal.put(cur.getBalanceField(MCT.BEGIN).getMetaId(), beginDebit.subtract(beginCredit));
            this.mulCurBal.put(cur.getBalanceField(MCT.END).getMetaId(), beginDebit.subtract(beginCredit));
            BigDecimal yearDebit = row.getBigDecimal(cur.getInitBalanceField(MCT.YEAR_DEBIT).getMetaId());
            this.mulCurBal.put(cur.getBalanceField(MCT.YEAR_DEBIT).getMetaId(), yearDebit == null ? BigDecimal.ZERO : yearDebit);
            BigDecimal yearCredit = row.getBigDecimal(cur.getInitBalanceField(MCT.YEAR_CREDIT).getMetaId());
            this.mulCurBal.put(cur.getBalanceField(MCT.YEAR_CREDIT).getMetaId(), yearCredit == null ? BigDecimal.ZERO : yearCredit);
        }
    }

    public void addInitBal(InitBalInfo balInfo) {
        this.beginfor = this.beginfor.add(balInfo.getBeginfor());
        this.beginlocal = this.beginlocal.add(balInfo.getBeginlocal());
        this.beginqty = this.beginqty.add(balInfo.getBeginqty());
        this.endfor = this.endfor.add(balInfo.getEndfor());
        this.endlocal = this.endlocal.add(balInfo.getEndlocal());
        this.endqty = this.endqty.add(balInfo.getEndqty());
        this.yearcreditfor = this.yearcreditfor.add(balInfo.getYearcreditfor());
        this.yearcreditlocal = this.yearcreditlocal.add(balInfo.getYearcreditlocal());
        this.yearcreditqty = this.yearcreditqty.add(balInfo.getYearcreditqty());
        this.yeardebitfor = this.yeardebitfor.add(balInfo.getYeardebitfor());
        this.yeardebitlocal = this.yeardebitlocal.add(balInfo.getYeardebitlocal());
        this.yeardebitqty = this.yeardebitqty.add(balInfo.getYeardebitqty());
        for (Map.Entry<String, BigDecimal> entry : this.mulCurBal.entrySet()) {
            this.mulCurBal.put(entry.getKey(), this.mulCurBal.get(entry.getKey()).add(balInfo.getMulCurBal().get(entry.getKey())));
        }
    }

    public long getOrg() {
        return this.org;
    }

    public void setOrg(long org) {
        this.org = org;
    }

    public long getBookType() {
        return this.bookType;
    }

    public void setBookType(long bookType) {
        this.bookType = bookType;
    }

    public long getAccounttable() {
        return this.accounttable;
    }

    public void setAccounttable(long accounttable) {
        this.accounttable = accounttable;
    }

    public long getAccount() {
        return this.account;
    }

    public void setAccount(long account) {
        this.account = account;
    }

    public long getAssgrp() {
        return this.assgrp;
    }

    public void setAssgrp(long assgrp) {
        this.assgrp = assgrp;
    }

    public long getCurrency() {
        return this.currency;
    }

    public void setCurrency(long currency) {
        this.currency = currency;
    }

    public long getMeasureunit() {
        return this.measureunit;
    }

    public void setMeasureunit(long measureunit) {
        this.measureunit = measureunit;
    }

    public BigDecimal getEndqty() {
        return this.endqty;
    }

    public void setEndqty(BigDecimal endqty) {
        this.endqty = endqty;
    }

    public BigDecimal getBeginqty() {
        return this.beginqty;
    }

    public void setBeginqty(BigDecimal beginqty) {
        this.beginqty = beginqty;
    }

    public BigDecimal getBeginfor() {
        return this.beginfor;
    }

    public void setBeginfor(BigDecimal beginfor) {
        this.beginfor = beginfor;
    }

    public BigDecimal getBeginlocal() {
        return this.beginlocal;
    }

    public void setBeginlocal(BigDecimal beginlocal) {
        this.beginlocal = beginlocal;
    }

    public BigDecimal getEndfor() {
        return this.endfor;
    }

    public void setEndfor(BigDecimal endfor) {
        this.endfor = endfor;
    }

    public BigDecimal getEndlocal() {
        return this.endlocal;
    }

    public void setEndlocal(BigDecimal endlocal) {
        this.endlocal = endlocal;
    }

    public BigDecimal getYeardebitqty() {
        return this.yeardebitqty;
    }

    public void setYeardebitqty(BigDecimal yeardebitqty) {
        this.yeardebitqty = yeardebitqty;
    }

    public BigDecimal getYeardebitfor() {
        return this.yeardebitfor;
    }

    public void setYeardebitfor(BigDecimal yeardebitfor) {
        this.yeardebitfor = yeardebitfor;
    }

    public BigDecimal getYeardebitlocal() {
        return this.yeardebitlocal;
    }

    public void setYeardebitlocal(BigDecimal yeardebitlocal) {
        this.yeardebitlocal = yeardebitlocal;
    }

    public BigDecimal getYearcreditqty() {
        return this.yearcreditqty;
    }

    public void setYearcreditqty(BigDecimal yearcreditqty) {
        this.yearcreditqty = yearcreditqty;
    }

    public BigDecimal getYearcreditfor() {
        return this.yearcreditfor;
    }

    public void setYearcreditfor(BigDecimal yearcreditfor) {
        this.yearcreditfor = yearcreditfor;
    }

    public BigDecimal getYearcreditlocal() {
        return this.yearcreditlocal;
    }

    public void setYearcreditlocal(BigDecimal yearcreditlocal) {
        this.yearcreditlocal = yearcreditlocal;
    }

    public long getLastPeriodId() {
        return this.lastPeriodId;
    }

    public void setLastPeriodId(long lastPeriodId) {
        this.lastPeriodId = lastPeriodId;
    }

    public boolean isExist() {
        return this.exist;
    }

    public void setExist(boolean exist) {
        this.exist = exist;
    }

    public boolean isFirst() {
        return this.first;
    }

    public void setFirst(boolean first) {
        this.first = first;
    }

    public List<BalInfo> getInfoTemp() {
        return this.infoTemp;
    }

    public List<BalInfo> getUpdateList() {
        return this.updateList;
    }

    public List<Object> getRmvList() {
        return this.rmvList;
    }

    public List<DynamicObject> getInserts() {
        return this.inserts;
    }

    public List<Long> getComassist() {
        return this.comassist;
    }

    public Map<String, BigDecimal> getMulCurBal() {
        return this.mulCurBal;
    }

    public void setMulCurBal(Map<String, BigDecimal> mulCurBal) {
        this.mulCurBal = mulCurBal;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void clear() {
        this.infoTemp.clear();
        this.inserts.clear();
        this.updateList.clear();
        this.rmvList.clear();
    }
}

