/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocess.opservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.business.service.voucher.writeoff.WriteOffOptionService;
import kd.fi.gl.business.vo.voucher.BookedDate;
import kd.fi.gl.enums.AutoAgainst;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.voucher.relation.VchRelationId;
import kd.fi.gl.voucher.relation.VoucherRelationHelper;

public class AutoAgainstService {
    private static final String ADJUST_EX_RATE = "2";

    public static void autoCreateAgainstVoucher(DynamicObject[] dataEntities, OperationResult operationResult) {
        OperationResult result;
        ArrayList successIdList = new ArrayList(operationResult.getSuccessPkIds());
        HashSet<Long> voucherIdSet = new HashSet<Long>(8);
        HashMap<Long, Long> vchIdToPeriodIdMap = new HashMap<Long, Long>(8);
        HashMap<Long, String> orgNameMap = new HashMap<Long, String>(8);
        for (DynamicObject dataEntity : dataEntities) {
            if (!ADJUST_EX_RATE.equals(dataEntity.getString("sourcetype"))) continue;
            Long vchId = (Long)dataEntity.getPkValue();
            voucherIdSet.add(vchId);
            vchIdToPeriodIdMap.put(vchId, dataEntity.getLong("period.id"));
            orgNameMap.put(vchId, dataEntity.getString("org.name"));
        }
        Map billNoMap = operationResult.getBillNos();
        HashMap<Long, Long> vchIdToBillIdMap = new HashMap<Long, Long>(8);
        HashMap<Long, BookedDate> vchIdToDateMap = new HashMap<Long, BookedDate>(8);
        for (Long vchId : voucherIdSet) {
            List voucherRefRelationList = VoucherRelationHelper.getVoucherRelationIds((long)vchId);
            if (!CollectionUtils.isNotEmpty((Collection)voucherRefRelationList)) continue;
            Long billId = ((VchRelationId)voucherRefRelationList.get(0)).getBillId();
            Long periodId = (Long)vchIdToPeriodIdMap.get(vchId);
            DynamicObject dynamicObject = PeriodUtil.getNextPeriod((Object)periodId, (boolean)false);
            if (Objects.nonNull(dynamicObject)) {
                vchIdToBillIdMap.put(vchId, billId);
                Date date = dynamicObject.getDate("begindate");
                vchIdToDateMap.put(vchId, new BookedDate(dynamicObject.getLong("id"), date, date));
                continue;
            }
            AutoAgainstService.addAgainstOperateErrorInfo(vchId, ResManager.loadKDString((String)"%s\u672a\u7ef4\u62a4\u51b2\u9500\u51ed\u8bc1\u7684\u4f1a\u8ba1\u5e74\u5ea6\uff0c\u65e0\u6cd5\u751f\u6210\u76f8\u5173\u51ed\u8bc1\u3002", (String)"AutoAgainstService_0", (String)GLApp.instance.oppluginModule(), (Object[])new Object[]{orgNameMap.get(vchId)}), operationResult, billNoMap);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)AutoAgainstService.class.getName(), (String)"gl_adjustexchangerate", (String)String.join((CharSequence)",", "id", "autoagainsttype"), (QFilter[])new QFilter[]{new QFilter("id", "in", vchIdToBillIdMap.values())}, null);
        HashMap<Long, String> billIdToAgainstTypeMap = new HashMap<Long, String>(8);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            billIdToAgainstTypeMap.put(row.getLong("id"), row.getString("autoagainsttype"));
        }
        HashSet redAgainstVchIdSet = new HashSet(8);
        HashSet blueAgainstVchIdSet = new HashSet(8);
        for (Map.Entry entry : vchIdToBillIdMap.entrySet()) {
            Long billId = (Long)entry.getValue();
            String againstType = billIdToAgainstTypeMap.getOrDefault(billId, AutoAgainst.NOT_AGAINST.getValue());
            if (AutoAgainst.RED_AGAINST.getValue().equals(againstType)) {
                redAgainstVchIdSet.add(entry.getKey());
                continue;
            }
            if (!AutoAgainst.BLUE_AGAINST.getValue().equals(againstType)) continue;
            blueAgainstVchIdSet.add(entry.getKey());
        }
        OperateOption operateOption = OperateOption.create();
        WriteOffOptionService.setBookedDate((OperateOption)operateOption, vchIdToDateMap);
        ArrayList arrayList = new ArrayList(8);
        if (CollectionUtils.isNotEmpty(redAgainstVchIdSet)) {
            result = OperationServiceHelper.executeOperate((String)"voucheragainst", (String)"gl_voucher", (Object[])redAgainstVchIdSet.toArray(new Long[0]), (OperateOption)operateOption);
            arrayList.addAll(result.getAllErrorOrValidateInfo());
        }
        if (CollectionUtils.isNotEmpty(blueAgainstVchIdSet)) {
            result = OperationServiceHelper.executeOperate((String)"bluewriteoff", (String)"gl_voucher", (Object[])blueAgainstVchIdSet.toArray(new Long[0]), (OperateOption)operateOption);
            arrayList.addAll(result.getAllErrorOrValidateInfo());
        }
        for (IOperateInfo errorInfo : arrayList) {
            AutoAgainstService.addAgainstOperateErrorInfo(errorInfo.getPkValue(), errorInfo.getMessage(), operationResult, billNoMap);
        }
        operationResult.setSuccessPkIds(successIdList);
    }

    private static void addAgainstOperateErrorInfo(Object pkValue, String errorMsg, OperationResult operationResult, Map<Object, String> billNoMap) {
        OperateErrorInfo errorInfo = new OperateErrorInfo();
        String billNo = billNoMap.get(pkValue);
        String msg = ResManager.loadKDString((String)"%1$s\u81ea\u52a8\u751f\u6210\u51ed\u8bc1\u51b2\u9500\u5931\u8d25\uff1a%2$s", (String)"AutoAgainstService_1", (String)"fi-gl-opplugin", (Object[])new Object[]{billNo, errorMsg});
        errorInfo.setMessage(msg);
        errorInfo.setPkValue(pkValue);
        errorInfo.setErrorLevel(ErrorLevel.Error.name());
        operationResult.addErrorInfo(errorInfo);
    }
}

