/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.operateservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;

public abstract class AbstractFinalProcessingDelVchOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("name");
        fieldKeys.add(this.getBookTypeFieldKey());
    }

    protected abstract String getBookTypeFieldKey();

    protected abstract String getVoucherRelationType();

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList successDyns = new ArrayList(dataEntities.length);
        HashMap<Object, String> pkToError = new HashMap<Object, String>(dataEntities.length);
        HashMap<DynamicObject, List> scheme2vouchers = new HashMap<DynamicObject, List>(dataEntities.length);
        ArrayList successPks = new ArrayList(dataEntities.length);
        for (DynamicObject dyn : dataEntities) {
            long bookTypeId;
            StringBuilder msg = new StringBuilder();
            long orgId = dyn.getLong("org_id");
            AccountBookInfo accountBookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)(bookTypeId = dyn.getLong(this.getBookTypeFieldKey() + "_id")));
            if (accountBookInfo == null) {
                msg.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u8be5\u65b9\u6848\u7684\u8d26\u7c3f\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"AbstractFinalProcessingDelVchOp_0", (String)"fi-gl-opplugin", (Object[])new Object[0]), dyn.getString("name")));
            } else {
                long curPeriodId = accountBookInfo.getCurPeriodId();
                Object pkValue = dyn.getPkValue();
                QFilter srcEntityFilter = new QFilter("srcentity", "=", pkValue);
                QFilter typeFilter = new QFilter("type", "=", (Object)this.getVoucherRelationType());
                QFilter periodFilter = new QFilter("period", "=", (Object)curPeriodId);
                List voucherIds = QueryServiceHelper.query((String)"gl_voucherrelation", (String)"targentity", (QFilter[])new QFilter[]{srcEntityFilter, typeFilter, periodFilter}).stream().map(x -> x.get("targentity")).collect(Collectors.toList());
                if (voucherIds.isEmpty()) {
                    msg.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u8be5\u65b9\u6848\u672a\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"AbstractFinalProcessingDelVchOp_1", (String)"fi-gl-opplugin", (Object[])new Object[0]), dyn.getString("name")));
                } else {
                    scheme2vouchers.put(dyn, voucherIds);
                }
            }
            if (msg.length() <= 0) continue;
            pkToError.put(dyn.getPkValue(), msg.toString());
        }
        scheme2vouchers.forEach((k, v) -> {
            StringBuilder msg = new StringBuilder();
            v.removeAll(successPks);
            if (!v.isEmpty()) {
                OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"gl_voucher", (Object[])v.toArray(), null);
                successPks.addAll(result.getSuccessPkIds());
                if (!result.isSuccess()) {
                    int successCount = result.getSuccessPkIds().size();
                    if (successCount > 0) {
                        msg.append(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u201c%1$s\u201d\u5220\u9664\u51ed\u8bc1\u6210\u529f%2$d\u6761\uff0c\u90e8\u5206\u5931\u8d25\u3002", (String)"AbstractFinalProcessingDelVchOp_2", (String)"fi-gl-opplugin", (Object[])new Object[0]), k.getString("name"), successCount));
                    } else {
                        msg.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u8be5\u65b9\u6848\u5220\u9664\u51ed\u8bc1\u5931\u8d25\u3002", (String)"AbstractFinalProcessingDelVchOp_3", (String)"fi-gl-opplugin", (Object[])new Object[0]), k.getString("name")));
                    }
                    List infos = result.getAllErrorOrValidateInfo();
                    for (IOperateInfo info : infos) {
                        msg.append("\n");
                        msg.append(info.getMessage());
                    }
                }
                if (msg.length() > 0) {
                    pkToError.put(k.getPkValue(), msg.toString());
                } else {
                    successDyns.add(k);
                }
            }
        });
        if (!pkToError.isEmpty()) {
            OperationResult delResult = this.getOperationResult();
            for (Map.Entry errorInfo : pkToError.entrySet()) {
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo("DelVchError", ErrorLevel.FatalError, errorInfo.getKey());
                operateErrorInfo.setMessage((String)errorInfo.getValue());
                operateErrorInfo.setTitle(ResManager.loadKDString((String)"\u5220\u9664\u51ed\u8bc1", (String)"AbstractFinalProcessingDelVchOp_4", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                delResult.addErrorInfo(operateErrorInfo);
            }
            delResult.setSuccess(false);
            delResult.setMessage("");
        }
        e.setDataEntities(successDyns.toArray(new DynamicObject[0]));
    }
}

